/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.olu;

import com.contrastsecurity.thirdparty.ohh.AtomicHistogram;
import com.contrastsecurity.thirdparty.ohh.Histogram;
import com.contrastsecurity.thirdparty.ohh.WriterReaderPhaser;
import com.contrastsecurity.thirdparty.olu.IntervalEstimator;
import com.contrastsecurity.thirdparty.olu.PauseDetector;
import com.contrastsecurity.thirdparty.olu.PauseDetectorListener;
import com.contrastsecurity.thirdparty.olu.SimplePauseDetector;
import com.contrastsecurity.thirdparty.olu.TimeCappedMovingAverageIntervalEstimator;
import com.contrastsecurity.thirdparty.olu.TimeServices;
import java.lang.ref.WeakReference;

public class LatencyStats {
    private static Builder defaultBuilder = new Builder();
    private static final TimeServices.ScheduledExecutor latencyStatsScheduledExecutor = new TimeServices.ScheduledExecutor();
    private static PauseDetector defaultPauseDetector;
    private final long lowestTrackableLatency;
    private final long highestTrackableLatency;
    private final int numberOfSignificantValueDigits;
    private volatile AtomicHistogram activeRecordingHistogram;
    private Histogram activePauseCorrectionsHistogram;
    private AtomicHistogram inactiveRawDataHistogram;
    private Histogram inactivePauseCorrectionsHistogram;
    private final WriterReaderPhaser recordingPhaser = new WriterReaderPhaser();
    private final PauseTracker pauseTracker;
    private final IntervalEstimator intervalEstimator;
    private final PauseDetector pauseDetector;

    public static void setDefaultPauseDetector(PauseDetector pauseDetector) {
        defaultPauseDetector = pauseDetector;
    }

    public static PauseDetector getDefaultPauseDetector() {
        return defaultPauseDetector;
    }

    public LatencyStats() {
        this(defaultBuilder.lowestTrackableLatency, defaultBuilder.highestTrackableLatency, defaultBuilder.numberOfSignificantValueDigits, defaultBuilder.intervalEstimatorWindowLength, defaultBuilder.intervalEstimatorTimeCap, defaultBuilder.pauseDetector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public LatencyStats(long l2, long l3, int n2, int n3, long l4, PauseDetector pauseDetector) {
        if (pauseDetector == null) {
            if (defaultPauseDetector == null) {
                Class<LatencyStats> clazz = LatencyStats.class;
                // MONITORENTER : com.contrastsecurity.thirdparty.olu.LatencyStats.class
                if (defaultPauseDetector == null) {
                    defaultPauseDetector = new SimplePauseDetector();
                }
                // MONITOREXIT : clazz
            }
            this.pauseDetector = defaultPauseDetector;
        } else {
            this.pauseDetector = pauseDetector;
        }
        this.lowestTrackableLatency = l2;
        this.highestTrackableLatency = l3;
        this.numberOfSignificantValueDigits = n2;
        this.activeRecordingHistogram = new AtomicHistogram(l2, l3, n2);
        this.inactiveRawDataHistogram = new AtomicHistogram(l2, l3, n2);
        this.activePauseCorrectionsHistogram = new Histogram(l2, l3, n2);
        this.inactivePauseCorrectionsHistogram = new Histogram(l2, l3, n2);
        this.intervalEstimator = new TimeCappedMovingAverageIntervalEstimator(n3, l4, this.pauseDetector);
        this.pauseTracker = new PauseTracker(this.pauseDetector, this);
        long l5 = System.currentTimeMillis();
        this.activeRecordingHistogram.setStartTimeStamp(l5);
        this.activePauseCorrectionsHistogram.setStartTimeStamp(l5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordLatency(long l2) {
        long l3 = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.trackRecordingInterval();
            this.activeRecordingHistogram.recordValue(l2);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(l3);
        }
    }

    public synchronized Histogram getIntervalHistogram() {
        Histogram histogram = new Histogram(this.lowestTrackableLatency, this.highestTrackableLatency, this.numberOfSignificantValueDigits);
        this.getIntervalHistogramInto(histogram);
        return histogram;
    }

    public synchronized void getIntervalHistogramInto(Histogram histogram) {
        try {
            this.recordingPhaser.readerLock();
            this.updateHistograms();
            this.inactiveRawDataHistogram.copyInto(histogram);
            histogram.add(this.inactivePauseCorrectionsHistogram);
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }

    public synchronized void addIntervalHistogramTo(Histogram histogram) {
        try {
            this.recordingPhaser.readerLock();
            this.updateHistograms();
            histogram.add(this.inactiveRawDataHistogram);
            histogram.add(this.inactivePauseCorrectionsHistogram);
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }

    public synchronized Histogram getLatestUncorrectedIntervalHistogram() {
        try {
            this.recordingPhaser.readerLock();
            Histogram histogram = new Histogram(this.lowestTrackableLatency, this.highestTrackableLatency, this.numberOfSignificantValueDigits);
            this.getLatestUncorrectedIntervalHistogramInto(histogram);
            Histogram histogram2 = histogram;
            return histogram2;
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }

    public synchronized void getLatestUncorrectedIntervalHistogramInto(Histogram histogram) {
        try {
            this.recordingPhaser.readerLock();
            this.inactiveRawDataHistogram.copyInto(histogram);
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }

    public synchronized void stop() {
        this.pauseTracker.stop();
        latencyStatsScheduledExecutor.shutdown();
    }

    public IntervalEstimator getIntervalEstimator() {
        return this.intervalEstimator;
    }

    public PauseDetector getPauseDetector() {
        return this.pauseDetector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void recordDetectedPause(long l2, long l3) {
        long l4 = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            long l5 = this.intervalEstimator.getEstimatedInterval(l3);
            long l6 = l2 - l5;
            if (l6 >= l5) {
                this.activePauseCorrectionsHistogram.recordValueWithExpectedInterval(l6, l5);
            }
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(l4);
        }
    }

    private void trackRecordingInterval() {
        long l2 = TimeServices.nanoTime();
        this.intervalEstimator.recordInterval(l2);
    }

    private void swapRecordingHistograms() {
        AtomicHistogram atomicHistogram = this.inactiveRawDataHistogram;
        this.inactiveRawDataHistogram = this.activeRecordingHistogram;
        this.activeRecordingHistogram = atomicHistogram;
    }

    private void swapPauseCorrectionHistograms() {
        Histogram histogram = this.inactivePauseCorrectionsHistogram;
        this.inactivePauseCorrectionsHistogram = this.activePauseCorrectionsHistogram;
        this.activePauseCorrectionsHistogram = histogram;
    }

    private synchronized void swapHistograms() {
        this.swapRecordingHistograms();
        this.swapPauseCorrectionHistograms();
    }

    private synchronized void updateHistograms() {
        try {
            this.recordingPhaser.readerLock();
            this.inactiveRawDataHistogram.reset();
            this.inactivePauseCorrectionsHistogram.reset();
            this.swapHistograms();
            long l2 = System.currentTimeMillis();
            this.activeRecordingHistogram.setStartTimeStamp(l2);
            this.activePauseCorrectionsHistogram.setStartTimeStamp(l2);
            this.inactiveRawDataHistogram.setEndTimeStamp(l2);
            this.inactivePauseCorrectionsHistogram.setEndTimeStamp(l2);
            this.recordingPhaser.flipPhase();
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }

    private static class PauseTracker
    extends WeakReference<LatencyStats>
    implements PauseDetectorListener {
        final PauseDetector pauseDetector;

        PauseTracker(PauseDetector pauseDetector, LatencyStats latencyStats) {
            super(latencyStats);
            this.pauseDetector = pauseDetector;
            pauseDetector.addListener(this);
        }

        public void stop() {
            this.pauseDetector.removeListener(this);
        }

        @Override
        public void handlePauseEvent(long l2, long l3) {
            LatencyStats latencyStats = (LatencyStats)this.get();
            if (latencyStats != null) {
                latencyStats.recordDetectedPause(l2, l3);
            } else {
                this.stop();
            }
        }
    }

    public static class Builder {
        private long lowestTrackableLatency = 1000L;
        private long highestTrackableLatency = 3600000000000L;
        private int numberOfSignificantValueDigits = 2;
        private int intervalEstimatorWindowLength = 1024;
        private long intervalEstimatorTimeCap = 10000000000L;
        private PauseDetector pauseDetector = null;

        public static Builder create() {
            return new Builder();
        }

        public Builder lowestTrackableLatency(long l2) {
            this.lowestTrackableLatency = l2;
            return this;
        }

        public Builder highestTrackableLatency(long l2) {
            this.highestTrackableLatency = l2;
            return this;
        }

        public Builder numberOfSignificantValueDigits(int n2) {
            this.numberOfSignificantValueDigits = n2;
            return this;
        }

        public Builder intervalEstimatorWindowLength(int n2) {
            this.intervalEstimatorWindowLength = n2;
            return this;
        }

        public Builder intervalEstimatorTimeCap(long l2) {
            this.intervalEstimatorTimeCap = l2;
            return this;
        }

        public Builder pauseDetector(PauseDetector pauseDetector) {
            this.pauseDetector = pauseDetector;
            return this;
        }

        public LatencyStats build() {
            return new LatencyStats(this.lowestTrackableLatency, this.highestTrackableLatency, this.numberOfSignificantValueDigits, this.intervalEstimatorWindowLength, this.intervalEstimatorTimeCap, this.pauseDetector);
        }
    }
}

