/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.olu;

import com.contrastsecurity.thirdparty.olu.IntervalEstimator;
import java.util.concurrent.atomic.AtomicLong;

public class MovingAverageIntervalEstimator
extends IntervalEstimator {
    protected final long[] intervalEndTimes;
    protected final int windowMagnitude;
    protected final int windowLength;
    protected final int windowMask;
    protected AtomicLong count = new AtomicLong(0L);

    public MovingAverageIntervalEstimator(int n2) {
        this.windowMagnitude = (int)Math.ceil(Math.log(n2) / Math.log(2.0));
        this.windowLength = (int)Math.pow(2.0, this.windowMagnitude);
        this.windowMask = this.windowLength - 1;
        this.intervalEndTimes = new long[this.windowLength];
        for (int i2 = 0; i2 < this.intervalEndTimes.length; ++i2) {
            this.intervalEndTimes[i2] = Long.MIN_VALUE;
        }
    }

    @Override
    public void recordInterval(long l2) {
        this.recordIntervalAndReturnWindowPosition(l2);
    }

    int recordIntervalAndReturnWindowPosition(long l2) {
        long l3 = this.count.getAndIncrement();
        int n2 = (int)(l3 & (long)this.windowMask);
        this.intervalEndTimes[n2] = l2;
        return n2;
    }

    @Override
    public long getEstimatedInterval(long l2) {
        long l3;
        long l4;
        long l5 = this.count.get();
        if (l5 < (long)this.windowLength) {
            return Long.MAX_VALUE;
        }
        do {
            l4 = l5;
            int n2 = (int)(l5 & (long)this.windowMask);
            int n3 = (int)(l5 + (long)this.windowLength - 1L & (long)this.windowMask);
            long l6 = this.intervalEndTimes[n2];
            long l7 = Math.max(this.intervalEndTimes[n3], l2);
            l3 = l7 - l6;
        } while ((l5 = this.count.get()) != l4 || l3 < 0L);
        long l8 = l3 / (long)(this.windowLength - 1);
        return Math.max(l8, 1L);
    }

    protected int getCurrentPosition() {
        return (int)(this.count.get() & (long)this.windowMask);
    }
}

