/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.conversion;

import com.contrastsecurity.thirdparty.omv2.ConversionException;
import com.contrastsecurity.thirdparty.omv2.ConversionHandler;
import com.contrastsecurity.thirdparty.omv2.conversion.Converter;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class BooleanCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();
    private static Converter stringConverter = new Converter(){

        public Object convert(Object object) {
            return !((String)object).equalsIgnoreCase("false") && !((String)object).equalsIgnoreCase("no") && !((String)object).equalsIgnoreCase("off") && !"0".equals(object) && !"".equals(object);
        }
    };

    public Object convertFrom(Object object) {
        if (!CNV.containsKey(object.getClass())) {
            throw new ConversionException("cannot convert type: " + object.getClass().getName() + " to: " + Boolean.class.getName());
        }
        return CNV.get(object.getClass()).convert(object);
    }

    public boolean canConvertFrom(Class clazz) {
        return CNV.containsKey(clazz);
    }

    static {
        CNV.put(String.class, stringConverter);
        CNV.put(Object.class, new Converter(){

            public Object convert(Object object) {
                return stringConverter.convert(String.valueOf(object));
            }
        });
        CNV.put(Boolean.class, new Converter(){

            public Object convert(Object object) {
                return object;
            }
        });
        CNV.put(Integer.class, new Converter(){

            public Boolean convert(Object object) {
                return (Integer)object > 0;
            }
        });
        CNV.put(Float.class, new Converter(){

            public Boolean convert(Object object) {
                return ((Float)object).floatValue() > 0.0f;
            }
        });
        CNV.put(Double.class, new Converter(){

            public Boolean convert(Object object) {
                return (Double)object > 0.0;
            }
        });
        CNV.put(Short.class, new Converter(){

            public Boolean convert(Object object) {
                return (Short)object > 0;
            }
        });
        CNV.put(Long.class, new Converter(){

            public Boolean convert(Object object) {
                return (Long)object > 0L;
            }
        });
        CNV.put(Boolean.TYPE, new Converter(){

            public Boolean convert(Object object) {
                return (boolean)((Boolean)object);
            }
        });
        CNV.put(BigDecimal.class, new Converter(){

            public Boolean convert(Object object) {
                return ((BigDecimal)object).doubleValue() > 0.0;
            }
        });
    }
}

