/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.integration.impl;

import com.contrastsecurity.thirdparty.omv2.ParserConfiguration;
import com.contrastsecurity.thirdparty.omv2.UnresolveablePropertyException;
import com.contrastsecurity.thirdparty.omv2.integration.VariableResolver;
import com.contrastsecurity.thirdparty.omv2.integration.VariableResolverFactory;
import com.contrastsecurity.thirdparty.omv2.integration.impl.BaseVariableResolverFactory;
import com.contrastsecurity.thirdparty.omv2.integration.impl.MapVariableResolverFactory;
import com.contrastsecurity.thirdparty.omv2.integration.impl.SimpleValueResolver;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassImportResolverFactory
extends BaseVariableResolverFactory {
    private Set<String> packageImports;
    private ClassLoader classLoader;
    private Map<String, Object> imports;
    private Map<String, Object> dynImports;

    public ClassImportResolverFactory(ParserConfiguration parserConfiguration, VariableResolverFactory variableResolverFactory, boolean bl2) {
        if (parserConfiguration != null) {
            if (!bl2) {
                this.packageImports = parserConfiguration.getPackageImports();
            }
            this.classLoader = parserConfiguration.getClassLoader();
            this.imports = Collections.unmodifiableMap(parserConfiguration.getImports());
        } else {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
        this.nextFactory = variableResolverFactory;
    }

    @Override
    public VariableResolver createVariable(String string, Object object) {
        if (this.nextFactory == null) {
            this.nextFactory = new MapVariableResolverFactory(new HashMap());
        }
        return this.nextFactory.createVariable(string, object);
    }

    public VariableResolver createVariable(String string, Object object, Class clazz) {
        if (this.nextFactory == null) {
            this.nextFactory = new MapVariableResolverFactory(new HashMap());
        }
        return this.nextFactory.createVariable(string, object);
    }

    public Class addClass(Class clazz) {
        if (this.dynImports == null) {
            this.dynImports = new HashMap<String, Object>();
        }
        this.dynImports.put(clazz.getSimpleName(), clazz);
        return clazz;
    }

    @Override
    public boolean isTarget(String string) {
        if (string == null) {
            return false;
        }
        return this.imports != null && this.imports.containsKey(string) || this.dynImports != null && this.dynImports.containsKey(string);
    }

    @Override
    public boolean isResolveable(String string) {
        if (string == null) {
            return false;
        }
        if (this.imports != null && this.imports.containsKey(string) || this.dynImports != null && this.dynImports.containsKey(string) || this.isNextResolveable(string)) {
            return true;
        }
        if (this.packageImports != null) {
            for (String string2 : this.packageImports) {
                try {
                    this.addClass(this.classLoader.loadClass(string2 + "." + string));
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
            }
        }
        return false;
    }

    @Override
    public VariableResolver getVariableResolver(String string) {
        if (this.isResolveable(string)) {
            if (this.imports != null && this.imports.containsKey(string)) {
                return new SimpleValueResolver(this.imports.get(string));
            }
            if (this.dynImports != null && this.dynImports.containsKey(string)) {
                return new SimpleValueResolver(this.dynImports.get(string));
            }
            if (this.nextFactory != null) {
                return this.nextFactory.getVariableResolver(string);
            }
        }
        throw new UnresolveablePropertyException("unable to resolve variable '" + string + "'");
    }

    public void clear() {
    }

    public Map<String, Object> getImportedClasses() {
        return this.imports;
    }

    public void addPackageImport(String string) {
        if (this.packageImports == null) {
            this.packageImports = new HashSet<String>();
        }
        this.packageImports.add(string);
    }

    @Override
    public Set<String> getKnownVariables() {
        return this.nextFactory == null ? new HashSet(0) : this.nextFactory.getKnownVariables();
    }
}

