/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.optimizers.dynamic;

import com.contrastsecurity.thirdparty.omv2.optimizers.dynamic.DynamicAccessor;
import com.contrastsecurity.thirdparty.omv2.util.MVELClassLoader;
import java.util.LinkedList;

public class DynamicClassLoader
extends ClassLoader
implements MVELClassLoader {
    private int totalClasses;
    private int tenureLimit;
    private final LinkedList<DynamicAccessor> allAccessors = new LinkedList();

    public DynamicClassLoader(ClassLoader classLoader, int n2) {
        super(classLoader);
        this.tenureLimit = n2;
    }

    public Class defineClassX(String string, byte[] byArray, int n2, int n3) {
        ++this.totalClasses;
        return super.defineClass(string, byArray, n2, n3);
    }

    public int getTotalClasses() {
        return this.totalClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicAccessor registerDynamicAccessor(DynamicAccessor dynamicAccessor) {
        LinkedList<DynamicAccessor> linkedList = this.allAccessors;
        synchronized (linkedList) {
            this.allAccessors.add(dynamicAccessor);
            while (this.allAccessors.size() > this.tenureLimit) {
                DynamicAccessor dynamicAccessor2 = this.allAccessors.removeFirst();
                if (dynamicAccessor2 == null) continue;
                dynamicAccessor2.deoptimize();
            }
            assert (dynamicAccessor != null);
            return dynamicAccessor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deoptimizeAll() {
        LinkedList<DynamicAccessor> linkedList = this.allAccessors;
        synchronized (linkedList) {
            for (DynamicAccessor dynamicAccessor : this.allAccessors) {
                if (dynamicAccessor == null) continue;
                dynamicAccessor.deoptimize();
            }
            this.allAccessors.clear();
        }
    }

    public boolean isOverloaded() {
        return this.tenureLimit < this.totalClasses;
    }
}

