/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.boot;

import com.contrastsecurity.agent.ContrastLoaderAgent;
import com.contrastsecurity.agent.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DenylistedProcessCheck {
    private static final List<String> TOOLS = Arrays.asList("Eclipse", "com.intellij.idea.Main", "org.netbeans.Main", "org.apache.lucene.luke", "org.apache.solr.cli.SolrCLI", "org.jetbrains.kotlin.cli.utilities.MainKt", "scala.tools.nsc.Main", "scala.tools.nsc.MainGenericRunner", "scala.tools.nsc.ScalaDoc", "scala.tools.scalap.Main", "org.gradle.launcher.daemon.bootstrap.GradleDaemon", "org.gradle.launcher.GradleMain", "org.gradle.wrapper.GradleWrapperMain", "org.codehaus.classworlds.Launcher", "org.codehaus.plexus.classworlds.launcher.Launcher", "org.apache.tools.ant.launch.Launcher", "com.sun.tools.hat.Main", "sun.jvm.hotspot.jdi.SADebugServer", "sun.applet.Main", "jdk.tools.jaotc.Main", "sun.tools.jar.Main", "sun.security.tools.jarsigner.Main", "com.sun.tools.javac.Main", "jdk.javadoc.internal.tool.Main", "com.sun.tools.javah.Main", "com.sun.tools.javap.Main", "sun.tools.jcmd.JCmd", "sun.tools.jconsole.JConsole", "com.sun.tools.example.debug.tty.TTY", "com.sun.tools.jdeprscan.Main", "com.sun.tools.jdeps.Main", "jdk.jfr.internal.tool.Main", "sun.jvm.hotspot.SALauncher", "jdk.tools.jimage.Main", "sun.tools.jinfo.JInfo", "jdk.nashorn.tools.jjs.Main", "jdk.tools.jlink.internal.Main", "sun.tools.jmap.JMap", "jdk.tools.jmod.Main", "jdk.jpackage.main.Main", "sun.tools.jps.Jps", "com.sun.tools.script.shell.Main", "jdk.internal.jshell.tool.JShellToolProvider", "sun.tools.jstack.JStack", "sun.tools.jstat.Jstat", "sun.tools.jstatd.Jstatd", "sun.security.tools.keytool.Main", "com.sun.java.util.jar.pack.Driver", "sun.rmi.rmic.Main", "sun.rmi.server.Activation", "sun.rmi.registry.RegistryImpl", "sun.tools.serialver.SerialVer", "com.sun.tools.internal.ws.WsGen", "com.sun.tools.internal.ws.WsImport", "com.sun.tools.internal.xjc.Driver", "java.desktop/sun.applet.Main", "jdk.aot/jdk.tools.jaotc.Main", "jdk.jartool/sun.tools.jar.Main", "jdk.jartool/sun.security.tools.jarsigner.Main", "jdk.compiler/com.sun.tools.javac.Main", "jdk.javadoc/jdk.javadoc.internal.tool.Main", "jdk.compiler/com.sun.tools.javah.Main", "jdk.jdeps/com.sun.tools.javap.Main", "jdk.jcmd/sun.tools.jcmd.JCmd", "jdk.jconsole/sun.tools.jconsole.JConsole", "jdk.jdi/com.sun.tools.example.debug.tty.TTY", "jdk.jdeps/com.sun.tools.jdeprscan.Main", "jdk.jdeps/com.sun.tools.jdeps.Main", "jdk.jfr/jdk.jfr.internal.tool.Main", "jdk.hotspot.agent/sun.jvm.hotspot.SALauncher", "jdk.jlink/jdk.tools.jimage.Main", "jdk.jcmd/sun.tools.jinfo.JInfo", "jdk.scripting.nashorn.shell/jdk.nashorn.tools.jjs.Main", "jdk.jlink/jdk.tools.jlink.internal.Main", "jdk.jcmd/sun.tools.jmap.JMap", "jdk.jlink/jdk.tools.jmod.Main", "jdk.jpackage/jdk.jpackage.main.Main", "jdk.jcmd/sun.tools.jps.Jps", "java.scripting/com.sun.tools.script.shell.Main", "jdk.jshell/jdk.internal.jshell.tool.JShellToolProvider", "jdk.jcmd/sun.tools.jstack.JStack", "jdk.jcmd/sun.tools.jstat.Jstat", "jdk.jstatd/sun.tools.jstatd.Jstatd", "java.base/sun.security.tools.keytool.Main", "java.base/com.sun.java.util.jar.pack.Driver", "jdk.rmic/sun.rmi.rmic.Main", "java.rmi/sun.rmi.server.Activation", "java.rmi/sun.rmi.registry.RegistryImpl", "jdk.compiler/sun.tools.serialver.SerialVer", "jdk.xml.ws/com.sun.tools.internal.ws.WsGen", "jdk.xml.ws/com.sun.tools.internal.ws.WsImport", "jdk.xml.bind/com.sun.tools.internal.xjc.Driver");
    static final String ATTRIBUTE_PRE_MAIN = "Premain-Class";

    private DenylistedProcessCheck() {
    }

    public static boolean isDenied(String cmd) {
        if (cmd != null) {
            return DenylistedProcessCheck.isDeniedTool(cmd);
        }
        return System.getSecurityManager() == null ? DenylistedProcessCheck.isDeniedCommand() : AccessController.doPrivileged(DenylistedProcessCheck::isDeniedCommand);
    }

    private static boolean isDeniedTool(String cmd) {
        return DenylistedProcessCheck.isContrastAgent(cmd) || DenylistedProcessCheck.isTooling(cmd) || DenylistedProcessCheck.isTomcat(cmd) || DenylistedProcessCheck.isKaraf(cmd) || DenylistedProcessCheck.isGroovy(cmd) || DenylistedProcessCheck.isJython(cmd) || DenylistedProcessCheck.isJruby(cmd) || DenylistedProcessCheck.isJetty(cmd);
    }

    private static boolean isJetty(String cmd) {
        return Pattern.compile("(?:^|[/\\\\])start.jar(?: .*)? (?:--dry-run|--add-module)", 2).matcher(cmd).find();
    }

    private static boolean isContrastAgent(String cmd) {
        String matchingJar = DenylistedProcessCheck.agentCmdString(cmd);
        if (matchingJar == null) {
            return false;
        }
        return System.getSecurityManager() == null ? DenylistedProcessCheck.manifestMatchesContrast(matchingJar) : AccessController.doPrivileged(() -> DenylistedProcessCheck.manifestMatchesContrast(matchingJar));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean manifestMatchesContrast(String jar) {
        try (JarFile jarFile = new JarFile(jar);){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                boolean bl2 = false;
                return bl2;
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            if (mainAttributes == null) {
                boolean bl3 = false;
                return bl3;
            }
            String preMainClass = mainAttributes.getValue(ATTRIBUTE_PRE_MAIN);
            boolean bl4 = preMainClass != null && ContrastLoaderAgent.class.getName().equals(preMainClass);
            return bl4;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @VisibleForTesting
    static String agentCmdString(String cmd) {
        if (cmd == null) {
            return null;
        }
        Matcher matcher = Pattern.compile("^(.*contrast[^/\\\\]*\\.jar)(?: |$)", 2).matcher(cmd);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static boolean isGroovy(String cmd) {
        String groovyStarter = "org.codehaus.groovy.tools.GroovyStarter ";
        if (!cmd.startsWith("org.codehaus.groovy.tools.GroovyStarter ")) {
            return false;
        }
        int offset = cmd.indexOf("--main ");
        if (offset == -1) {
            return false;
        }
        return cmd.startsWith("org.codehaus.groovy.tools.FileSystemCompiler", offset += "--main ".length()) || cmd.startsWith("org.codehaus.groovy.tools.groovydoc.Main", offset) || cmd.startsWith("org.codehaus.groovy.antlr.java.Java2GroovyMain", offset) || cmd.startsWith("org.apache.groovy.groovysh.Main", offset) || cmd.startsWith("org.codehaus.groovy.tools.GrapeMain", offset) || cmd.startsWith("groovy.ui.Console", offset);
    }

    private static boolean isJython(String cmd) {
        String jython = "org.python.util.jython";
        if (!cmd.startsWith("org.python.util.jython")) {
            return false;
        }
        if (cmd.equals("org.python.util.jython")) {
            return true;
        }
        int offset = "org.python.util.jython".length() + 1;
        return cmd.startsWith("-V", offset) || cmd.startsWith("--version", offset) || cmd.startsWith("-h", offset) || cmd.startsWith("--help", offset);
    }

    private static boolean isJruby(String cmd) {
        int next;
        int temp;
        String jruby = "org.jruby.Main";
        if (!cmd.startsWith("org.jruby.Main")) {
            return false;
        }
        if (cmd.equals("org.jruby.Main")) {
            return true;
        }
        int lastIndex = cmd.indexOf(47, "org.jruby.Main".length() + 1);
        while ((temp = cmd.indexOf(47, next = lastIndex + 1)) != -1) {
            lastIndex = temp;
        }
        if (lastIndex == -1) {
            return false;
        }
        return cmd.startsWith("ast", ++lastIndex) || cmd.startsWith("erb", lastIndex) || cmd.startsWith("irb", lastIndex) || cmd.startsWith("jgem", lastIndex) || cmd.startsWith("jirb", lastIndex) || cmd.startsWith("jruby", lastIndex) || cmd.startsWith("jrubyc", lastIndex) || cmd.startsWith("racc", lastIndex);
    }

    private static String[] getProcCmdLine() throws IOException {
        Path path = Paths.get("/proc/self/cmdline", new String[0]);
        return Files.exists(path, new LinkOption[0]) ? new String(Files.readAllBytes(path)).split("\u0000") : null;
    }

    public static String[] getCommandLineJava9() throws Throwable {
        Class<?> processHandleClass = Class.forName("java.lang.ProcessHandle");
        Object currentHandle = processHandleClass.getMethod("current", new Class[0]).invoke(null, new Object[0]);
        Object info = processHandleClass.getMethod("info", new Class[0]).invoke(currentHandle, new Object[0]);
        Optional optionalCmd = (Optional)Class.forName("java.lang.ProcessHandle$Info").getMethod("arguments", new Class[0]).invoke(info, new Object[0]);
        return optionalCmd.orElse(null);
    }

    private static boolean isDeniedCommand() {
        String[] commandLine2;
        try {
            commandLine2 = DenylistedProcessCheck.getCommandLineJava9();
            if (commandLine2 != null) {
                return DenylistedProcessCheck.isDeniedCommand(commandLine2, 0);
            }
        }
        catch (Throwable commandLine2) {
            // empty catch block
        }
        try {
            commandLine2 = DenylistedProcessCheck.getProcCmdLine();
            if (commandLine2 == null) {
                return false;
            }
            if (commandLine2.length == 1) {
                return true;
            }
            return DenylistedProcessCheck.isDeniedCommand(commandLine2, 1);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static boolean isDeniedCommand(String[] parts, int startIndex) {
        if (parts.length <= startIndex) {
            return true;
        }
        for (int i2 = startIndex; i2 < parts.length; ++i2) {
            String part = parts[i2];
            if (part.charAt(0) != '-') {
                return false;
            }
            switch (part) {
                case "-version": 
                case "--version": 
                case "-fullversion": 
                case "--full-version": 
                case "-?": 
                case "-h": 
                case "-help": 
                case "--help": 
                case "-help-extra": 
                case "--help-extra": 
                case "-X": 
                case "--list-modules": 
                case "--validate-modules": 
                case "--describe-module": 
                case "--dry-run": {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isTooling(String cmd) {
        if (cmd == null) {
            return false;
        }
        for (String tool : TOOLS) {
            if (!cmd.startsWith(tool)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTomcat(String cmd) {
        return cmd.endsWith("catalina.startup.Bootstrap stop");
    }

    private static boolean isKaraf(String cmd) {
        return cmd.startsWith("org.apache.karaf") && !cmd.endsWith(".main.Main");
    }
}

