/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.config;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.BooleanOrDefault;
import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.commons.SimpleSleeper;
import com.contrastsecurity.agent.config.c.a;
import com.contrastsecurity.agent.config.c.b;
import com.contrastsecurity.agent.config.c.c;
import com.contrastsecurity.agent.config.d;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.config.enums.SaveReportMode;
import com.contrastsecurity.agent.config.enums.TraceMapStrategy;
import com.contrastsecurity.agent.config.exception.ContrastConfigurationException;
import com.contrastsecurity.agent.config.f;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.config.k;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.DiagnosticsDTM;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.DiagnosticsLoggerDTM;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.ServerSettingsAssessDTM;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.ServerSettingsDTM;
import com.contrastsecurity.agent.logging.LoggingConstants;
import com.contrastsecurity.agent.messages.app.settings.ApplicationAssessSettingsDTM;
import com.contrastsecurity.agent.messages.app.settings.ApplicationSettingsDTM;
import com.contrastsecurity.agent.messages.app.settings.protect.CommonConfigProtectionMode;
import com.contrastsecurity.agent.messages.app.settings.protect.ProtectionModeDTM;
import com.contrastsecurity.agent.messages.server.features.protect.LogLevel;
import com.contrastsecurity.agent.messages.server.features.protect.SyslogSeverity;
import com.contrastsecurity.agent.plugins.protect.ProtectRuleId;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

@DontObfuscate
public enum ConfigProperty {
    ZOMBIE_CHECK_PERIOD_MS(e.a(Integer.class).a(10000).e().b("On IBM systems, Contrast periodically checks to see if it is preventing a graceful JVM shutdown. This is the period (in milliseconds) between these checks. A negative value disables the checks").a(Category.PERFORMANCE).b(d.a("agent.java.zombie_check_period_ms")).h()),
    TELEMETRY_SEMANTIC_SQL_START_DATE(e.a(String.class).a("2020-04-01").e().b("Date and time (format yyyy-MM-dd 00:00:00z) at which to start the Protect SQLi semantic analysis experiment").a(Category.DIAGNOSTICS).b(d.a("agent.java.stx.sqli_semantic.start_date")).h()),
    TELEMETRY_SEMANTIC_SQL_EXPIRATION_DATE(e.a(String.class).a("2020-05-01").e().b("Date and time (format yyyy-MM-dd 00:00:00z) after which to the Protect SQLi semantic analysis experiment expires").a(Category.DIAGNOSTICS).b(d.a("agent.java.stx.sqli_semantic.expired_date")).h()),
    TELEMETRY_SEMANTIC_SQL_REPORT_INTERVAL(e.a(Long.class).a(300000L).e().b("Interval in millis for reporting Protect SQLi semantic analysis telemetry data").a(Category.DIAGNOSTICS).b(d.a("agent.java.stx.sqli_semantic.report_interval_ms")).h()),
    TELEMETRY_SEMANTIC_SQL_SAMPLE_SPACING(e.a(Integer.class).a(300000).e().b("frequency (expres in number of queries) with which to report SQL queries for the Protect SQLi semantic analysis experiment").a(Category.DIAGNOSTICS).b(d.a("agent.java.stx.sqli_semantic.sample_spacing")).h()),
    AGENT_METADATA(e.a(String.class).a("contrast.agent.metadata").c().b("Metadata from the agent to Contrast UI defined. The format should be HTTP Request header compatible where key=value pairs are separated by semicolons. Spaces between key and value and between entries is not significant. (e.g. key=value; key=value)").a(Category.GENERAL_PROPERTIES).b(d.a("application.metadata", true)).h()),
    SESSION_ID(e.a(String.class).c().b("Provide the ID of a session which already exists in the Contrast UI. Vulnerabilities discovered by the agent are associated with this session. If an invalid ID is supplied, the agent will be disabled. This option and `application.session_metadata` are mutually exclusive; if both are set, the agent will be disabled.").a(Category.GENERAL_PROPERTIES).g().b(d.a("application.session_id", true)).h()),
    SESSION_METADATA(e.a(String.class).c().b("Provide metadata which is used to create a new session ID in the Contrast UI. Vulnerabilities discovered by the agent are associated with this new session. This value should be formatted as key=value pairs (conforming to RFC 2253). Available key names for this configuration are branchName, buildNumber, commitHash, committer, gitTag, repository, testRun, and version. This option and `application.session_id` are mutually exclusive; if both are set the agent will be disabled.").a(Category.GENERAL_PROPERTIES).b(d.a("application.session_metadata", true)).h()),
    PROBABILISTIC_STARTUP(e.a(Integer.class).a((Integer)((Object)"contrast.startup.probabilistic")).a(-1).e().b("the percentage chance that the agent should startup (values are 1-99 inclusive)").a(Category.GENERAL_PROPERTIES).b(d.a("agent.probabilistic_startup")).h()),
    INVENTORY_PRUNE_LIBRARY_MANIFEST(e.a(Boolean.class).a((Boolean)((Object)"contrast.inventory.prune.library.manifest")).a((Boolean)true).b("limits the manifest information reported for libraries").a(Category.GENERAL_PROPERTIES).b(d.a("inventory.prune_package_details")).h()),
    INVENTORY_LIBRARIES(e.a(Boolean.class).a((Boolean)((Object)"contrast.inventory.libraries")).a((Boolean)true).b("controls whether libraries are analyzed").a(Category.GENERAL_PROPERTIES).b(d.a("inventory.analyze_libraries")).h()),
    LIBRARY_USAGE_REPORTING(e.a(Boolean.class).a((Boolean)((Object)"contrast.libraries.reporting")).a((Boolean)true).b("controls whether library usage is reported").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.library_usage.reporting.enable")).h()),
    EFFECTIVE_CONFIG_REPORTING(e.a(Boolean.class).a((Boolean)true).b("controls whether effective config is reported").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.effective_config.reporting.enable")).h()),
    COLLAPSING_QUEUE_SIZE(e.a(Integer.class).a(5000).e().b("Set the maximum size (in number of items) of the buffer used to collapse pending reports.").a(Category.INTERNAL_USAGE).b(d.a("agent.java.reporting.collapsing_queue_size")).h()),
    DEBUG_DUPLICATE_CHANGES(e.a(Boolean.class).a((Boolean)false).a(Category.INTERNAL_USAGE).e().b("NOTE: This setting intentionally causes IllegalStateExceptions when more than once type of change is applied simultaneously on the same method: (e.g. Two propagators).").b(d.a("agent.java.debug_duplicate_policy_changes")).h()),
    PRINT_ALL_THROWABLES(e.a(Boolean.class).a((Boolean)false).a(Category.INTERNAL_USAGE).e().b("NOTE: this setting can cause extreme performance degradation. Use with caution. Set to true to print a dump of every stacktrace to stdout. Prints a dump for each Throwable created on the JVM after the agent is initialized. This configuration is helpful for diagnosing issues where the agent instrumentation breaks fundamental JVM features, but the error is swallowed.").b(d.a("agent.java.print_all_throwables")).h()),
    PRINT_THREAD_DUMP_ON_SHUTDOWN(e.a(Boolean.class).a((Boolean)false).a(Category.INTERNAL_USAGE).e().b("Set to true to print a dump of stacktraces for all threads to stdout when the JVM is shut down. This configuration is helpful for diagnosing deadlocks.").b(d.a("agent.java.print_thread_dump_on_shutdown")).h()),
    COLLAPSING_WINDOW(e.a(Long.class).a(15000L).e().b("Set the time (in milliseconds) to wait before collapsing pending reports. Longer wait times may reduce the network traffic at the expense of consuming more memory.").a(Category.INTERNAL_USAGE).b(d.a("agent.java.reporting.collapsing_window_ms")).h()),
    AGENT_LOCATION(e.a(String.class).a("contrast.agent.location").c().e().b("set by the launcher agent to tell agents where the location of the agent jar").a(Category.INTERNAL_USAGE).d("TODO: looks launcher related. Remove.").h()),
    USE_HTTP_COMPRESSION(e.a(Boolean.class).a((Boolean)((Object)"contrast.agent.http.compression")).a((Boolean)true).e().b("set for debugging purposes, tells the Agent not to compress HTTP Request payloads; default true").a(Category.INTERNAL_USAGE).b(d.a("agent.java.enable_http_compression")).h()),
    IGNORE_CERTIFICATE_ERRORS(e.a(Boolean.class).a((Boolean)((Object)"contrast.agent.http.ignorecerterrors")).a((Boolean)false).b("whether certificate errors are ignored when talking to TeamServer").a(Category.DIAGNOSTICS).b(d.a("api.certificate.ignore_cert_errors", Lists.of("contrast.ignore_cert_errors", "api.ignore_cert_errors"))).h()),
    DEFAULT_ISOLATED_SOCKET_FACTORY(e.a(Boolean.class).a((Boolean)false).e().b("Configure the agent to use the default isolated socket strategy to avoid conflicts with container socket strategies. This option uses the default keystore and truststore").a(Category.DIAGNOSTICS).b(d.a("agent.java.default_isolated_socket_factory")).h()),
    ISOLATED_SOCKET_FACTORY(e.a(Boolean.class).a((Boolean)false).e().b("Configure the agent to use an isolated socket strategy to avoid conflicts with container socket strategies. This option attempts to access the configured keystore and truststore and falls back to the default if that fails").a(Category.DIAGNOSTICS).b(d.a("agent.java.isolated_socket_factory")).h()),
    EXPLICIT_SNI_SOCKET_FACTORY(e.a(Boolean.class).a((Boolean)false).e().b("set SNI information on TLS extension manually to avoid JDK bugs where the information is not sent in niche cases").a(Category.DIAGNOSTICS).b(d.a("api.explicit_sni_socket_factory")).h()),
    MQ_TELEMETRY(e.a(Boolean.class).a((Boolean)((Object)"contrast.mq")).a((Boolean)false).e().b("true, if the agent should send telemetry MQ messages -- false otherwise").a(Category.INTERNAL_USAGE).b(d.a("agent.java.mq_reporter.enable")).h()),
    MQ_HOST_NAME(e.a(String.class).a("contrast.mq.host.name").a("localhost").e().b("if contrast.mq is true, this allows us to specify the MQ host name").a(Category.INTERNAL_USAGE).b(d.a("agent.java.mq_reporter.hostname")).h()),
    MQ_PORT(e.a(Integer.class).a((Integer)((Object)"contrast.mq.host.port")).a(5672).e().b("if contrast.mq is true, this allows us to specify the MQ port").a(Category.INTERNAL_USAGE).b(d.a("agent.java.mq_reporter.port")).h()),
    MQ_USERNAME(e.a(String.class).c().e().b("Optional property, if contrast.mq is true, this allows us to specify the username for the MQ connection").a(Category.INTERNAL_USAGE).b(d.a("agent.java.mq_reporter.username")).h()),
    MQ_PASSWORD(e.a(String.class).c().e().b("Optional property, if contrast.mq is true, this allows us to specify the password for the MQ connection").a(Category.INTERNAL_USAGE).b(d.a("agent.java.mq_reporter.password")).h()),
    MQ_QUEUE_NAME(e.a(String.class).a("contrast.mq.queue.name").a("contrastEvents").e().b("if contrast.mq is true, this allows us to specify the MQ queue name").a(Category.INTERNAL_USAGE).b(d.a("agent.java.mq_reporter.queue_name")).h()),
    LOG_CONTEXT_SWITCH(e.a(String.class).a("NONE").e().b("set for debugging purposes, tells the Agent how much detail to log when context switching. Valid values are NONE (the default), IDENTITY, and FULL. If debug logs are not enabled, this property has no effect. See JAVA-3308 for more details.").a(Category.INTERNAL_USAGE).b(d.a("agent.java.log_context_switch")).h()),
    CLOUD_RESOURCE_DETECTOR_TIMEOUT_MS(e.a(Integer.class).a(10000).e().b("The timeout which will be used for the requests from the cloud resource detector").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.cloud_resource_detector.request_timeout")).h()),
    CLOUD_RESOURCE_DETECTOR_BACKOFF_FACTOR_MS(e.a(Long.class).a(1000L).e().b("The factor which will be multiplied by the exponential backoff factor to obtain the total backoff milliseconds when retrying cloud resource detection requests.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.cloud_resource_detector.backoff_factor_ms")).h()),
    CLOUD_RESOURCE_DETECTOR_MAX_TOTAL_BACKOFF_MS(e.a(Long.class).a(60000L).e().b("The maximum total backoff in milliseconds that should be used when retrying cloud resource detection requests. Once this maximum is exceeded, no more retries will be attempted for the specific failed request.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.cloud_resource_detector.max_retries")).h()),
    DIAGNOSTICS_ENABLE(e.a(Boolean.class).a((Boolean)true).e().b("Enables the agent diagnostics. Disable to prevent any agent diagnostics from running.").a(Category.DIAGNOSTICS).b(d.a("agent.diagnostics.enable")).h()),
    DIAGNOSTICS_LOGGER_ENABLE(e.a(Boolean.class).a((Boolean)false).e().b("Enables the agent diagnostics logger which will stream logs to a remote collector.").a(Category.DIAGNOSTICS).b(d.a("agent.diagnostics.logger.enable")).a(serverSettingsDTM -> {
        DiagnosticsLoggerDTM diagnosticsLoggerDTM = ConfigProperty.getDiagnosticsLogger(serverSettingsDTM);
        if (diagnosticsLoggerDTM == null) {
            return null;
        }
        return diagnosticsLoggerDTM.isEnabled();
    }).h()),
    DIAGNOSTICS_LOGGER_LEVEL(e.a(String.class).a(LoggingConstants.DEFAULT_DIAGNOSTICS_LOGGER_LEVEL.toString()).e().b("The log level for the diagnostics logger.").a(Category.DIAGNOSTICS).b(d.a("agent.diagnostics.logger.level")).a(serverSettingsDTM -> {
        DiagnosticsLoggerDTM diagnosticsLoggerDTM = ConfigProperty.getDiagnosticsLogger(serverSettingsDTM);
        if (diagnosticsLoggerDTM == null) {
            return null;
        }
        LogLevel logLevel = diagnosticsLoggerDTM.getLevel();
        if (logLevel == null) {
            return null;
        }
        return logLevel.name();
    }).h()),
    DIAGNOSTICS_LOGGER_EXPIRATION_TIME_MS(e.a(Long.class).a(-1L).b("The expiration time for diagnostics (in milliseconds since the Unix Epoch, 1970-01-01). Defaults to 1 hour from when diagnostics start. Maximum is 24 hours from when diagnostics start.").a(Category.DIAGNOSTICS).b(d.a("agent.diagnostics.logger.expires_ms")).a(serverSettingsDTM -> {
        DiagnosticsLoggerDTM diagnosticsLoggerDTM = ConfigProperty.getDiagnosticsLogger(serverSettingsDTM);
        if (diagnosticsLoggerDTM == null) {
            return null;
        }
        return diagnosticsLoggerDTM.getExpiresMs();
    }).h()),
    DIAGNOSTICS_LOGGER_UUID(e.a(String.class).c().b("The unique identifier for the current diagnostics logger collection. Defaults to a new UUID if none is provided.").a(Category.DIAGNOSTICS).b(d.a("agent.diagnostics.logger.uuid")).a(serverSettingsDTM -> {
        DiagnosticsLoggerDTM diagnosticsLoggerDTM = ConfigProperty.getDiagnosticsLogger(serverSettingsDTM);
        if (diagnosticsLoggerDTM == null) {
            return null;
        }
        return diagnosticsLoggerDTM.getUuid();
    }).h()),
    DIAGNOSTICS_LOGGER_BACKOFF_FACTOR_MS(e.a(Long.class).a(1000L).e().b("The factor which will be multiplied by the exponential backoff factor to obtain the total backoff milliseconds when retrying Diagnostics requests.").a(Category.DIAGNOSTICS).b(d.a("agent.java.diagnostics.logger.backoff_factor_ms")).h()),
    DIAGNOSTICS_LOGGER_MAX_TOTAL_BACKOFF_MS(e.a(Long.class).a(60000L).e().b("The maximum total backoff in milliseconds that should be used when retrying Diagnostics logger requests. Once this maximum is exceeded, no more retries will be attempted for the specific failed request.").a(Category.DIAGNOSTICS).b(d.a("agent.java.diagnostics.logger.max_backoff_ms")).h()),
    DIAGNOSTICS_LOGGER_BATCHING_TIMEOUT_MS(e.a(Long.class).a(5000L).e().b("The time the Diagnostics logger will wait before forcing a (non-full) batch of logs to be sent to the collector.").a(Category.DIAGNOSTICS).b(d.a("agent.java.diagnostics.logger.batching_timeout_ms")).h()),
    DIAGNOSTICS_LOGGER_MAX_BATCH_SIZE(e.a(Integer.class).a(32).e().b("Specify the number of messages that will be batched and sent to the Diagnostics logger.").a(Category.DIAGNOSTICS).b(d.a("agent.java.diagnostics.logger.batch_size")).h()),
    DIAGNOSTICS_LOGGER_BUFFER_SIZE(e.a(Integer.class).a(-1).e().b("Specify the Diagnostics logger buffer size cap. Must be a power of 2. The default is 128. The default if the agent is in DEBUG mode or higher is 16384. Log messages are dropped if the buffer exceeds the size.").a(Category.DIAGNOSTICS).b(d.a("agent.java.diagnostics.logger.buffer_size")).h()),
    LOGGER_CLOCK_CLASS(e.a(String.class).c().e().b("The class to be used for the logger's clock. Only used for testing.").a(Category.INTERNAL_USAGE).b(d.a("agent.java.logger.clock_class")).h()),
    OTEL_SLEEPER_CLASS(e.a(String.class).c().e().b("The class to be used as the Otel reporting thread sleeper. Only used for testing. Defaults to " + SimpleSleeper.class.getTypeName()).a(Category.INTERNAL_USAGE).b(d.a("agent.java.otel.sleeper_class")).h()),
    OTEL_JITTER_CLASS(e.a(String.class).c().e().b("The class to be used as the Otel reporting thread jitter provider. Only used for testing. Defaults to com.contrastsecurity.agent.util.Jitter#RANDOM").a(Category.INTERNAL_USAGE).b(d.a("agent.java.otel.jitter_class")).h()),
    PROFILE_PURGEABLES(e.a(Boolean.class).a((Boolean)((Object)"contrast.profile.purgeables")).a((Boolean)false).e().b("set for debugging purposes, tells the Agent to print to stdout purgeable metrics").a(Category.INTERNAL_USAGE).b(d.a("agent.java.report_purgeables")).h()),
    PROFILE_CONTEXT_METRICS(e.a(Boolean.class).a((Boolean)((Object)"contrast.profile.contextmetrics")).a((Boolean)false).e().b("set for debugging purposes, tells the Agent to print to stdout metrics about per-request data collection").a(Category.INTERNAL_USAGE).b(d.a("agent.java.report_context_metrics")).h()),
    PROFILE_STARTUP(e.a(Boolean.class).a((Boolean)((Object)"contrast.profile.startup")).a((Boolean)false).e().b("set for debugging purposes, tells the Agent to print to stdout startup metrics").a(Category.INTERNAL_USAGE).d("The YAML property cannot be used since this property is obtained before the Config object is created. This property can only be set as a system property: -Dcontrast.profile.startup").h()),
    PURGING_DELAY(e.a(Integer.class).a(30000).e().b("The delay between purging of the agent's internal data structures. Defaults to 30_000ms (30 seconds in milliseconds).").a(Category.INTERNAL_USAGE).b(d.a("agent.java.purging_delay_ms")).h()),
    CONCURRENCY_MAP_SYNCHRONISED(e.a(Boolean.class).a((Boolean)false).e().b("Enable or disable synchronization of segments in the concurrency map, this will always default to true in Java 21+").a(Category.INTERNAL_USAGE).b(d.a("agent.java.enable_concurrency_map_sync")).h()),
    CONTEXT_MAP_PURGE_TIMEOUT(e.a(Integer.class).a((Integer)((Object)"contrast.context.purge.timeout")).a(30000).e().b("number of milliseconds to allow strongly reachable threads to pass thread context. Defaults to 30000(30 seconds in milliseconds).").a(Category.INTERNAL_USAGE).b(d.a("agent.java.context_thread_timeout_ms")).h()),
    CONTEXT_MAP_PURGE_ENTRY_MINIMUM(e.a(Integer.class).a((Integer)((Object)"contrast.context.purge.minimum")).a(350).e().b("number of threads to concurrently manage in our context manager before we proactively purge strongly reachable threads").a(Category.INTERNAL_USAGE).b(d.a("agent.java.context_minimum_threads")).h()),
    WEB_SESSION_TIMEOUT(e.a(Integer.class).a(30).b("Overrides the maximum \"safe\" session timeout value to check against the <session-timeout> detected in the application web.xml file, ServletContext.setSessionTimeout(int), or Spring Boot application.properties. The default value is 30 (minutes).").a(Category.RULES_CONFIG).b(d.a("agent.java.web_session_timeout")).h()),
    JACKSON_INTERN_ENABLE(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jackson.interning")).a((Boolean)true).b("Controls whether String interning is disabled in Jackson. The default value is true.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.enable_jackson_intern")).h()),
    SUPPORTER_AKKA(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.akka")).a((Boolean)true).e().b("boolean to enable/disable Akka support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_akka_support")).h()),
    SUPPORTER_ANTLR(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.antlr")).a((Boolean)true).e().b("boolean to enable/disable instrumentation of standard Antlr classes").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_antlr_support")).h()),
    SUPPORTER_APACHE_FILE_UPLOAD(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.apache.file.uploader")).a((Boolean)true).e().b("boolean enable/disable support of Apache Commons FileUpload library").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_apache_fileupload_support")).h()),
    SUPPORTER_APACHE_ACTIVEMQ(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.apache.activemq")).a((Boolean)true).e().b("boolean enable/disable support of Apache ActiveMQ library").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_activemq_support")).h()),
    SUPPORTER_APACHE_CLIENT(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.apache.client")).a((Boolean)true).e().b("boolean enable/disable support of Apache HTTP Client").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_apache_client_support")).h()),
    SUPPORT_APACHE_REQUEST(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.apache.request")).a((Boolean)true).e().b("boolean enable/disable support of Apache Request Library").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_apache_request_support")).h()),
    SUPPORTER_APP_DYNAMICS(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.appdynamics")).a((Boolean)false).e().b("boolean enable/disable support of special sensors to avoid conflicts with AppDynamics").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_app_dynamics_support")).h()),
    SUPPORTER_APACHE(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.apache")).a((Boolean)true).e().b("boolean to enable/disable support/instrumentation of Apache HTTP libraries").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_apache_http_support")).h()),
    SUPPORTER_AWS(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.aws")).a((Boolean)true).e().b("boolean to enable/disable support/instrumentation of AWS HTTP client").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_aws_client_support")).h()),
    SUPPORTER_AWS_DYNAMODB(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.aws_dynamodb")).a((Boolean)true).e().b("boolean to enable/disable support/instrumentation of AWS Dynamo client").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_aws_dynamo_support")).h()),
    SUPPORTER_CARBON(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.carbon")).a((Boolean)true).e().b("boolean to enable/disable support for Carbon").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_carbon_support")).h()),
    SUPPORTER_STRUTS1(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.struts1")).a((Boolean)true).e().b("boolean to enable/disable support for Struts1 applications").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_struts1_support")).h()),
    SUPPORTER_STRUTS2(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.struts2")).a((Boolean)true).e().b("boolean to enable/disable support for Struts2 applications").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_struts2_support")).h()),
    SUPPORTER_CLASSLOADING(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.classloading")).a((Boolean)true).e().b("boolean to enable/disable instrumentation of ClassLoaders").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_classloading_support")).h()),
    SUPPORTER_COVERITY(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.coverity")).a((Boolean)true).e().b("boolean to enable/disable instrumentation of Coverity").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_coverity_support")).h()),
    SUPPORTER_CODE_EXCLUSIONS(e.a(Boolean.class).a((Boolean)true).e().b("boolean to enable/disable instrumentation of code exclusion classes").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_code_exclusion_support")).h()),
    SUPPORTER_CONCURRENCY(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.concurrency")).a((Boolean)true).e().b("boolean to enable/disable instrumentation of Java Concurrency classes").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_concurrency_support")).h()),
    SUPPORTER_FRAMEWORK_DEBUGGER(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.framework.debugging")).a((Boolean)true).e().b("boolean to enable/disable support for framework debugging").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_framework_debugging_support")).h()),
    SUPPORTER_DROPWIZARD(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.dropwizard")).a((Boolean)true).e().b("boolean to enable/disable support for DropWizard applications").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_dropwizard_support")).h()),
    SUPPORTER_DYNATRACE(e.a(Boolean.class).a((Boolean)true).e().b("boolean to enable/disable support for Dynatrace").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_dynatrace_support")).h()),
    DYNATRACE_MAX_DEPTH(e.a(Integer.class).a(6).e().b("The max depth to search a stack trace for Dynatrace classes.").a(Category.PERFORMANCE).b(d.a("agent.java.dynatrace_max_depth")).h()),
    SUPPORTER_DWR(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.dwr")).a((Boolean)true).e().b("boolean to enable/disable Direct Web Remoting support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_dwr_support")).h()),
    SUPPORTER_ESAPI(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.esapi")).a((Boolean)true).e().b("boolean to enable/disable instrumentation of ESAPI classes").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_esapi_support")).h()),
    SUPPORTER_FREEMARKER(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.freemarker")).a((Boolean)true).e().b("boolean to enable/disable FreeMarker support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_freemarker_support")).h()),
    SUPPORTER_GRIZZLY(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.grizzly")).a((Boolean)true).e().b("boolean to enable/disable Grizzly support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_grizzly_support")).h()),
    SUPPORTER_GLOWROOT(e.a(Boolean.class).a((Boolean)true).e().b("boolean to enable/disable Glowroot support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_glowroot_support")).h()),
    SUPPORTER_GRAILS(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.grails")).a((Boolean)true).e().b("boolean to enable/disable Grails support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_grails_support")).h()),
    SUPPORTER_GRAPHQL(e.a(Boolean.class).a((Boolean)true).e().b("boolean to enable/disable GraphQL support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_graphql_support")).h()),
    SUPPORTER_GROOVY(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.groovy")).a((Boolean)true).e().b("boolean to enable/disable Groovy support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_groovy_support")).h()),
    SUPPORTER_GRPC(e.a(Boolean.class).a((Boolean)true).e().b("boolean to enable/disable gRPC support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_grpc_support")).h()),
    SUPPORTER_HIBERNATE(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.hibernate")).a((Boolean)true).e().b("boolean to enable/disable Hibernate support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_hibernate_support")).h()),
    SUPPORTER_HTTP4K(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.http4k")).a((Boolean)true).e().b("boolean to enable/disable Http4k support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_http4k_support")).h()),
    SUPPORTER_JBOSS(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jboss")).a((Boolean)true).e().b("boolean to enable/disable JBoss support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_jboss_support")).h()),
    SUPPORTER_J2EE(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.j2ee")).a((Boolean)true).e().b("boolean to enable/disable instrumentation of standard J2EE/Jakarta servlet classes").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_j2ee_support")).h()),
    SUPPORTER_JASPER(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jasper")).a((Boolean)true).e().b("boolean to enable/disable instrumentation of standard Apache's Jasper classes").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_jasper_support")).h()),
    SUPPORTER_JETTY(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jetty")).a((Boolean)true).e().b("boolean to enable/disable instrumentation of standard Jetty classes").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_jetty_support")).h()),
    SUPPORTER_JMS(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jms")).a((Boolean)true).e().b("boolean to enable/disable instrumentation of standard JMS classes").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_jms_support")).h()),
    SUPPORTER_JSP(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jsp")).a((Boolean)true).e().b("boolean to enable/disable instrumentation of compiled JSP classes").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_jsp_support")).h()),
    SUPPORTER_KAFKA(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.kafka")).a((Boolean)true).e().b("boolean to enable/disable instrumentation of standard Kafka classes").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_kafka_support")).h()),
    SUPPORTER_LAMBDA(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.lambda")).a((Boolean)true).e().b("boolean to enable/disable instrumentation of Java lambdas").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_lambda_support")).h()),
    SUPPORTER_LDAP(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.ldap")).a((Boolean)true).e().b("boolean to enable/disable instrumentation of standard LDAP classes").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_ldap_support")).h()),
    SUPPORTER_LOG4J(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.log4j")).a((Boolean)true).e().b("boolean to enable/disable instrumentation of standard Log4j classes").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_log4j_support")).h()),
    SUPPORTER_MODULE(e.a(Boolean.class).a((Boolean)true).e().b("boolean to enable/disable java.lang.Module and --illegal-access=deny support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_module_support")).h()),
    SUPPORTER_MONGO(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.mongo")).a((Boolean)true).e().b("boolean to enable/disable instrumentation of standard Mongo classes").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_mongo_support")).h()),
    SUPPORTER_JACKSON(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jackson")).a((Boolean)true).e().b("boolean to enable/disable Jackson support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_jackson_support")).h()),
    SUPPORTER_JAXB(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jaxb")).a((Boolean)true).e().b("boolean to enable/disable JAXB support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_jaxb_support")).h()),
    SUPPORTER_JAVAX(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.javax")).a((Boolean)true).e().b("boolean to enable/disable JavaX support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_javax_support")).h()),
    SUPPORTER_JAVAX_WS_RS(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.javax.ws.rs")).a((Boolean)true).e().b("boolean to enable/disable JaxRS support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_javax_ws_rs_support")).h()),
    SUPPORTER_JERSEY(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jersey")).a((Boolean)true).e().b("boolean to enable/disable Jersey support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_jersey_support")).h()),
    SUPPORTER_JSF(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jsf")).a((Boolean)true).e().b("boolean to enable/disable JSF support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_jsf_support")).h()),
    SUPPORTER_JSF_ADF(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jsf.adf")).a((Boolean)true).e().b("boolean to enable/disable JSF ADF support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_jsf_adf_support")).h()),
    SUPPORTER_JSF_TRINIDAD(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jsf.trinidad")).a((Boolean)true).e().b("boolean to enable/disable JSF Apache Trinidad support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_jsf_trinidad_support")).h()),
    SUPPORTER_KRYO(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.kryo")).a((Boolean)true).e().b("boolean to enable/disable Kryo support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_kyro_support")).h()),
    SUPPORTER_LIFERAY(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.liferay")).a((Boolean)true).e().b("boolean to enable/disable Liferay support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_liferay_support")).h()),
    SUPPORTER_MINIDEV_JSON(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.minidevjson")).a((Boolean)true).b("boolean to enable/disable net.minidev.json support").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.enable_minidev_json_support")).h()),
    SUPPORTER_MATCHER(e.a(Boolean.class).a((Boolean)true).e().b("boolean to enable/disable support for java.util.regex.Matcher").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_matcher_support")).h()),
    SUPPORTER_MULESOFT(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.mulesoft")).a((Boolean)false).e().b("boolean to enable/disable MuleSoft support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_mulesoft_support")).h()),
    SUPPORTER_MUSTACHE(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.mustache")).a((Boolean)true).e().b("boolean to enable/disable Mustache support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_mustache_support")).h()),
    SUPPORTER_NETTY(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.netty")).a((Boolean)true).e().b("boolean to enable/disable Netty support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_netty_support")).h()),
    SUPPORTER_OPEN_TELEMETRY(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.opentelemtetry")).a((Boolean)true).e().b("boolean to enable/disable OpenTelemetry support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_opentelemetry_support")).h()),
    SUPPORTER_OSGI(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.osgi")).a((Boolean)true).e().b("boolean to enable/disable OSGi support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_osgi_support")).h()),
    SUPPORTER_OUTSYSTEMS(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.outsystems")).a((Boolean)true).e().b("boolean to enable/disable OutSystems support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_out_systems_support")).h()),
    SUPPORTER_PATTERNS(e.a(Boolean.class).a((Boolean)true).e().b("boolean to enable/disable support for Patterns (Java/Perl5)").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_pattern_support")).h()),
    SUPPORTER_PLAY(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.play")).a((Boolean)true).e().b("boolean to enable/disable Play support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_play_support")).h()),
    SUPPORTER_QUARKUS(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.quarkus")).a((Boolean)true).e().b("boolean to enable/disable Quarkus related support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_quarkus_support")).h()),
    SUPPORTER_RABBITMQ(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.rabbitmq")).a((Boolean)true).e().b("boolean to enable/disable Rabbit MQ support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_rabbit_mq_support")).h()),
    SUPPORTER_REACTOR_NETTY(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.reactor_netty")).a((Boolean)true).e().b("boolean to enable/disable Reactor Netty support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_reactor_netty_support")).h()),
    SUPPORTER_RESIN(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.resin")).a((Boolean)true).e().b("boolean to enable/disable Resin support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_resin_support")).h()),
    SUPPORTER_RESTEASY(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.resteasy")).a((Boolean)true).e().b("boolean to enable/disable RESTEasy support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_resteasy_support")).h()),
    SUPPORTER_SCALA(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.scala")).a((Boolean)true).e().b("boolean to enable/disable Scala support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_scala_support")).h()),
    SUPPORTER_SECONDORDER_CANARIES(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.secondorder.canary")).a((Boolean)true).e().b("boolean to enable/disable second-order canary support.  see the option assess.second_order_canary for more configuration details.").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_secondorder_canary_support")).h()),
    SUPPORTER_SEAM(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.seam")).a((Boolean)true).e().b("boolean to enable/disable SEAM support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_seam_support")).h()),
    SUPPORTER_SECURITY_MANAGER(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.security_manager")).a((Boolean)true).e().b("boolean to enable/disable Security Manager support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_security_manager_support")).h()),
    SUPPORTER_SMAP(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.smap")).a((Boolean)true).e().b("boolean to enable/disable SMAP support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_smap_support")).h()),
    SUPPORTER_SQL(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.sql")).a((Boolean)true).e().b("boolean to enable/disable java.sql support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_java_sql_support")).h()),
    SUPPORTER_SPRINGBOOT(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.spring_boot")).a((Boolean)true).e().b("boolean to enable/disable Spring Boot support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_spring_boot_support")).h()),
    SUPPORTER_SPRING(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.spring")).a((Boolean)true).e().b("boolean to enable/disable Spring support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_spring_support")).h()),
    SUPPORTER_SPRING_WEB_SERVICES(e.a(Boolean.class).a((Boolean)true).e().b("boolean to enable/disable Spring Web Services support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_spring_web_services_support")).h()),
    SUPPORTER_STRUTS(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.struts")).a((Boolean)true).e().b("boolean to enable/disable Struts support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_struts_support")).h()),
    SUPPORTER_TECHNOLOGY_DETECTION(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.technology.detection")).a((Boolean)true).e().b("boolean to enable/disable Technology Detection support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_technology_detection_support")).h()),
    SUPPORTER_TOMCAT(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.tomcat")).a((Boolean)true).e().b("boolean to enable/disable Tomcat support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_tomcat_support")).h()),
    SUPPORTER_UNDERTOW(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.undertow")).a((Boolean)true).e().b("boolean to enable/disable support for Undertow applications").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_undertow_support")).h()),
    SUPPORTER_URL(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.url")).a((Boolean)true).e().b("boolean to enable/disable java.net.URL support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_java_url_support")).h()),
    SUPPORTER_VERTX(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.vertx")).a((Boolean)true).e().b("boolean to enable/disable Vert.x support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_vertx_support")).h()),
    SUPPORTER_WEBLOGIC(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.weblogic")).a((Boolean)true).e().b("boolean to enable/disable Weblogic support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_weblogic_support")).h()),
    SUPPORTER_W3C(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.w3c")).a((Boolean)true).e().b("boolean to enable/disable W3C API support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_w3c_support")).h()),
    SUPPORTER_JAVA_NIO(e.a(Boolean.class).a((Boolean)true).e().b("boolean to enable/disable java.nio support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_nio_support")).h()),
    SUPPORTER_JAVA_RMI(e.a(Boolean.class).a((Boolean)false).e().b("boolean to enable/disable java.rmi support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_rmi_support")).h()),
    SUPPORTER_JAVA_STRING(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.string")).a((Boolean)true).e().b("boolean to enable/disable java.lang.String support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_java_string_support")).h()),
    SUPPORTER_WEBSPHERE(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.websphere")).a((Boolean)true).e().b("boolean to enable/disable WebSphere support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_websphere_support")).h()),
    SUPPORTER_CXF(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.cxf")).a((Boolean)true).e().b("boolean to enable/disable Apache CXF support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_cxf_support")).h()),
    SUPPORTER_POI(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.poi")).a((Boolean)true).e().b("boolean to enable/disable Apache POI support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_poi_support")).h()),
    SUPPORTER_XENON(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.xenon")).a((Boolean)true).e().b("boolean to enable/disable VMware Xenon support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_xenon_support")).h()),
    SUPPORTER_XSTREAM(e.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.xstream")).a((Boolean)true).e().b("boolean to enable/disable XStream support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_xstream_support")).h()),
    CACHE_HIERARCHY(e.a(Boolean.class).a((Boolean)((Object)"contrast.cache.hierarchy")).a((Boolean)true).b("boolean to enable/disable hierarchy cache").a(Category.PERFORMANCE).b(d.a("assess.cache.hierarchy_enable")).h()),
    HIERARCHY_REBUILD(e.a(Boolean.class).a((Boolean)((Object)"contrast.hierarchy.rebuild")).a((Boolean)false).b("boolean to trigger rebuilding/resetting the hierarchy cache").a(Category.PERFORMANCE).b(d.a("assess.cache.hierarchy_rebuild")).h()),
    HIERARCHY_UPDATE(e.a(Boolean.class).a((Boolean)((Object)"contrast.hierarchy.update")).a((Boolean)false).b("boolean to trigger updating the hierarchy cache").a(Category.PERFORMANCE).b(d.a("assess.cache.hierarchy_update")).h()),
    ANALYSIS_CACHE_MAX_SIZE(e.a(Integer.class).a((Integer)((Object)"contrast.analysiscache.size")).a(500000).e().b("maximum weighted size of the protect analysis cache. cache is weighted on total number of chars in each input value. This limits the usage of memory for the analysis cache. The default value of 500,000 limits usage to approximately 977 KB with 16bit char code units. This will vary depending on the JVM.").a(Category.PERFORMANCE).b(d.a("protect.cache.analysis_cache_size_max")).h()),
    ANALYSIS_CACHE_STRING_LIMIT(e.a(Integer.class).a((Integer)((Object)"contrast.analysiscache.stringlimit")).a(100000).e().b("maximum length in chars of a user input value that will be stored in the analysis cache. Larger values than this will not be cached.").a(Category.PERFORMANCE).b(d.a("protect.cache.analysis_cache_string_limit")).h()),
    ANALYSIS_CACHE_EXPIRY(e.a(Long.class).a((Long)((Object)"contrast.analysiscache.expiry.ms")).a(300000L).e().b("expiration time of elements within the analysis cache in milliseconds").a(Category.PERFORMANCE).b(d.a("protect.cache.analysis_cache_expiry_ms")).h()),
    NESTED_LIBS_DEPTH(e.a(Integer.class).a((Integer)((Object)"contrast.nested.libs.depth")).a(3).b("max archive unpacking depth when analyzing libraries").a(Category.GENERAL_PROPERTIES).b(d.a("inventory.library_depth")).h()),
    CLASSPATH_LIBS(e.a(Boolean.class).a((Boolean)((Object)"contrast.classpath.libs")).a((Boolean)false).b("Boolean to enable/disable analysis of libraries listed in java.class.path property. Determines whether Contrast will track usage of libraries listed in the environment's *java.class.path* property. This should only be on in J2SE/desktop situations.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.enable_classpath_libs")).h()),
    EVALUATE_PROTECT_TIMING_THRESHOLD(e.a(Long.class).a(60000L).e().b("Timing threshold to log potentially slow evaluations for Protect in milliseconds.  A value of 0 is disabled.").a(Category.DIAGNOSTICS).b(d.a("agent.java.protect_evaluate_timing_threshold")).h()),
    EXTERNAL_LIB_DIR(e.a(String.class).a("contrast.external.lib.dir").c().b("List of directories where external libraries are stored; used during library analysis, delimited by ';' on Windows and ':' on Unix").a(Category.GENERAL_PROPERTIES).b(d.a("inventory.library_dirs")).h()),
    APPLICATION_NAME(e.a(String.class).a("contrast.override.appname").c().b("sets the application name; this name will be reported to TeamServer").a(Category.GENERAL_PROPERTIES).b(d.a("application.name", true)).h()),
    APPLICATION_VERSION(e.a(String.class).a("contrast.override.appversion").c().b("sets the application version; this version will be reported to TeamServer").a(Category.GENERAL_PROPERTIES).b(d.a("application.version", true)).g().h()),
    ASSESS_CONTEXT_MAP_CONCURRENCY_LEVEL(e.a(Integer.class).e().a(128).b("estimated number of concurrent threads that will create Assessment contexts.").a(Category.PERFORMANCE).b(d.a("agent.java.assess_context.concurrency_level")).h()),
    HEAP_PROFILER_INTERVAL_MS(e.a(Long.class).e().a(900000L).b("interval which we should attempt heap profiling.").a(Category.PERFORMANCE).b(d.a("agent.java.heap_profiler.interval_ms")).h()),
    CPU_PROFILE_INTERVAL_MS(e.a(Long.class).e().a(180000L).b("interval which we should attempt CPU sampling.").a(Category.PERFORMANCE).b(d.a("agent.java.cpu_sampling.interval_ms")).h()),
    CONCURRENT_REQUESTS(e.a(Integer.class).a((Integer)((Object)"contrast.concurrent.requests")).a(20).b("average number of concurrent users logged into the application at any one time").a(Category.PERFORMANCE).b(d.a("agent.concurrent_requests")).h()),
    HTTP_BUFFER_POOL_MAX_SIZE(e.a(Integer.class).a(500).e().b("The max number of object allowed in the memory buffer pool").a(Category.PERFORMANCE).b(d.a("agent.java.http_memory_pool.max_size")).h()),
    HTTP_BUFFER_POOL_TTL(e.a(Integer.class).a(15).e().b("The TTL in minutes of a memory buffer object in the pool").a(Category.PERFORMANCE).b(d.a("agent.java.http_memory_pool.ttl.mins")).h()),
    STANDALONE_APPNAME(e.a(String.class).a("contrast.standalone.appname").c().b("Indicates the application is a standalone app with the provided name").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.standalone_app_name")).h()),
    TEAMSERVER_CHANNEL_PAUSE_PERIOD(e.a(Long.class).a((Long)((Object)"contrast.teamserver.channel.pause.period")).a(900000L).b("The amount of time to pause agent to TeamServer communication when a bad response code is received. 900000 (15 minutes in milliseconds).").a(Category.GENERAL_PROPERTIES).b(d.a("agent.polling.contrast_ui_channel_pause_period_ms")).h()),
    TEAMSERVER_URL(e.a(String.class).a("contrast.teamserver.url").b("Set the URL for the Contrast UI").a("https://app.contrastsecurity.com/Contrast").a(Category.GENERAL_PROPERTIES).b(d.a("api.url", Lists.of("contrast.url"))).h()),
    TEAMSERVER_STARTUP_RETRY_TIME_MS(e.a(Long.class).a(-1L).b("Set the time period to retry the initial connection to Contrast UI, after this timeout period is exceeded the agent will take action depending upon the associated failure_strategy property. The agent will immediately start as normal if the request succeeds. The default value is -1 indicating that retry is disabled. The expiry period must be longer than the retry_delay_ms setting.").a(Category.GENERAL_PROPERTIES).e().b(d.a("agent.startup.retry_expiry_ms")).h()),
    TEAMSERVER_STARTUP_RETRY_DELAY_TIME_MS(e.a(Long.class).a(500L).b("Set the time period to wait between retrying connecting to Contrast UI on startup. If the agent needs to retry the request it will sleep for this period in ms. The minimum allowed value is 500ms.").a(Category.GENERAL_PROPERTIES).e().b(d.a("agent.startup.retry_delay_ms")).h()),
    STARTUP_FAILURE_STRATEGY(e.a(String.class).a("continue").b("Set the action to take if the agent fails to start up correctly. Valid options are `continue` (default), `abort`. The `continue` option indicates the application continues without the agent being enabled. The abort option will stop the application if Contrast cannot startup and MUST be used with care.").a(Category.GENERAL_PROPERTIES).e().b(d.a("agent.startup.failure_strategy")).h()),
    APP_SETTINGS_POLL_INTERVAL_MS(e.a(Long.class).a(30000L).e().b("Set the frequency with which the agent polls for application settings from the Contrast UI. Default is 30,000 milliseconds (30 seconds).").a(Category.GENERAL_PROPERTIES).b(d.a("agent.polling.app_settings_ms")).h()),
    SERVER_SETTINGS_POLL_INTERVAL_MS(e.a(Long.class).a(30000L).e().b("Set the frequency with which the agent sends server settings polls to the Contrast UI. This value is bounded within the agents, with a minimum of 1_000 and a maximum of 300_000.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.polling.server_settings_ms")).h()),
    TIMEOUT_MS(e.a(Integer.class).a(10000).b("This value can override the default timeout (in milliseconds) for communicating with TeamServer.").a(Category.GENERAL_PROPERTIES).b(d.a("api.timeout_ms", Lists.of("contrast.timeout_ms"))).h()),
    PROXY_ENABLED(e.a(String.class).a("contrast.proxy.enable").c().b("If present, determines whether the Agent should communicate with TeamServer over a proxy. Otherwise, enabled status is determined by the presence of a valid proxy host and port").a(Category.PROXY_SETTINGS).b(d.a("api.proxy.enable", Lists.of("contrast.proxy.enable"))).h()),
    PROXY_URL(e.a(String.class).a("contrast.proxy.url").c().b("Proxy url, e.g. https://host:port. This value should be set in place of scheme, host, and port settings. If both this and one of the others are set, a ContrastConfigurationException will be thrown").a(Category.PROXY_SETTINGS).b(d.a("api.proxy.url", Lists.of("contrast.proxy.url"))).h()),
    PROXY_PROTOCOL(e.a(String.class).a("contrast.proxy.protocol").c().b("Proxy protocol, e.g. http, https").a(Category.PROXY_SETTINGS).b(d.a("api.proxy.scheme", Lists.of("contrast.proxy.scheme"))).h()),
    PROXY_AUTH(e.a(String.class).c().b("Override authentication type for Proxy").a(Category.PROXY_SETTINGS).b(d.a("api.proxy.auth_type", Lists.of("contrast.proxy.auth_type"))).h()),
    PROXY_HOST(e.a(String.class).c().b("Override Host for Proxy").a(Category.PROXY_SETTINGS).b(d.a("api.proxy.host", Lists.of("contrast.proxy.host"))).h()),
    PROXY_PORT(e.a(Integer.class).a(0).b("Override Port for Proxy. Defaults to 0, an invalid port number.").a(Category.PROXY_SETTINGS).b(d.a("api.proxy.port", Lists.of("contrast.proxy.port"))).h()),
    PROXY_USER(e.a(String.class).c().b("Override User for Proxy").a(Category.PROXY_SETTINGS).b(d.a("api.proxy.user", Lists.of("contrast.proxy.user"))).h()),
    PROXY_PASSWORD(e.a(String.class).c().b("Override Password for Proxy").a(Category.PROXY_SETTINGS).f().b(d.a("api.proxy.pass", Lists.of("contrast.proxy.pass"))).h()),
    ACTIVITY(e.a(Boolean.class).a((Boolean)((Object)"contrast.activity")).a((Boolean)true).b("boolean to enable/disable the Contrast activity thread").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.enable_activity_thread")).h()),
    APP_ACTIVITY_PERIOD_MS(e.a(Long.class).a((Long)((Object)"contrast.app.activity.period")).a(30000L).b("Contrast app activity thread polling period in milliseconds. 30000 (30  seconds, in milliseconds)").a(Category.GENERAL_PROPERTIES).b(d.a("agent.polling.app_activity_ms")).h()),
    STALE_APP_ACTIVITY_UPDATE_MS(e.a(Long.class).a((Long)((Object)"contrast.stale.app.activity.update.ms")).a(TimeUnit.MINUTES.toMillis(5L)).b("The maximum amount of time to wait before requesting new \"application settings\" from TeamServer. Typically, the agent receives new settings each time it sends activity, but if there is no activity the agent will wait this long before requesting new settings. Defaults to " + TimeUnit.MINUTES.toMillis(5L) + " (5 minutes, in milliseconds)").a(Category.GENERAL_PROPERTIES).b(d.a("agent.polling.app_activity_stale_ms")).h()),
    APPUPDATE(e.a(Boolean.class).a((Boolean)((Object)"contrast.appupdate")).a((Boolean)true).b("boolean to enable/disable threads that sends updates about applications to Team Server").a(Category.GENERAL_PROPERTIES).b(d.a("application.enable_app_updates")).h()),
    APP_UPDATE_PERIOD(e.a(Long.class).a((Long)((Object)"contrast.app.update.period")).a(5000L).b("Contrast app update thread polling period in milliseconds").a(Category.GENERAL_PROPERTIES).b(d.a("agent.polling.app_update_ms")).h()),
    APP_UPDATE_STALE_THRESHOLD(e.a(Long.class).a((Long)((Object)"contrast.app.update.threshold")).a(1800000L).e().b("Even when no appupdate is warranted on client side, ask TeamServer via preflight if needed on this frequency. 30 mins, in milliseconds.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.polling.app_update_stale_threshold_ms")).h()),
    APP_FEATURES(e.a(String.class).a("contrast.app.features").c().b("JSON from disk to use for app").a(Category.GENERAL_PROPERTIES).b(d.a("application.app_features_file")).h()),
    DENYLIST_PATH(e.a(String.class).a("contrast.blacklist").c().b("The path to the file that lists classes currently on the denylist.  Classes listed here will be ignored by the agent.").a(Category.PERFORMANCE).b(d.a("agent.blacklist")).h()),
    PACKAGE_DENYLIST_PATH(e.a(String.class).c().e().b("The path to the file that lists packages currently on the denylist.  Classes with packages matching the prefixes listed will be ignore by the agent.  Packages should match the format \"com/example/\", without quotes.").a(Category.PERFORMANCE).b(d.a("agent.java.package_denylist")).h()),
    CLONEINPUT(e.a(Boolean.class).a((Boolean)((Object)"contrast.cloneinput")).a((Boolean)true).b("boolean to enable/disable cloning of tracked objects").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.enable_input_cloning")).h()),
    DEEP_CLONEINPUT(e.a(Boolean.class).a((Boolean)((Object)"contrast.deepclone")).a((Boolean)true).b("boolean to enable/disable cloning of leaf nodes in object graphs of deserialized objects").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.enable_deep_cloning")).h()),
    DEEP_TAINTKEYS(e.a(Boolean.class).a((Boolean)((Object)"contrast.deep.mapkeys")).a((Boolean)false).b("boolean to enable/disable tainting of keys in maps of deserialized objects").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.taint_map_key")).h()),
    DESERIALIZER_MAX_DEPTH(e.a(Integer.class).a((Integer)((Object)"contrast.deserializer.maxdepth")).a(10).e().b("The max depth to traverse and analyze deserialized objects in Protect. Set to 0 to disable deserialized object analysis.").a(Category.PERFORMANCE).b(d.a("agent.java.protect_deserialization_analysis_traversal_depth")).h()),
    SERVER_TYPE(e.a(String.class).a("contrast.container").c().b("manually override the web app server type").a(Category.GENERAL_PROPERTIES).b(d.a("server.type")).h()),
    WORKING_DIR(e.a(String.class).a("contrast.dir").c().b("This value can override the default location of the Contrast working directory. Defaults to ${HOME}/.contrast of the user account the application runs under.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.contrast_working_dir")).h()),
    SERVER_TAGS(e.a(String.class).c().b("comma separated list of tags to be sent with each server update and create").a(Category.GENERAL_PROPERTIES).b(d.a("server.tags")).h()),
    APPLICATION_TAGS(e.a(String.class).c().b("comma separated list of tags to be sent with each application message").a(Category.GENERAL_PROPERTIES).b(d.a("application.tags", true)).h()),
    INVENTORY_TAGS(e.a(String.class).c().b("comma separated list of tags to be sent with each inventory message").a(Category.GENERAL_PROPERTIES).b(d.a("inventory.tags", true)).h()),
    ASSESS_TAGS(e.a(String.class).c().b("comma separated list of tags to be sent with each assess message").a(Category.GENERAL_PROPERTIES).b(d.a("assess.tags", true)).h()),
    HTTP_ANALYSIS_PARAMETERS(e.a(Boolean.class).a((Boolean)((Object)"contrast.http.analysis.parameters")).a((Boolean)true).b("boolean to enable/disable analysis of HTTP parameters").a(Category.PERFORMANCE).b(d.a("agent.java.enable_http_parameter_analysis")).h()),
    DBINSPECTION(e.a(Boolean.class).a((Boolean)((Object)"contrast.dbinspection")).a((Boolean)true).b("boolean to enable/disable DB inspection when analyzing application architecture").a(Category.GENERAL_PROPERTIES).b(d.a("inventory.inspect_database")).h()),
    INVENTORY_MONITOR_LDAP(e.a(Boolean.class).a((Boolean)((Object)"contrast.monitorldap")).a((Boolean)true).b("boolean to enable/disable LDAP call counting and analysis").a(Category.GENERAL_PROPERTIES).b(d.a("inventory.inspect_ldap")).h()),
    INVENTORY_MONITOR_WEB_CALL(e.a(Boolean.class).a((Boolean)((Object)"contrast.monitorwebcalls")).a((Boolean)true).b("boolean to enable/disable web call counting and analysis, web calls being the HTTP requests made to this application").a(Category.GENERAL_PROPERTIES).b(d.a("inventory.inspect_web_calls")).h()),
    ENABLED(e.a(Boolean.class).a((Boolean)((Object)"contrast.enabled")).a((Boolean)true).b("Determines whether Contrast will monitor the JVM. You can use this feature to quickly turn Contrast on or off without removing the *-javaagent* flag.").a(Category.GENERAL_PROPERTIES).b(d.a("enable", Lists.of("contrast.enable"))).h()),
    LAST_CONFIG_PATH(e.a(String.class).a("contrast.last_config_path").c().b("The file to which the last configuration from TeamServer should be loaded or reloaded.").a(Category.GENERAL_PROPERTIES).b(d.a("api.last_config_path", Lists.of("contrast.last_config_path"))).h()),
    FEATUREJSON(e.a(String.class).a("contrast.featureJSON").c().e().b("location of features JSON").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.features_file_override")).h()),
    IDENTITYTAGS(e.a(Boolean.class).a((Boolean)((Object)"contrast.identitytags")).a((Boolean)true).b("boolean to enable/disable identity tags").a(Category.RULES_CONFIG).b(d.a("assess.enable_identity_tagging")).h()),
    JFR(e.a(Boolean.class).a((Boolean)false).e().b("boolean to enable/disable JFR event emitting").a(Category.DIAGNOSTICS).b(d.a("agent.java.enable_jfr_events")).h()),
    JMX(e.a(Boolean.class).a((Boolean)((Object)"contrast.jmx")).a((Boolean)false).e().b("boolean to enable/disable jmx support").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_jmx_support")).h()),
    J2EE_CLASSCACHE(e.a(Boolean.class).a((Boolean)((Object)"contrast.j2ee.classcache")).a((Boolean)true).b("boolean to enable/disable caching of instrumented classes").a(Category.PERFORMANCE).b(d.a("agent.java.enable_j2ee_class_cache")).h()),
    J2EE_CONTEXT_DISCOVERY(e.a(Boolean.class).a((Boolean)((Object)"contrast.j2ee.context.discovery")).a((Boolean)true).e().b("boolean to enable/disable J2EE context discovery").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.j2ee_context_discovery")).h()),
    MODE(e.a(String.class).a("contrast.mode").d().c().e().b("Valid values: assess/defend/inventory/observe/all. assess: data flow analysis, defend: defend features, inventory: library catalog and analysis, observe: security observability, all: all features; Note when this property is enabled, the Agent will ignore all customizations from TeamServer.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.mode")).h()),
    ASSESS_ENABLED(e.a(Boolean.class).a((Boolean)((Object)"contrast.assess.enabled")).a((Boolean)false).b("If present, used to determine if the Assess feature should be enabled. If not present, decision delegated to Contrast UI").a(Category.GENERAL_PROPERTIES).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getAssess() != null) {
            return serverSettingsDTM.getAssess().getEnable();
        }
        return null;
    }).b(d.a("assess.enable")).h()),
    INVENTORY_ENABLED(e.a(Boolean.class).a((Boolean)((Object)"contrast.inventory.enabled")).a((Boolean)true).b("Used to determine if the Inventory feature should be enabled. Inventory encompasses several facets of application analysis including library detection and usage, HTTP call counting and database usage analysis").a(Category.GENERAL_PROPERTIES).b(d.a("inventory.enable")).h()),
    NOTEAMSERVER_ENABLE(e.a(Boolean.class).a((Boolean)((Object)"contrast.noteamserver.enable")).a((Boolean)false).e().b("boolean to enable/disable Contrast to start up without access to TeamServer").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.enable_disconnected_startup")).h()),
    SERVER_PATH(e.a(String.class).a("contrast.path").c().b("Contrast \"working directory\" override. Defaults to CWD.").a(Category.GENERAL_PROPERTIES).b(d.a("server.path")).h()),
    AGENT_UUID(e.a(String.class).a(UUID.randomUUID().toString()).e().b("The unique identifier for the current agent. Defaults to a new UUID if none is provided.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.uuid")).h()),
    AGENT_VERSION_OVERRIDE(e.a(String.class).c().e().b("Overrides reported agent version, used for internal testing only and should not be used in production").a(Category.INTERNAL_USAGE).b(d.a("agent.java.version")).h()),
    STACKTRACE_CAPTURE(e.a(String.class).a(ServerSettingsAssessDTM.ReportStacktracesEnum.ALL.toString()).b("This property can be set to ALL, SOME, SINK, or NONE and controls the amount of stack traces captured by the agent to be sent in vulnerability events.").a(Category.PERFORMANCE).b(d.a("assess.stacktraces")).e().a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getAssess() != null && serverSettingsDTM.getAssess().getReportStacktraces() != null) {
            return serverSettingsDTM.getAssess().getReportStacktraces().toString();
        }
        return null;
    }).h()),
    EVENT_DETAIL(e.a(String.class).a(ServerSettingsAssessDTM.EventDetailEnum.FULL.toString()).b("Control the values captured by Assess vulnerability events. `FULL` captures most values by calling ToString on objects, which can provide more info but causes increased memory usage. `MINIMAL` has better performance as it only captures String type objects as strings and uses type name for other object type values. `SINK` captures values as `FULL` but only at the sink, for other events it functions as `OFF`. `OFF` captures type name and id only for all objects.").a(Category.PERFORMANCE).b(d.a("assess.event_detail")).h()),
    ROOTAPP(e.a(String.class).a("contrast.rootapp").c().b("This value can override (or provide one if none exist) a display name for the app running at the root context. This may be needed for Contrast to collect analytics on the application.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.root_app_name")).h()),
    ASSESS_SAMPLING_ENABLED(e.a(Boolean.class).a((Boolean)((Object)"contrast.sampling.enabled")).a((Boolean)false).b("Enable sampling mode").a(Category.PERFORMANCE).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getAssess() != null && serverSettingsDTM.getAssess().getSampling() != null) {
            return serverSettingsDTM.getAssess().getSampling().isEnabled();
        }
        return null;
    }).b(d.a("assess.sampling.enable")).h()),
    ASSESS_SAMPLING_BASELINE(e.a(Integer.class).a((Integer)((Object)"contrast.sampling.baseline")).a(5).b("indicates how many requests to analyze in each window before sampling begins").a(Category.PERFORMANCE).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getAssess() != null && serverSettingsDTM.getAssess().getSampling() != null) {
            Integer n2 = serverSettingsDTM.getAssess().getSampling().getBaseline();
            return ConfigProperty.isPositive(n2) ? n2 : null;
        }
        return null;
    }).b(d.a("assess.sampling.baseline")).h()),
    ASSESS_SAMPLING_REQ_FREQUENCY(e.a(Integer.class).a((Integer)((Object)"contrast.sampling.request_frequency")).a(10).b("indicates every nth request (after baseline) will be analyzed").a(Category.PERFORMANCE).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getAssess() != null && serverSettingsDTM.getAssess().getSampling() != null) {
            Integer n2 = serverSettingsDTM.getAssess().getSampling().getRequestFrequency();
            return ConfigProperty.isPositive(n2) ? n2 : null;
        }
        return null;
    }).b(d.a("assess.sampling.request_frequency")).h()),
    ASSESS_SAMPLING_WINDOW_MS(e.a(Integer.class).a((Integer)((Object)"contrast.sampling.window_ms")).a(180000).b("indicates duration for which a sample set is valid, in ms").a(Category.PERFORMANCE).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getAssess() != null && serverSettingsDTM.getAssess().getSampling() != null) {
            Integer n2 = serverSettingsDTM.getAssess().getSampling().getWindow();
            return ConfigProperty.isPositive(n2) ? Integer.valueOf(n2 * 1000) : null;
        }
        return null;
    }).b(d.a("assess.sampling.window_ms")).h()),
    SAMPLING_PURGE_WINDOW_MS(e.a(Long.class).a(10800000L).b("Duration, in ms, until sampling request history map is purged. Default set to 3 hours.").e().a(Category.PERFORMANCE).b(d.a("assess.sampling.purge.window_ms")).h()),
    FEATURE_REQUEST_SAMPLING_ENABLED(e.a(Boolean.class).a((Boolean)true).b("Set to false to disable features that use feature request sampling.").a(Category.INTERNAL_USAGE).c(true).b(d.a("agent.java.feature_request_sampling_enabled")).h()),
    FEATURE_REQUEST_SAMPLING_FREQUENCY(e.a(Integer.class).a(10000).b("").a(Category.INTERNAL_USAGE).c(true).b(d.a("agent.java.feature_request_sampling_frequency")).h()),
    SAVEBYTECODE(e.a(String.class).a("contrast.savebytecode").c().b("Output location of the saved *before/after bytecode* of classes where sensors have been added.").a(Category.DIAGNOSTICS).b(d.a("agent.java.save_bytecode")).h()),
    SAVERESULTS(e.a(String.class).a("contrast.saveresults").a("" + (Object)((Object)SaveReportMode.Never)).b("controls when Contrast findings are saved locally").a(Category.DIAGNOSTICS).b(d.a("assess.save_results")).h()),
    LOCAL_RESULTS_DIR(e.a(String.class).a("contrast.local.results.dir").c().b("controls where Contrast findings are saved locally").a(Category.DIAGNOSTICS).b(d.a("assess.local_results_dir")).h()),
    JARVERIFIER_OVERRIDE(e.a(Boolean.class).a((Boolean)((Object)"contrast.scoped.jarverifier")).a((Boolean)false).b("controls whether the JarInputStream verifier is disabled during our scoped operations").a(Category.DIAGNOSTICS).b(d.a("agent.java.override_scoped_jar_verifier")).h()),
    SCANRESPONSES(e.a(Boolean.class).a((Boolean)((Object)"contrast.scanresponses")).a((Boolean)true).b("boolean to enable/disable scanning of HTTP responses -- override for assess and protect").a(Category.GENERAL_PROPERTIES).d("CONTRAST-30445").h()),
    SCAN_ASSESS_RESPONSES(e.a(Boolean.class).a((Boolean)((Object)"contrast.assess.scanresponses")).a((Boolean)true).b("boolean to enable/disable scanning of HTTP responses -- assess only").a(Category.GENERAL_PROPERTIES).b(d.a("assess.enable_scan_response")).h()),
    SERVER_NAME(e.a(String.class).a("contrast.server").c().b("Overrides name of the server displayed in the Contrast TeamServer. Includes any valid path characters, e.g. *myserver-1/myapp* or *john_dev*.").a(Category.GENERAL_PROPERTIES).b(d.a("server.name")).h()),
    SERVER_ACTIVITY_PERIOD(e.a(Long.class).a((Long)((Object)"contrast.server.activity.period")).a(30000L).b("Polling period for TeamServer polling thread 30000 (30  seconds in milliseconds)").a(Category.GENERAL_PROPERTIES).b(d.a("agent.polling.server_activity_ms")).h()),
    STALE_SERVER_ACTIVITY_UPDATE_MS(e.a(Long.class).a((Long)((Object)"contrast.stale.server.activity.update.ms")).a(300000L).b("The maximum amount of time to wait before requesting new \"server settings\" from TeamServer. Typically, the agent receives new settings each time it sends activity, but if there is no activity the agent will wait this long before requesting new settings. (5 minutes, in milliseconds)").a(Category.GENERAL_PROPERTIES).b(d.a("agent.polling.server_activity_stale_ms")).h()),
    STACKS_MAXDEPTH(e.a(Integer.class).a((Integer)((Object)"contrast.stacks.maxdepth")).a(75).b("max stack depth to include in reported findings, minimum of 2").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.max_stack_depth")).h()),
    TELEMETRY_DIR(e.a(String.class).a("contrast.telemetry.dir").c().b("Location for Contrast telemetry output").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.telemetry_directory")).h()),
    USECONFIG(e.a(String.class).a("contrast.useconfig").c().b("use the contrast.config file packaged in another contrast.jar").a(Category.GENERAL_PROPERTIES).d("TODO: wait what? seriously?").h()),
    LOGGER_ENABLE_INTERNAL_LOGGER_DEBUGGING(e.a(Boolean.class).a((Boolean)false).e().b("When set to true, enables the logger's internal debug information to be printed to stderr (or stdout if we are already logging to stderr).").a(Category.DIAGNOSTICS).b(d.a("agent.java.logger.enable_internal_logger_debugging")).h()),
    LOGGER_STDOUT(e.a(Boolean.class).a((Boolean)((Object)"contrast.stdout")).a((Boolean)false).b("When set to true, all logs will be written to stdout instead of the file system.  May be combined with the corresponding stderr configuration to write to both streams.").a(Category.DIAGNOSTICS).b(d.a("agent.logger.stdout")).h()),
    LOGGER_STDERR(e.a(Boolean.class).a((Boolean)((Object)"contrast.stderr")).a((Boolean)false).b("When set to true, all logs will be written to stderr instead of the file system. May be combined with the corresponding stdout configuration to write to both streams.").a(Category.DIAGNOSTICS).b(d.a("agent.logger.stderr")).h()),
    SUPPRESS_STDOUT(e.a(Boolean.class).a((Boolean)((Object)"contrast.stdout.quiet")).a((Boolean)false).b("When set to true, all normal stdout messages will be suppressed -- has no effects on file or syslog logging").a(Category.DIAGNOSTICS).b(d.a("agent.java.logger.suppress_stdout")).h()),
    SECURITY_LOGGER_LEVEL(e.a(String.class).a("contrast.security.log.level").a(LoggingConstants.DEFAULT_LOGGER_LEVEL.toString()).b("Set the log level for security logging. Values include: trace, debug, info, warn, error, fatal, off. Setting this to off will disable security logging.").a(Category.LOGGING_PROTECT).b(d.a("agent.security_logger.level")).h()),
    LOGGER_LEVEL(e.a(String.class).a("contrast.level").a(LoggingConstants.DEFAULT_LOGGER_LEVEL.toString()).b("Log output level").a(Category.LOGGING_ASSESS).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getLogger() != null) {
            LogLevel logLevel = serverSettingsDTM.getLogger().getLevel();
            return logLevel == null ? null : logLevel.name();
        }
        return null;
    }).b(d.a("agent.logger.level")).h()),
    SECURITY_LOGGER_FILE(e.a(String.class).a("contrast.security.log.file").a("security.log").b("The file to which logging of security events will occur. By default, this file is located at ${HOME}/.contrast/security.log.").a(Category.LOGGING_PROTECT).b(d.a("agent.security_logger.path")).h()),
    LOGGER_LOCATION(e.a(String.class).a("contrast.log").a("contrast.log").b("Enable *diagnostic logging*. This hurts performance, but generates useful information for debugging Contrast. The value set here will be the location to which log output is saved. If no log file exists at this location, one will be created. For instance, */opt/Contrast/contrast.log* will create a log in the */opt/Contrast* directory and rotate it automatically as needed. By default, this file is located at ${HOME}/.contrast/contrast.log").a(Category.LOGGING_ASSESS).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getLogger() != null) {
            return serverSettingsDTM.getLogger().getPath();
        }
        return null;
    }).b(d.a("agent.logger.path")).h()),
    SECURITY_LOGGER_DAILY(e.a(Boolean.class).a((Boolean)((Object)"contrast.security.log.daily")).a((Boolean)false).b("Change the Contrast security logger from a file sized based rolling scheme to a date based rolling scheme. At midnight server time, the previous day's log will be renamed to file_name.yyyy-MM-dd. Note, this scheme does not have a size limit, so manual log pruning will be required. This flag must be set to use the backups and size flags.").a(Category.LOGGING_PROTECT).b(d.a("agent.security_logger.roll_daily")).h()),
    LOGGER_DAILY(e.a(Boolean.class).a((Boolean)((Object)"contrast.log.daily")).a((Boolean)false).b("Change the Contrast logger from a file sized based rolling scheme to a date based rolling scheme. At midnight server time, the previous day's log will be renamed to file_name.yyyy-MM-dd. Note, this scheme does not have a size limit, so manual log pruning will be required. This flag must be set to use the backups and size flags.").a(Category.LOGGING_ASSESS).b(d.a("agent.logger.roll_daily")).h()),
    SECURITY_LOGGER_BACKUPS(e.a(Integer.class).a((Integer)((Object)"contrast.security.log.backups")).a(10).b("Specify the number of \"backup\" logs that will be created before Contrast will clean up the oldest file. This value has a cap of 100, meaning no more than 100 log files can be stored on the file system at one time. A value of 0 here means that no backups will be created and the log will simply be truncated when it reaches its size cap. Note: This property must be used with contrast.security.log.daily=false, or we will continue to log daily and disregard this limit.").a(Category.LOGGING_PROTECT).b(d.a("agent.security_logger.backups")).h()),
    LOGGER_BACKUPS(e.a(Integer.class).a((Integer)((Object)"contrast.log.backups")).a(10).b("Specify the number of \"backup\" logs that will be created before Contrast will clean up the oldest file. This value has a cap of 100, meaning no more than 100 log files can be stored on the file system at one time. A value of 0 here means that no backups will be created and the log will simply be truncated when it reaches its size cap. Note: This property must be used with contrast.log.daily=false, or we will continue to log daily and disregard this limit.").a(Category.LOGGING_ASSESS).b(d.a("agent.logger.backups")).h()),
    SECURITY_LOGGER_SIZE(e.a(Integer.class).a((Integer)((Object)"contrast.security.log.size")).a(100).b("Specify the file size cap, in MB, of each log file. By default, this value is \"100\". Note: This property must be used with contrast.log.daily=false, or we will continue to log daily and disregard this limit.").a(Category.LOGGING_PROTECT).b(d.a("agent.security_logger.roll_size")).h()),
    SECURITY_LOGGER_BUFFER_SIZE(e.a(Integer.class).a(-1).e().b("Specify the Security logger buffer size cap. Must be a power of 2. The default is 128. Log messages are dropped if the buffer exceeds the size.").a(Category.LOGGING_PROTECT).b(d.a("agent.java.security_logger.buffer_size")).h()),
    LOGGER_SIZE(e.a(Integer.class).a((Integer)((Object)"contrast.log.size")).a(100).b("Specify the file size cap, in MB, of each log file. By default, this value is \"100\". Note: This property must be used with contrast.log.daily=false, or we will continue to log daily and disregard this limit.").a(Category.LOGGING_ASSESS).b(d.a("agent.logger.roll_size")).h()),
    LOGGER_BUFFER_SIZE(e.a(Integer.class).a(-1).e().b("Specify the Contrast logger buffer size cap. Must be a power of 2. The default is 128. The default if the agent is in DEBUG mode or higher is 16384. Log messages are dropped if the buffer exceeds the size.").a(Category.LOGGING_ASSESS).b(d.a("agent.java.logger.buffer_size")).h()),
    LOGGER_SHUTDOWN_TIMEOUT(e.a(Long.class).a(10000L).e().b("LoggerManager shutdown timeout in seconds.").a(Category.LOGGING_ASSESS).b(d.a("agent.java.logger.shutdown_timeout_ms")).h()),
    CEF_SYSLOGGER_ENABLE(e.a(Boolean.class).a((Boolean)false).b("flag for controlling the use of Syslog").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            return serverSettingsDTM.getSecurityLogger().getSyslog().isSyslogEnabled();
        }
        return null;
    }).b(d.a("agent.security_logger.syslog.enable")).h()),
    CEF_SYSLOGGER_SERVER_INFO_ENABLE(e.a(Boolean.class).a((Boolean)false).e().b("flag to enable logging server and hostname as key value pairs in syslog.").a(Category.LOGGING_PROTECT).b(d.a("agent.java.security_logger.syslog.enable_server_info")).h()),
    CEF_SYSLOGGER_BUFFER_SIZE(e.a(Integer.class).a(-1).e().b("Specify the Syslog logger buffer size cap. Must be a power of 2. The default is 128. Log messages are dropped if the buffer exceeds the size.").a(Category.LOGGING_PROTECT).b(d.a("agent.java.security_logger.syslog.buffer_size")).h()),
    CEF_SYSLOGGER_HOST_NEW(e.a(String.class).a("").e().b("Set the address of the Syslog server to which the agent should send messages.  This can be a fully qualified domain name or ip address; e.g. syslog.hostname.com or 10.10.10.13").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            return serverSettingsDTM.getSecurityLogger().getSyslog().getSyslogIpAddress();
        }
        return null;
    }).b(d.a("agent.security_logger.syslog.server_host", false)).h()),
    CEF_SYSLOGGER_HOST(e.a(String.class).a("localhost").b("Set the address of the Syslog server to which the agent should send messages.  This can be a fully qualified domain name or ip address; e.g. syslog.hostname.com or 10.10.10.13").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            return serverSettingsDTM.getSecurityLogger().getSyslog().getSyslogIpAddress();
        }
        return null;
    }).b(d.a("agent.security_logger.syslog.ip")).h()),
    CEF_SYSLOGGER_PROTOCOL(e.a(String.class).a("").e().b("Specify the connection protocol used for the Syslog server connection.  Value options are 'UDP' (default), 'TCP', or 'TCP_TLS'.  Default if missing is UDP.").a(Category.LOGGING_PROTECT).b(d.a("agent.security_logger.syslog.protocol")).h()),
    CEF_SYSLOGGER_PORT(e.a(Integer.class).a(514).b("The port of the Syslog server to which we should send messages").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            return serverSettingsDTM.getSecurityLogger().getSyslog().getSyslogPortNumber();
        }
        return null;
    }).b(d.a("agent.security_logger.syslog.port")).h()),
    CEF_SYSLOGGER_FACILITY(e.a(Integer.class).a(19).b("The facility code of the messages we are sending to Syslog").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            return serverSettingsDTM.getSecurityLogger().getSyslog().getSyslogFacilityCode();
        }
        return null;
    }).b(d.a("agent.security_logger.syslog.facility")).h()),
    CEF_SYSLOGGER_HEARTBEAT(e.a(Boolean.class).a((Boolean)false).b("Set to `true` to enable the Syslog heartbeat.  The heartbeat will issue a Syslog message every after every interval passes.").a(Category.LOGGING_PROTECT).b(d.a("agent.security_logger.syslog.heartbeat.enable")).h()),
    CEF_SYSLOGGER_HEARTBEAT_INTERVAL(e.a(Integer.class).a(60000).b("Set the interval of the Syslog server of which to send heartbeat messages to the Syslog server. (in milliseconds)").a(Category.LOGGING_PROTECT).b(d.a("agent.security_logger.syslog.heartbeat.interval_ms")).h()),
    CEF_SYSLOGGER_EXPLOITED_LEVEL(e.a(String.class).a("ALERT").b("Set the log level of Exploited attacks. Value options are `ALERT`, `CRITICAL`, `ERROR`, `WARNING`, `NOTICE`, `INFO`, and `DEBUG`.").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            SyslogSeverity syslogSeverity = serverSettingsDTM.getSecurityLogger().getSyslog().getSyslogSeverityExploited();
            return syslogSeverity == null ? null : syslogSeverity.name();
        }
        return null;
    }).b(d.a("agent.security_logger.syslog.severity_exploited")).h()),
    CEF_SYSLOGGER_SUSPICIOUS_LEVEL(e.a(String.class).a("WARNING").e().b("Set the log level of Suspicious attacks. Value options are `ALERT`, `CRITICAL`, `ERROR`, `WARNING`, `NOTICE`, `INFO`, and `DEBUG`.").a(Category.LOGGING_PROTECT).b(d.a("agent.security_logger.syslog.severity_suspicious")).h()),
    CEF_SYSLOGGER_BLOCKED_LEVEL(e.a(String.class).a("NOTICE").b("Set the log level of Blocked attacks. Value options are `ALERT`, `CRITICAL`, `ERROR`, `WARNING`, `NOTICE`, `INFO`, and `DEBUG`.").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            SyslogSeverity syslogSeverity = serverSettingsDTM.getSecurityLogger().getSyslog().getSyslogSeverityBlocked();
            return syslogSeverity == null ? null : syslogSeverity.name();
        }
        return null;
    }).b(d.a("agent.security_logger.syslog.severity_blocked")).h()),
    CEF_SYSLOGGER_PROBED_LEVEL(e.a(String.class).a("WARNING").b("Set the log level of Probed attacks. Value options are `ALERT`, `CRITICAL`, `ERROR`, `WARNING`, `NOTICE`, `INFO`, and `DEBUG`.").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            SyslogSeverity syslogSeverity = serverSettingsDTM.getSecurityLogger().getSyslog().getSyslogSeverityProbed();
            return syslogSeverity == null ? null : syslogSeverity.name();
        }
        return null;
    }).b(d.a("agent.security_logger.syslog.severity_probed")).h()),
    OBJECT_CACHE(e.a(Boolean.class).a((Boolean)true).e().b("Determines if the agent will always store a reference to an object when possible. To utilize the legacy approach set this to false.").a(Category.PERFORMANCE).b(d.a("agent.java.object_cache")).h()),
    OBSERVE_ENABLE(e.a(Boolean.class).a((Boolean)false).b("Lightweight and low overhead observation mode for the agent.").a(Category.GENERAL_PROPERTIES).b(d.a("observe.enable")).h()),
    OBSERVE_METRICS_ENDPOINT(e.a(String.class).c().b("The URL for exporting OpenTelemetry metrics collected by Observe").a(Category.GENERAL_PROPERTIES).e().b(d.a("agent.java.observe_metrics_endpoint")).h()),
    OBSERVE_TRACING_ENDPOINT(e.a(String.class).c().b("The URL for exporting OpenTelemetry traces collected by Observe").a(Category.GENERAL_PROPERTIES).e().b(d.a("agent.java.observe_tracing_endpoint")).h()),
    OBSERVE_TRACING_SAMPLING_INTERVAL(e.a(Long.class).a(300000L).b("The sampling interval. Traces are sampled once per route in a given sampling interval").a(Category.GENERAL_PROPERTIES).e().b(d.a("agent.java.observe_tracing_sampling_interval_ms")).h()),
    OBSERVE_SENSOR_DEDUPLICATION_MAX(e.a(Integer.class).a(1).b("The number of times a sensor can trigger per request, when sensor deduplication is enabled. When sensor deduplication is disabled, this setting has no effect.").a(Category.GENERAL_PROPERTIES).e().b(d.a("agent.java.observe_sensor_deduplication_max")).h()),
    OBSERVE_METRICS_EXPORT_INTERVAL(e.a(Long.class).a(300000L).b("The interval in ms at which metrics are exported to the collector.").a(Category.GENERAL_PROPERTIES).e().b(d.a("agent.java.observe_metrics_export_interval_ms")).h()),
    PROTECT_SQL_CANARY(e.a(String.class).a("contrast.defend.sql.canary").c().e().b("In order to get diagnostics about how the SQL is being analyzed for protect purposes, you can log queries that contain the canary specified by this setting.").a(Category.LOGGING_PROTECT).b(d.a("protect.sql_canary")).h()),
    PROTECT_BEAN_INTROSPECTION_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2010-1622.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.BEAN_INTROSPECTION)).b(d.a("protect.rules.cve-2010-1622.mode")).h()),
    PROTECT_CLASS_LOADER_MANIPULATION_MODE(e.a(CommonConfigProtectionMode.class).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CLASSLOADER_MANIPULATION)).b(d.a("protect.rules.class-loader-manipulation.mode")).h()),
    PROTECT_CMDI_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cmd-injection.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CMD_INJECTION)).b(d.a("protect.rules.cmd-injection.mode")).h()),
    PROTECT_CMDI_BACKDOORS(e.a(Boolean.class).a((Boolean)((Object)"contrast.defend.cmdinjection.backdoors")).a((Boolean)true).b("Detect when the agent sees user parameters being executed as system commands. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.rules.cmd-injection.detect_parameter_command_backdoors")).h()),
    PROTECT_CMDI_CHAINS(e.a(Boolean.class).a((Boolean)((Object)"contrast.defend.cmdinjection.chaining")).a((Boolean)true).b("Detect when a system command is issued which contains chained commands. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.rules.cmd-injection.detect_chained_commands")).h()),
    PROTECT_CMDI_DANGEROUS_PATH_ARGS(e.a(Boolean.class).a((Boolean)true).b("Detect when a system command is issued which contains a dangerous path argument - e.g. /etc/passwd. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.rules.cmd-injection.detect_dangerous_path_args")).h()),
    PROTECT_CMDI_PHASES(e.a(Boolean.class).a((Boolean)((Object)"contrast.defend.cmdinjection.phases")).a((Boolean)true).e().b("controls whether phased commands queries will be blocked").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.rules.cmd-injection.detect_phased_commands")).h()),
    PROTECT_CVE_2011_2730_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2011-2730.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CVE_2011_2730)).b(d.a("protect.rules.cve-2011-2730.mode")).h()),
    PROTECT_CVE_2011_2732_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2011-2732.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.SPRING_HEADER_INJECTION)).b(d.a("protect.rules.cve-2011-2732.mode")).h()),
    PROTECT_CVE_2014_0112_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2014-0112.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CVE_2014_0112)).b(d.a("protect.rules.cve-2014-0112.mode")).h()),
    PROTECT_CVE_2014_0114_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2014-0114.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CVE_2014_0114)).b(d.a("protect.rules.cve-2014-0114.mode")).h()),
    PROTECT_CVE_2014_0116_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2014-0116.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CVE_2014_0116)).b(d.a("protect.rules.cve-2014-0116.mode")).h()),
    PROTECT_CVE_2017_5638_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2017-5638.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CVE_2017_5638)).b(d.a("protect.rules.cve-2017-5638.mode")).h()),
    PROTECT_CVE_2017_9791_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2017-9791.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CVE_2017_9791)).b(d.a("protect.rules.cve-2017-9791.mode")).h()),
    PROTECT_CVE_2017_12616_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2017-12616.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CVE_2017_12616)).b(d.a("protect.rules.cve-2017-12616.mode")).h()),
    PROTECT_CVE_2017_12617_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2017-12617.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CVE_2017_12617)).b(d.a("protect.rules.cve-2017-12617.mode")).h()),
    PROTECT_CVE_2016_4438_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2016-4438.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.DEFAULT_ACTION_INVOCATION)).b(d.a("protect.rules.cve-2016-4438.mode")).h()),
    PROTECT_CVE_2016_3081_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2016-3081.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.DEFAULT_ACTION_MAPPER)).b(d.a("protect.rules.cve-2016-3081.mode")).h()),
    PROTECT_EL_INJECTION_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.expression-language-injection.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.EL_INJECTION)).b(d.a("protect.rules.expression-language-injection.mode")).h()),
    PROTECT_METHOD_TAMPERING_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.method-tampering.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.HTTP_METHOD_TAMPERING)).b(d.a("protect.rules.method-tampering.mode")).h()),
    PROTECT_METRIC_GATHERING_MODE(e.a(CommonConfigProtectionMode.class).a(CommonConfigProtectionMode.MONITOR).b("if present, controls the mode of the metric gathering synthetic rule; can be monitor or off (default: monitor). If at any point the telemetry system is disabled then the metric gathering rule will be as well, regardless of the value of this property.").a(Category.INTERNAL_USAGE).e().b(d.a("protect.rules.metric-gathering.mode")).h()),
    PROTECT_OGNL_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.ognl-injection.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.OGNL_INJECTION)).b(d.a("protect.rules.ognl-injection.mode")).h()),
    PROTECT_PATH_TRAVERSAL_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.path-traversal.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.PATH_TRAVERSAL)).b(d.a("protect.rules.path-traversal.mode")).h()),
    PROTECT_PT_CUSTOM_CODE_ACCESS(e.a(Boolean.class).a((Boolean)((Object)"contrast.defend.pathtraversal.detect_custom_code_accessing_system_files")).a((Boolean)true).b("Detect when custom code attempts to access sensitive system files. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.rules.path-traversal.detect_custom_code_accessing_system_files")).h()),
    PROTECT_PT_COMMON_EXPLOIT(e.a(Boolean.class).a((Boolean)((Object)"contrast.defend.pathtraversal.detect_common_file_exploits")).a((Boolean)true).b("Detect when users attempt to bypass filters by using \"::$DATA\" channels or null bytes in file names. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.rules.path-traversal.detect_common_file_exploits")).h()),
    PROTECT_PROCESS_HARDENING_MODE(e.a(CommonConfigProtectionMode.class).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.PROCESS_HARDENING)).b(d.a("protect.rules.process-hardening.mode")).h()),
    PROTECT_CODE_INJECTION_HARDENING_MODE(e.a(CommonConfigProtectionMode.class).a(CommonConfigProtectionMode.OFF).e().b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CODE_INJECTION_HARDENING)).b(d.a("protect.rules.code-injection-hardening.mode")).h()),
    PROTECT_SIGNATURE_TAMPERING_MODE(e.a(CommonConfigProtectionMode.class).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.SIGNATURE_TAMPERING)).b(d.a("protect.rules.signature-tampering.mode")).h()),
    PROTECT_SQLI_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.sql-injection.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.SQL_INJECTION)).b(d.a("protect.rules.sql-injection.mode")).h()),
    PROTECT_SQL_SEMANTIC_UNIONS(e.a(Boolean.class).a((Boolean)((Object)"contrast.defend.sqlinjection.suspiciousunions")).a((Boolean)false).b("Tell the agent to detect when semantic analysis of the query reveals database queries are being made for system tables and sensitive information. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.rules.sql-injection.detect_suspicious_unions")).h()),
    PROTECT_SQL_SEMANTIC_TAUTOLOGIES(e.a(Boolean.class).a((Boolean)((Object)"contrast.defend.sqlinjection.tautologies")).a((Boolean)false).b("Tell the agent to detect when semantic analysis of the query reveals tautologies used in exfiltration attacks (e.g., \"or 1=1\" or \"or 2<>3\"). The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.rules.sql-injection.detect_tautologies")).h()),
    PROTECT_SQL_SEMANTIC_CHAINING(e.a(Boolean.class).a((Boolean)((Object)"contrast.defend.sqlinjection.chaining")).a((Boolean)false).b("Tell the agent to detect when semantic analysis of the query reveals chained queries, which is uncommon in normal usage but common in exploit. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.rules.sql-injection.detect_chained_queries")).h()),
    PROTECT_SQL_AGGRESSIVE_COMMENT(e.a(Boolean.class).a((Boolean)((Object)"contrast.defend.sqlinjection.aggressive_comment")).a((Boolean)false).b("controls whether aggressive comment filtering is used to block").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.rules.sql-injection.aggressive_comment")).h()),
    PROTECT_SQL_SEMANTIC_DANGEROUS_FUNCTIONS(e.a(Boolean.class).a((Boolean)((Object)"contrast.defend.sqlinjection.dangerous_functions")).a((Boolean)false).b("Tell the agent to detect when semantic analysis of the query reveals the invocation of dangerous functions typically used in weaponized exploits. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.rules.sql-injection.detect_dangerous_functions")).h()),
    PROTECT_SQL_SEMANTIC_FINDING_CACHE_SIZE(e.a(Integer.class).a((Integer)((Object)"contrast.semantic_findings_cache_size")).a(300).b("Set the number of queries for which semantic analysis findings are cached. Set to 0 to disable caching").a(Category.PROTECT_MODE_CONFIG).b(d.a("agent.java.semantic_findings_cache_size")).h()),
    PROTECT_CVE_2013_2251_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2013-2251.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.STRUTS2_CVE_2013_2251)).b(d.a("protect.rules.cve-2013-2251.mode")).h()),
    PROTECT_CVE_2021_44228_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2021-44228.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CVE_2021_44228)).b(d.a("protect.rules.cve-2021-44228.mode")).h()),
    PROTECT_CVE_2022_41852_MODE(e.a(CommonConfigProtectionMode.class).a(CommonConfigProtectionMode.OFF).b("Set the rule mode. Valid values are `monitor`, `block`, or `off`.\nUse `monitor` to report attacks but not block them, or `block` to block attacks, and `off` to disable the rule's analysis entirely.\nPlease refer to https://docs.contrastsecurity.com/en/set-protect-rules.html to learn more about the different rule modes.").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CVE_2022_41852)).b(d.a("protect.rules.cve-2022-41852.mode")).h()),
    PROTECT_DESERIALIZATION_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.untrusted-deserialization.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.UNTRUSTED_DESERIALIZATION)).b(d.a("protect.rules.untrusted-deserialization.mode")).h()),
    PROTECT_XSLT_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2016-3082.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.XSLT_RESULT)).b(d.a("protect.rules.cve-2016-3082.mode")).h()),
    PROTECT_XSS_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.reflected-xss.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.XSS)).b(d.a("protect.rules.reflected-xss.mode")).h()),
    PROTECT_XXE_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.xxe.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.XXE)).b(d.a("protect.rules.xxe.mode")).h()),
    PROTECT_UNSAFE_FILE_UPLOAD_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.unsafe-file-upload.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.UNSAFE_FILE_UPLOAD)).b(d.a("protect.rules.unsafe-file-upload.mode")).h()),
    UNSAFE_FILE_UPLOAD_THRESHOLD_DISABLED(e.a(Boolean.class).a((Boolean)((Object)"contrast.unsafe-file-upload.threshold")).a((Boolean)false).e().b("boolean to enable/disable the threshold after which an input is no longer checked against possible attack patterns").a(Category.PROTECT_MODE_CONFIG).d("We don't need to make this available to users").h()),
    PROTECT_ZFO_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.zip-file-overwrite.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.ZIP_FILE_OVERWRITE)).b(d.a("protect.rules.zip-file-overwrite.mode")).h()),
    PROTECT_JNDI_MODE(e.a(CommonConfigProtectionMode.class).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.JNDI_INJECTION)).b(d.a("protect.rules.jndi-injection.mode")).h()),
    PROTECT_RULE_MODE_OVERRIDE(e.a(ProtectionModeDTM.class).a((ProtectionModeDTM)((Object)"contrast.defend.rulemode")).c().e().b("Valid values: off, blocking, monitoring. An override setting for whether protection rules should all be in off, monitoring or blocking modes").a(Category.PROTECT_MODE_CONFIG).d("JAVA-212").h()),
    POLICY(e.a(String.class).a("contrast.policy").c().b("If you set this value to a file or URL, Contrast will use it in addition to the pre-packaged security policy. This means that rules from both the standard Contrast policy and your custom policy will be used, with conflicts being resolved in favor of the external policy, i.e. if two sources have the same ID, one in the internal policy and one in the external, the external source will be used.").a(Category.POLICY).b(d.a("agent.java.external_policy_files")).h()),
    POLICY_OVERRIDES(e.a(String.class).a("contrast.policy.overrides").c().b("Same functionality as contrast.policy, but policies listed here have a higher priority, meaning that conflicts will be resolved in favor of the overrides policy, i.e. if two sources have the same ID, one in the policy and one in the override, the override source will be used. ").a(Category.POLICY).b(d.a("agent.java.external_policy_overrides")).h()),
    POLICY_STANDALONE(e.a(String.class).a("contrast.policy.standalone").c().b("If you set this value to a file or URL, Contrast will use it instead of the pre-packaged security policy. For more information about rule customization, please contact your account manager.").a(Category.POLICY).b(d.a("agent.java.standalone_policy")).h()),
    POLICY_CUSTOM_TRIGGERS(e.a(String.class).a("contrast.policy.custom.triggers").c().e().b("A list of rule and custom trigger for each rule, formatted rule-id:com.package.Class.methodname(argType,argType,argType,...) where the argType of interest is marked with a *").a(Category.POLICY).b(d.a("agent.java.custom_triggers")).h()),
    ASSESS_DISABLED_RULES(e.a(String.class).a("contrast.disabledrules").a("").b("list of comma-separated disabled rule ids").a(Category.RULES_CONFIG).a(applicationSettingsDTM -> {
        if (applicationSettingsDTM == null) {
            return null;
        }
        ApplicationAssessSettingsDTM applicationAssessSettingsDTM = applicationSettingsDTM.getAssessment();
        if (applicationAssessSettingsDTM == null) {
            return null;
        }
        Set<String> set = applicationAssessSettingsDTM.getDisabledRules();
        if (set == null || set.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(set.size() * 16);
        for (String string : set) {
            stringBuilder.append(string);
            stringBuilder.append(',');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }).b(d.a("assess.rules.disabled_rules")).h()),
    DISABLEDSOURCES(e.a(String.class).a("contrast.disabledsources").c().b("list of comma-separated disabled source ids").a(Category.RULES_CONFIG).b(d.a("agent.java.disabled_sources")).h()),
    DISABLEDPROPAGATORS(e.a(String.class).a("contrast.disabledpropagators").c().e().b("list of comma-separated disabled propagator ids").a(Category.RULES_CONFIG).b(d.a("agent.java.disabled_propagators")).h()),
    DEADZONES(e.a(Boolean.class).a((Boolean)((Object)"contrast.deadzones")).a((Boolean)true).b("boolean to enable/disable loading of deadzones from policy").a(Category.RULES_CONFIG).b(d.a("assess.enable_deadzones")).h()),
    SOURCES(e.a(Boolean.class).a((Boolean)((Object)"contrast.sources")).a((Boolean)true).b("boolean to enable/disable loading of sources from policy").a(Category.RULES_CONFIG).b(d.a("assess.enable_sources")).h()),
    DYNAMIC_SOURCES(e.a(Boolean.class).a((Boolean)((Object)"contrast.dynamicsources")).a((Boolean)true).b("boolean to enable/disable loading of dynamic sources from policy").a(Category.RULES_CONFIG).b(d.a("assess.enable_dynamic_sources")).h()),
    PROPAGATORS(e.a(Boolean.class).a((Boolean)((Object)"contrast.propagators")).a((Boolean)true).b("boolean enable/disable loading of propagators from policy").a(Category.RULES_CONFIG).b(d.a("assess.enable_propagators")).h()),
    TAGS(e.a(Boolean.class).a((Boolean)((Object)"contrast.tags")).a((Boolean)true).b("boolean to enable/disable loading of tags from policy").a(Category.RULES_CONFIG).b(d.a("assess.enable_taggers")).h()),
    ANNOTATIONS(e.a(Boolean.class).a((Boolean)((Object)"contrast.annotations")).a((Boolean)true).b("boolean enable/disable loading of annotations from policy").a(Category.RULES_CONFIG).b(d.a("assess.enable_annotations")).h()),
    RULES(e.a(Boolean.class).a((Boolean)((Object)"contrast.rules")).a((Boolean)true).b("boolean to enable/disable loading of rules from policy").a(Category.RULES_CONFIG).b(d.a("assess.enable_rules")).h()),
    VALIDATORS(e.a(Boolean.class).a((Boolean)((Object)"contrast.validators")).a((Boolean)true).b("boolean to enable/disable loading of validators from policy").a(Category.RULES_CONFIG).b(d.a("assess.enable_validators")).h()),
    ADAPTIVE_OPTIMIZATION(e.a(Boolean.class).a((Boolean)((Object)"contrast.adaptiveoptimizations")).a((Boolean)false).e().b("boolean to enable/disable the real-time learning to tune Assess rules").a(Category.RULES_CONFIG).b(d.a("assess.enable_adaptive_optimization")).h()),
    ADAPTIVE_OPTIMIZATION_FREQUENCY(e.a(Integer.class).a((Integer)((Object)"contrast.adaptiveoptimizations.frequency")).a(200).e().b("how many propagation events should be sampled to find low-yield code paths (turn higher to hurt short-term performance in order to find optimizations quicker)").a(Category.RULES_CONFIG).b(d.a("assess.adaptive_optimization_frequency")).h()),
    ADAPTIVE_OPTIMIZATION_MAXIMUM(e.a(Integer.class).a((Integer)((Object)"contrast.adaptiveoptimizations.max")).a(20).e().b("how many instances of a particular low-yield propagation code path can be observed before being disabled").a(Category.RULES_CONFIG).b(d.a("assess.adaptive_optimization_max")).h()),
    ADAPTIVE_OPTIMIZATION_PER_REQUEST(e.a(Boolean.class).a((Boolean)((Object)"contrast.adaptiveoptimizations.sources.considerrequest")).a((Boolean)false).e().b("controls whether data paths should be considered per-URI instead of globally").a(Category.RULES_CONFIG).b(d.a("assess.adaptive_optimization_per_request")).h()),
    VALIDATOR_SCOPES(e.a(Boolean.class).a((Boolean)((Object)"contrast.validator.scopes")).a((Boolean)true).b("boolean to enable/disable loading of validator-scopes").a(Category.RULES_CONFIG).b(d.a("assess.enable_validator_scopes")).h()),
    INTERN_PREVENTION_SCOPES(e.a(Boolean.class).a((Boolean)((Object)"contrast.internPrevention.scopes")).a((Boolean)true).e().b("boolean to enable/disable loading of intern-prevention-scopes").a(Category.RULES_CONFIG).b(d.a("assess.enable_intern_scopes")).h()),
    MAX_CONTEXT_SOURCE_EVENTS(e.a(Integer.class).a((Integer)((Object)"contrast.assess.context.max.sources")).a(100).e().b("the maximum number of untrusted data flows to observe per request").a(Category.PERFORMANCE).b(d.a("assess.max_context_source_events")).h()),
    MAX_CONTEXT_PROPAGATION_EVENTS(e.a(Integer.class).a((Integer)((Object)"contrast.assess.context.max.propagations")).a(250).e().b("the maximum number of untrusted data flow propagations to observe per request").a(Category.PERFORMANCE).b(d.a("assess.max_propagation_events")).h()),
    MAX_GLOBAL_TRACE_MAP_SIZE(e.a(Integer.class).a(1050).e().b("the maximum number of objects to store in the global trace map").a(Category.PERFORMANCE).b(d.a("assess.global.max_global_trace_map_size")).h()),
    MAX_TRACE_TTL(e.a(Long.class).a((Long)((Object)"contrast.trace.ttl.max")).a(15000L).e().b("the number of milliseconds to retain a trace with a strongly held reference").a(Category.PERFORMANCE).b(d.a("assess.trace_max_ttl_ms")).h()),
    TRACE_MAP_STRATEGY(e.a(String.class).a("contrast.trace.map").a("" + (Object)((Object)TraceMapStrategy.BOTH)).e().b("the strategy for tracking data: 'global', which allows data to be tracked across threads and requests, 'context', which limits data flows to a single request/response scope, or 'both', which tries to use context scope, but defaults to both").a(Category.PERFORMANCE).b(d.a("agent.java.trace_map_strategy")).h()),
    PROPERTIES(e.a(String.class).a("contrast.properties").c().e().b("location of file containing Java properties style key, value pairs. ").d("Like contrast.config.path, impossible to set via YAML").a(Category.GENERAL_PROPERTIES).h()),
    PROTECT_ENABLED(e.a(Boolean.class).a((Boolean)((Object)"contrast.defend.enabled")).a((Boolean)false).b("If present, used to determine if the Protect feature should be enabled. If not present, decision delegated to Contrast UI").a(Category.PROTECT_MODE_CONFIG).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getProtect() != null) {
            return serverSettingsDTM.getProtect().getEnable();
        }
        return null;
    }).b(d.a("protect.enable")).h()),
    PROTECT_APPCHECK_ENABLED(e.a(Boolean.class).a((Boolean)((Object)"contrast.defend.appcheck.enabled")).a((Boolean)true).e().b("boolean to enable/disable AppCheck when Contrast is in PROTECT mode").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.enable_appcheck")).h()),
    PROTECT_API_BODY_READ(e.a(Boolean.class).a((Boolean)((Object)"contrast.defend.api.bodyread")).a((Boolean)true).b("boolean to enable/disable whether API request bodies should be scanned for attacks if no known deserializers are in use").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.enable_api_request_body_reading")).h()),
    PROTECT_BOT_BLOCKER_ENABLE(e.a(Boolean.class).a((Boolean)((Object)"contrast.defend.botblocker")).a((Boolean)false).b("configures Contrast to use simple signaturing to block traffic from scrapers, attack tools, and other unwanted automation.").a(Category.PROTECT_MODE_CONFIG).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getProtect() != null && serverSettingsDTM.getProtect().getRules() != null && serverSettingsDTM.getProtect().getRules().getBotBlocker() != null) {
            return serverSettingsDTM.getProtect().getRules().getBotBlocker().getEnabled();
        }
        return null;
    }).b(d.a("protect.rules.bot-blocker.enable")).h()),
    PROTECT_SINKS(e.a(Boolean.class).a((Boolean)((Object)"contrast.defend.sinks")).a((Boolean)true).e().b("boolean to enable/disable monitoring sinks when Contrast is in PROTECT mode").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.enable_sinks")).h()),
    DESERIALIZER_TRACE_BODY_READ(e.a(Boolean.class).a((Boolean)((Object)"contrast.deserializer.trace.body.read")).a((Boolean)false).e().b("Outputs stack trace when agent fails to analyze request body deserialization").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.enable_body_stacktraces")).h()),
    XSS_KEYWORDS(e.a(String.class).a("contrast.xss.keywords").c().e().b("File path to overriding XSS keywords file").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.xss_keywords_file")).h()),
    XSS_PATTERNS(e.a(String.class).a("contrast.xss.patterns").c().e().b("Location of XSS patterns file").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.xss_patterns_file")).h()),
    XSS_THRESHOLD_DISABLED(e.a(Boolean.class).a((Boolean)((Object)"contrast.xss.threshold")).a((Boolean)false).e().b("boolean to enable/disable the threshold after which an input is no longer checked against possible attack patterns").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.enable_xss_threshold")).h()),
    SQLINJECTION_KEYWORDS(e.a(String.class).a("contrast.sqlinjection.keywords").c().e().b("File path to overriding SQL Injection keywords file").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.rules.sql-injection.keywords_file")).h()),
    SQLINJECTION_PATTERNS(e.a(String.class).a("contrast.sqlinjection.patterns").c().e().b("Location of SQL Injection patterns file").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.rules.sql-injection.patterns_file")).h()),
    SQLINJECTION_THRESHOLD_DISABLED(e.a(Boolean.class).a((Boolean)((Object)"contrast.sqlinjection.threshold")).a((Boolean)false).e().b("boolean to enable/disable the threshold after which an input is no longer checked against possible SQL Injection attack patterns").a(Category.PROTECT_MODE_CONFIG).d("CONTRAST-30448").h()),
    CMDINJECTION_THRESHOLD_DISABLED(e.a(Boolean.class).a((Boolean)((Object)"contrast.cmdinjection.threshold")).a((Boolean)false).e().b("boolean to enable/disable the threshold after which an input is no longer checked against possible Command Injection attack patterns").a(Category.PROTECT_MODE_CONFIG).d("CONTRAST-30449").h()),
    CMDINJECTION_KEYWORDS(e.a(String.class).a("contrast.cmdinjection.keywords").c().e().b("File path to overriding Command Injection keywords file").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.rules.cmd-injection.keywords_file")).h()),
    CMDINJECTION_PATTERNS(e.a(String.class).a("contrast.cmdinjection.patterns").c().e().b("Location of Command Injection patterns file").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.rules.cmd-injection.patterns_file")).h()),
    PATH_TRAVERSAL_KEYWORDS(e.a(String.class).a("contrast.pathtraversal.keywords").e().c().b("File path to overriding Path traversal keywords file").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.rules.path-traversal.keywords_file")).h()),
    PATH_TRAVERSAL_PATTERNS(e.a(String.class).a("contrast.pathtraversal.patterns").e().c().b("Location of Path traversal patterns file").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.rules.path-traversal.patterns_file")).h()),
    PATH_TRAVERSAL_THRESHOLD_DISABLED(e.a(Boolean.class).a((Boolean)((Object)"contrast.pathtraversal.threshold")).a((Boolean)false).e().b("boolean to enable/disable the threshold after which an input is no longer checked against possible Path traversal attack patterns").a(Category.PROTECT_MODE_CONFIG).d("JAVA-3554").h()),
    PROTECT_INEFFECTIVE_SAMPLES(e.a(Integer.class).a((Integer)((Object)"contrast.defend.ineffective.samples")).a(50).b("Max number of detailed reports generated for ineffective attacks detected during a reporting period").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.samples.probed")).h()),
    PROTECT_PROBE_ANALYSIS_ENABLE(e.a(Boolean.class).a((Boolean)true).b("Set to `false` to disable probe analysis").a(Category.DIAGNOSTICS).b(d.a("protect.probe_analysis.enable")).h()),
    PROTECT_BLOCKED_SAMPLES(e.a(Integer.class).a((Integer)((Object)"contrast.defend.blocked.samples")).a(25).b("Max number of detailed reports generated for blocked attacks detected during a reporting period").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.samples.blocked")).h()),
    PROTECT_PERIMETER_BLOCKED_SAMPLES(e.a(Integer.class).a((Integer)((Object)"contrast.defend.blockedperimeter.samples")).a(25).b("Max number of detailed reports generated for perimeter blocked attacks detected during a reporting period").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.samples.blocked_at_perimeter")).h()),
    PROTECT_EXPLOITED_SAMPLES(e.a(Integer.class).a((Integer)((Object)"contrast.defend.exploited.samples")).a(100).b("Max number of detailed reports generated for exploited attacks during a reporting period").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.samples.exploited")).h()),
    PROTECT_SUSPICIOUS_SAMPLES(e.a(Integer.class).a((Integer)((Object)"contrast.protect.suspicious.samples")).a(100).b("Max number of detailed reports generated for suspicious attacks during a reporting period").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.samples.suspicious")).h()),
    PROTECT_DISABLED_RULES(e.a(String.class).a("contrast.defend.disabled.rules").a("").b("Comma separated list of protect rules to disable for this JVM").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.rules.disabled_rules")).h()),
    USE_URL_IN_HASH(e.a(Boolean.class).a((Boolean)((Object)"contrast.assess.hashing.includeurl")).a((Boolean)false).b("Set to \"true\" to factor in request URL when computing hash for reported finding").a(Category.RULES_CONFIG).b(d.a("assess.include_url_in_finding_hash")).h()),
    USE_METHOD_CACHE(e.a(Boolean.class).a((Boolean)((Object)"contrast.assess.methodcache")).a((Boolean)true).e().b("used to tell whether we should attempt to conserve heap by caching method signatures").a(Category.PERFORMANCE).b(d.a("assess.enable_method_cache")).h()),
    WEBSERVICE_RESPONSE_TRACK(e.a(Boolean.class).a((Boolean)false).e().b("Configures Contrast Assess analysis for responses from requests to web services.\nTRUE:   The agent will treat web service responses as untrusted and track propagation of data from web service responses.\nFALSE:  The agent will treat web service responses as trusted.").a(Category.PERFORMANCE).b(d.a("agent.java.enable_web_service_response_tracking")).h()),
    WEBSPHERE_SHARED_LIB_DIR(e.a(String.class).a("contrast.websphere.shared.libs").c().b("Location of shared library directory on WebSphere").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.websphere_shared_libs_directory")).h()),
    ASSESS_AUTODETECT_CONTROLS(e.a(Boolean.class).a((Boolean)((Object)"contrast.assess.autodetect.controls")).a((Boolean)true).b("boolean to enable/disable detecting security sensors").a(Category.DIAGNOSTICS).b(d.a("assess.enable_sensor_autodetection")).h()),
    ASSESS_REGEX_SECURITY_CONTROLS_ENABLE(e.a(Boolean.class).a((Boolean)true).c(true).b("boolean to enable/disable regex security control analysis for performance reasons").a(Category.PERFORMANCE).b(d.a("assess.regex_security_controls_enable")).h()),
    ASSESS_DETECT_CANARIES(e.a(String.class).a("contrast.assess.secondorder.canary").c().b("A value that will be fed by attack testing tools in order to test stored XSS or other second-order injection attacks to be detected coming out of databases").a(Category.DIAGNOSTICS).b(d.a("assess.second_order_canary")).h()),
    ASSESS_THRESHOLD_ENTRIES(e.a(Integer.class).a(100).b("The maximum number of vulnerabilities per rule type that can be discovered within a period defined by contrast.assess.threshold.period").a(Category.PERFORMANCE).b(d.a("assess.threshold.entries")).h()),
    ASSESS_THRESHOLD_PERIOD_MS(e.a(Integer.class).a((Integer)((Object)"contrast.assess.threshold.period.ms")).a(60000).b("The period, in milliseconds, in which a maximum number of vulnerabilities per rule type can be discovered").a(Category.PERFORMANCE).b(d.a("assess.threshold.period_ms")).h()),
    LIBRARY_UPDATE_QUEUE_SIZE(e.a(Integer.class).a((Integer)((Object)"contrast.agent.reporting.library_update.queue.size")).a(20000).b("size of queue that holds library update events that are intended to be sent to TeamServer").a(Category.GENERAL_PROPERTIES).b(d.a("agent.reporting.library_update.observations.queue.size")).h()),
    ENABLE_REPORTING_COMBINED_SERVER_APP_STARTUP(e.a(Boolean.class).e().a((Boolean)false).b("Enables reporting both server and app startup to a single endpoint. If false, the agent will report server startup and app startup to 2 separate legacy endpoints.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.reporting.enable_combined_server_app_startup")).a(serverSettingsDTM -> serverSettingsDTM != null && serverSettingsDTM.getTeamServerDateVersion() >= 20240703).h()),
    TEAMSERVER_REPORTING_MAX_RETRY(e.a(Integer.class).c(true).a(3).b("Set the number of times the to retry recoverable network and HTTP failures when communicating with Contrast UI.").a(Category.GENERAL_PROPERTIES).b(d.a("api.max_retries")).h()),
    TEAMSERVER_REPORTING_RETRY_INTERVAL(e.a(Integer.class).c(true).a(1000).b("Set the interval (in milliseconds) the agent will wait before retrying a recoverable network or HTTP failure when communicating with Contrast UI.").a(Category.GENERAL_PROPERTIES).b(d.a("api.retry_interval")).h()),
    REPORTING_THREAD_GRACE_PERIOD_MS(e.a(Long.class).a(120000L).b("Set the grace period (in milliseconds) after agent shutdown to allow draining pending reports.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.reporting.shutdown_grace_period_ms")).h()),
    REPORTING_THREAD_POOL_SIZE(e.a(Integer.class).c(true).a(1).b("Set size of reporting service's thread pool. More threads may increase reporting throughput at the expense of increased contention for CPU resources.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.reporting.thread_pool_size")).h()),
    ROUTE_OBSERVATION_QUEUE_SIZE(e.a(Integer.class).a((Integer)((Object)"contrast.agent.reporting.route_coverage.queue.size")).a(3000).b("size of queue that holds route observation events that are intended to be sent to TeamServer").a(Category.GENERAL_PROPERTIES).b(d.a("agent.reporting.route_coverage.observations.queue.size")).h()),
    ROUTE_OBSERVATION_MAP_DEDUPLICATION_SIZE(e.a(Integer.class).c(true).a(1024).b("size of map that holds route observation events to check for duplicates in a given time window before being sent to TeamServer").a(Category.GENERAL_PROPERTIES).b(d.a("agent.reporting.route_coverage.observations.dedup.map.size")).h()),
    ROUTE_OBSERVATION_DEDUPLICATION_TIME(e.a(Long.class).c(true).a(60000L).b("The time window (in milliseconds) of a route being observed more than once to be considered a duplicate and not reported to team server. If <= 0, no duplicate check will occur").a(Category.GENERAL_PROPERTIES).b(d.a("agent.reporting.route_coverage.observations.dedup.window.time")).h()),
    ROUTE_OBSERVATION_MIDDLEWARE_ENABLED(e.a(Boolean.class).e().a((Boolean)false).b("Boolean as to whether Route Observation should run for middleware").a(Category.GENERAL_PROPERTIES).b(d.a("agent.reporting.route_coverage.observation.middleware")).a(serverSettingsDTM -> serverSettingsDTM != null && serverSettingsDTM.getTeamServerDateVersion() >= 20241009).h()),
    ROUTE_OBSERVATION_MIDDLEWARE_REPORTING_ENABLED(e.a(Boolean.class).e().a((Boolean)false).b("Boolean as to whether Routes Observed for middleware are reported to TS").a(Category.GENERAL_PROPERTIES).b(d.a("agent.reporting.route_coverage.observation.middleware.send")).h()),
    ROUTE_DISCOVERY_MIDDLEWARE_ENABLED(e.a(Boolean.class).e().a((Boolean)((Object)"contrast.agent.reporting.route_coverage.filters")).a((Boolean)false).b("Boolean as to whether Route Discovery should run for middleware").a(Category.GENERAL_PROPERTIES).b(d.a("agent.reporting.route_coverage.discovery.middleware")).h()),
    SILENT_TELEMETRY_QUEUE_SIZE(e.a(Integer.class).a((Integer)((Object)"contrast.agent.reporting.silent_telemetry.queue.size")).a(3000).e().b("size of queue that holds silent telemetry events that are intended to be sent to TeamServer").a(Category.GENERAL_PROPERTIES).b(d.a("agent.reporting.silent_telemetry.observations.queue.size")).h()),
    APP_INVENTORY_QUEUE_SIZE(e.a(Integer.class).a((Integer)((Object)"contrast.agent.reporting.app_inventory.queue.size")).a(300).b("size of queue that holds app inventory events that are intended to be sent to TeamServer").a(Category.GENERAL_PROPERTIES).b(d.a("agent.reporting.app_inventory.observations.queue.size")).h()),
    SERVER_INVENTORY_QUEUE_SIZE(e.a(Integer.class).a(10).b("size of queue that holds server inventory events that are intended to be sent to TeamServer").a(Category.GENERAL_PROPERTIES).b(d.a("agent.reporting.server_inventory.observations.queue.size")).h()),
    EFFECTIVE_CONFIG_QUEUE_SIZE(e.a(Integer.class).a(100).e().b("size of queue that holds effective config reports that are intended to be sent to TeamServer").a(Category.GENERAL_PROPERTIES).b(d.a("agent.reporting.effective_config.observations.queue.size")).h()),
    ARCHITECTURE_COMPONENT_QUEUE_SIZE(e.a(Integer.class).a(300).b("size of queue that holds app architecture component events that are intended to be sent to TeamServer").a(Category.GENERAL_PROPERTIES).b(d.a("agent.reporting.architecture_component.observations.queue.size")).h()),
    CLASS_EVENT_QUEUE_SIZE(e.a(Integer.class).a(1024).e().b("size of queue that holds class load events prior to being processed. Must be a power of 2.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.class_load_event.queue_size")).h()),
    SMAP_QUEUE_SIZE(e.a(Integer.class).a(1024).e().b("size of queue that holds SMAP data prior to being processed. Must be a power of 2.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.smap.queue_size")).h()),
    LEGACY_REPORTING_PERIOD(e.a(Long.class).a((Long)((Object)"contrast.reporting.period")).a(5000L).b("Set the polling period for spooling reports.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.polling.reporting_period_ms")).h()),
    REPORTING_PERIOD(e.a(Integer.class).a(500).e().b("Specifies period between sending single report to TeamServer through the agent reporting service.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.reporting.period")).h()),
    DUP_DELAY(e.a(Long.class).a((Long)((Object)"contrast.duplicate.delay")).a(5000L).b("The period for which duplicate traces, based on Contrast hashing methods, will be supressed (in milliseconds)").a(Category.GENERAL_PROPERTIES).b(d.a("assess.duplicate_delay_ms")).h()),
    CSRF_IDEMPOTENT_URLS(e.a(String.class).c().b("Set the path to a file containing line-separated URLs patterns which don't require CSRF tokens").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.csrf_exempt_urls_file")).h()),
    CSRF_PROTECTED_URLS(e.a(String.class).c().b("Set the path to a file containing line-separated URLs patterns which require CSRF tokens").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.csrf_protected_urls_file")).h()),
    SCAN_CODE_SOURCES(e.a(Boolean.class).a((Boolean)((Object)"contrast.process.codesources")).a((Boolean)true).e().b("By default, the Java agent will visit all classes at startup to look for vulnerabilities which may be detected by scanning a class (for example, hardcoded passwords). Set this property to `false` to disable the default behavior so that the agent will instead only visit classes which are likely to require sensors. This can improve application startup time, but may produce less findings (most likely those which require static analysis).").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.scan_all_code_sources")).h()),
    INSPECT_ALL_CLASSES(e.a(Boolean.class).a((Boolean)((Object)"contrast.inspect.allclasses")).a((Boolean)true).e().b("By default, the Java agent will deeply inspect all jar and war files loaded by the JVM in order to build a comprehensive understanding of the type hierarchy. Building this comprehensive understanding allows Contrast to instrument sensors into types that it might otherwise overlook. In most cases this produces a slight increase in accuracy at the cost of increased application startup time. Customers can disable this scanning by setting this property to `false`.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.scan_all_classes")).h()),
    HIERARCHY_OVERRIDE(e.a(String.class).a("contrast.hierarchy.path").c().e().b("A path on disk where additional hierarchy information can be found (as XML)").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.hierarchy_file")).h()),
    PACKAGES_TO_SCAN(e.a(String.class).a("contrast.user.packages").c().e().b("A comma-separated list of packages that Contrast should deeply scan for SMAP information, vulnerabilities, and other app-related analysis").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.user_packages")).h()),
    PREFLIGHT_FAIL_OPEN(e.a(Boolean.class).a((Boolean)((Object)"contrast.preflight.open")).a((Boolean)false).b("boolean to enable/disable preflight reporting fail open. In this case, fail open means that in the event of an error during a preflight check, all reports will be sent to TeamServer. Typically, the Contrast Agent uses a preflight hashing mechanism to avoid duplicate reporting, reducing load on TeamServer. Occasionally, this process can be overwhelmed, and TeamServer cannot reply quickly enough. In this case, in order to avoid losing any vulnerability data, the Agent will send any reports that are being filtered by preflight. While TeamServer can usually recover and resume preflight, it sometimes falls behind (for instance if the application being monitored is placed under a load test). To ensure that TeamServer has a chance to catch up, you can set this flag to false; however, it is worth noting that doing so may result in lost vulnerability information as all reports will be disregarded.").a(Category.PERFORMANCE).b(d.a("agent.java.enable_preflight_fail_open")).h()),
    INSPECT_PARAMETERS_AS_XML(e.a(Boolean.class).a((Boolean)((Object)"contrast.defend.parameters.xml")).a((Boolean)false).e().b("boolean to enable/disable XML scanning inside of individual parameters").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.enable_xml_parameter_inspection")).h()),
    INSPECT_PARAMETERS_AS_JSON(e.a(Boolean.class).a((Boolean)((Object)"contrast.defend.parameters.json")).a((Boolean)false).e().b("boolean to enable/disable JSON scanning inside of individual parameters").a(Category.PROTECT_MODE_CONFIG).b(d.a("protect.enable_json_parameter_inspection")).h()),
    DELAYED_STARTUP(e.a(Integer.class).a((Integer)((Object)"contrast.startup.delay")).a(0).e().b("this is the number of milliseconds to delay startup of the agent, if 0 or less, no startup delay").a(Category.PERFORMANCE).b(d.a("agent.startup_delay_ms")).h()),
    DELAYED_STARTUP_STRATEGY(e.a(String.class).a("contrast.startup.strategy").a("activation").e().b("can be 'activation' or 'boot'; when doing delayed startup, what strategy should be used.  For `activation` booting and instrumentation do take place but the sensors are only enabled later.  For `boot` very little action is taken at agent startup, the agent booting and instrumentation occur later after the delay period.").a(Category.PERFORMANCE).b(d.a("agent.java.delayed_startup_strategy")).h()),
    DELAYED_C2_COMPILATION(e.a(BooleanOrDefault.class).a(BooleanOrDefault.DEFAULT).e().b("Delay JVM C2 compilation until after the first request (on JVM 9+). This can speed up startup in CPU constrained environments.").a(Category.PERFORMANCE).b(d.a("agent.java.delayed_c2_compilation")).h()),
    DELAYED_C2_COMPILATION_TIMEOUT_MS(e.a(Long.class).a(900000L).e().b("Timeout after which C2 compilation will be re-enabled (if it is not re-enabled after the first request).").a(Category.PERFORMANCE).b(d.a("agent.java.delayed_c2_compilation_timeout_ms")).h()),
    ALLOW_INSTRUCTION_CACHE(e.a(Boolean.class).a((Boolean)((Object)"contrast.instrcache.allow")).a((Boolean)true).e().b("whether instruction caching is allowed").a(Category.INTERNAL_USAGE).b(d.a("agent.java.allow_instruction_caching")).h()),
    SERVER_ENVIRONMENT(e.a(com.contrastsecurity.agent.t.b.class).a((com.contrastsecurity.agent.t.b)((Object)"contrast.env")).a(com.contrastsecurity.agent.t.b.a).b("the name of the environment this server should be associated with in the TeamServer").a(Category.GENERAL_PROPERTIES).b(d.a("server.environment")).a(serverSettingsDTM -> {
        if (serverSettingsDTM == null) {
            return com.contrastsecurity.agent.t.b.a;
        }
        com.contrastsecurity.agent.t.b b2 = serverSettingsDTM.getEnvironment();
        return b2 != null ? b2 : com.contrastsecurity.agent.t.b.a;
    }).h()),
    DISCOVER_CLOUD_RESOURCE_ID(e.a(Boolean.class).a((Boolean)true).b("Set to false to disable detection of cloud provider metadata such as resource identifiers.").a(Category.GENERAL_PROPERTIES).b(d.a("server.discover_cloud_resource")).h()),
    GROUP(e.a(String.class).a("contrast.group").c().b("the name of the application group this application should be associated with in the TeamServer").a(Category.GENERAL_PROPERTIES).b(d.a("application.group", true)).h()),
    APP_CODE(e.a(String.class).c().b("the 'application code' for the application to be used in TeamServer").a(Category.GENERAL_PROPERTIES).b(d.a("application.code", true)).h()),
    FREEZE_THRESHOLD(e.a(Integer.class).a((Integer)((Object)"contrast.freeze.threshold")).a(140).e().b("Number of summarized events in a trace before trace is frozen").a(Category.PERFORMANCE).b(d.a("agent.java.trace_summary.freeze_threshold")).h()),
    SUMMARIZATION_THRESHOLD(e.a(Integer.class).a((Integer)((Object)"contrast.summarization.threshold")).a(100).e().b("Number of events in a trace before summarization kicks in").a(Category.PERFORMANCE).b(d.a("agent.java.trace_summary.threshold")).h()),
    SUMMARIZATION_LEADING_EVENTS(e.a(Integer.class).a((Integer)((Object)"contrast.summarization.leading.events")).a(10).e().b("Number of leading events to preserve when summarizing a trace").a(Category.PERFORMANCE).b(d.a("agent.java.trace_summary.leading_events")).h()),
    SUMMARIZATION_TRAILING_EVENTS(e.a(Integer.class).a((Integer)((Object)"contrast.summarization.trailing.events")).a(10).e().b("Minimum number of trailing events to preserve when summarizing a trace").a(Category.PERFORMANCE).b(d.a("agent.java.trace_summary.trailing_events")).h()),
    USER_NAME(e.a(String.class).a("contrast.user.name").c().b("Overrides the Contrast user name.").a(Category.GENERAL_PROPERTIES).b(d.a("api.user_name", Lists.of("contrast.user_name"))).h()),
    API_KEY(e.a(String.class).a("contrast.api.key").c().b("Overrides the Contrast api key.").a(Category.GENERAL_PROPERTIES).f().b(d.a("api.api_key", Lists.of("contrast.api_key"))).h()),
    SERVICE_KEY(e.a(String.class).a("contrast.service.key").c().b("Overrides the Contrast service key.").a(Category.GENERAL_PROPERTIES).f().b(d.a("api.service_key", Lists.of("contrast.service_key"))).h()),
    TOKEN(e.a(String.class).c().b("Overrides the Contrast token, which is parsed out into individual config properties").a(Category.GENERAL_PROPERTIES).f().b(d.a("api.token")).h()),
    VM_ID(e.a(String.class).a("contrast.vm.id").a("Java").e().b("Override the reported VM").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.vm_id")).h()),
    APPLICATION_PATH(e.a(String.class).c().b("Overrides the detected context path (location) of the application. This affects the \"Application-Path\" header value when sending reports. Overriding this could cause reports to be thrown away.").a(Category.GENERAL_PROPERTIES).b(d.a("application.path")).h()),
    ENABLE_TRANSFORM_PRIMORDIAL_TASK(e.a(Boolean.class).a((Boolean)true).e().b("Used for testing purposes, in cases that require a faked ContrastEngine to be started to mimic agent startup (e.g., needing access to the generated dispatcher instances). Overriding this property forces an early return in ContrastEngine startup tasks (TransformPrimordialTask & AddTransformerTask) to avoid errors caused by the faked ContrastEngine.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.enable_transform_primordial")).h()),
    TRANSFORM_PRIMORDIAL_BATCH_SIZE(e.a(Integer.class).a(-1).e().b("Configures the batch size to use for primordial transformations. Larger batches will consume more CPU and start the agent faster while smaller batches will consume less CPU and start the agent slower. Defaults to Integer.MAX_VALUE. Currently the only supported batch sizes are 1 and Integer.MAX_VALUE.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.transform_primordial_batch_size")).h()),
    STRICT_STARTUP(e.a(Boolean.class).a((Boolean)((Object)"contrast.agent.java.strict.startup")).a((Boolean)false).e().b("Prevent the application from starting if Contrast fails to start. Use with caution.").a(Category.INTERNAL_USAGE).d("The YAML property cannot be used since this property is obtained before the Config object is created. This property can only be set as a system property: -Dcontrast.agent.java.strict.startup").h()),
    INVENTORY_CACHE_LIBRARY_FACTS(e.a(Boolean.class).a((Boolean)((Object)"contrast.inventory.cache.library.facts")).a((Boolean)true).b("Controls caching of basic information gathered from detected libraries.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.cache_library_facts")).h()),
    INVENTORY_MAX_JAR_SIZE_TO_BUFFER_IN_MEM(e.a(Integer.class).a(0x3200000).b("Controls the maximum size of the in memory buffer for parsing jar contents in bytes. Min size supported is 512KB").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.inventory.jar_mem_buffer_size")).e().h()),
    ROUTE_COVERAGE(e.a(Boolean.class).a((Boolean)true).b("Toggle the route based coverage feature").a(Category.GENERAL_PROPERTIES).b(d.a("agent.route_coverage.enable")).h()),
    INVENTORY_DENYLIST(e.a(String.class).c().e().b("List of JAR, EAR, or WAR file names to skip during library scanning").a(Category.GENERAL_PROPERTIES).b(d.a("inventory.blacklist")).h()),
    ENABLE_INTEGRATION_TEST_SERVICES(e.a(Boolean.class).a((Boolean)false).e().b("Enables the agent's integration test services which expose certain features in tests via IntegrationTestServices.").a(Category.GENERAL_PROPERTIES).b(d.a("agent.java.enable_integration_test_services")).h()),
    ENABLE_RELOADABLE_BEANS(e.a(Boolean.class).a((Boolean)((Object)"contrast.agent.java.enable_reloadable_beans")).a((Boolean)false).e().b("Set to true to enable functionality in the com.contrastsecurity.agent.reloadable package. This is only needed for our legacy integration tests").a(Category.GENERAL_PROPERTIES).d("This should be removed along with the integration tests").h()),
    ENABLE_AGENT_CHANNEL_HUB(e.a(Boolean.class).a((Boolean)((Object)"contrast.agent.java.agent_channel_hub")).a((Boolean)false).e().b("Set to true to register the AgentChannelHub. This is only needed for our legacy integration tests").a(Category.INTERNAL_USAGE).d("This should be removed along with the integration tests").h()),
    SILENT_TELEMETRY_ENABLE(e.a(Boolean.class).a((Boolean)false).e().b("Toggle the diagnostics telemetry feature").a(Category.GENERAL_PROPERTIES).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getTelemetry() != null) {
            return serverSettingsDTM.getTelemetry().getEnable();
        }
        return null;
    }).b(d.a("agent.silent_telemetry.enable")).h()),
    MAX_REQUEST_BODY_ASSESS_SIZE(e.a(Integer.class).a(4096).e().b("Assess maximum request body size to buffer").a(Category.PERFORMANCE).b(d.a("assess.max_request_bytes_buffer")).h()),
    MAX_REQUEST_BODY_ANALYSIS_SIZE(e.a(Integer.class).a(Integer.MAX_VALUE).e().b("Maximum number of request body bytes that will be captured for analysis. Note that individual plugins may specify lower values for this property than the default.").a(Category.PERFORMANCE).b(d.a("agent.java.max_request_body_bytes_captured")).h()),
    MAX_RESPONSE_BODY_SIZE(e.a(Integer.class).a(524288).e().b("The maximum number of bytes of the HTTP response that will be captured for analysis.  A value of 0 will disable capturing the response").a(Category.PERFORMANCE).b(d.a("agent.java.max_response_body_bytes_captured")).h()),
    MAX_CONTEXT_SNAPSHOT_CACHE_SIZE(e.a(Integer.class).a((Integer)((Object)"contrast.assess.context.max.snapshots")).a(100).e().b("the maximum number of cached method object snapshots per context").a(Category.PERFORMANCE).b(d.a("assess.max_cached_context_snapshots")).h()),
    MAX_SNAPSHOT_TOSTRING_LENGTH(e.a(Integer.class).a(10000).e().b("Maximum length a String snapshot can be in SnapshotFactory. Object's with toString implementations that produce longer Strings than this max will be denylisted and their class name used instead.").a(Category.PERFORMANCE).b(d.a("assess.max_snapshot_tostring_length")).h()),
    CMD_INJECTION_V2_ENABLE(e.a(Boolean.class).a((Boolean)false).e().b("Enable/disable path traversal using the Brics regex engine, see also alternative global setting: PROTECT_PATTERN_EVALUATION_V2_ENABLE").a(Category.RULES_CONFIG).b(d.a("protect.cmd_injection.engine_v2")).h()),
    PATH_TRAVERSAL_V2_ENABLE(e.a(Boolean.class).a((Boolean)false).e().b("Enable/disable path traversal using the Brics regex engine, see also alternative global setting: PROTECT_PATTERN_EVALUATION_V2_ENABLE").a(Category.RULES_CONFIG).b(d.a("protect.path_traversal.engine_v2")).h()),
    SQL_INJECTION_V2_ENABLE(e.a(Boolean.class).a((Boolean)false).e().b("Enable/disable SQLi using the Brics regex engine, see also alternative global setting: PROTECT_PATTERN_EVALUATION_V2_ENABLE").a(Category.RULES_CONFIG).b(d.a("protect.sql_injection.engine_v2")).h()),
    SQL_INJECTION_PATTERNS_V2_ENABLE(e.a(Boolean.class).a((Boolean)false).e().b("Set to true to use the v2 patterns for SQLi").a(Category.INTERNAL_USAGE).b(d.a("protect.sql_injection.v2_patterns.enable")).h()),
    UNSAFE_FILE_UPLOAD_V2_ENABLE(e.a(Boolean.class).a((Boolean)false).e().b("Enable/disable UnsafeFileUpload using the Brics regex engine, see also alternative global setting: PROTECT_PATTERN_EVALUATION_V2_ENABLE").a(Category.INTERNAL_USAGE).b(d.a("protect.unsafe_file_upload.engine_v2")).h()),
    XSS_V2_ENABLE(e.a(Boolean.class).a((Boolean)false).e().b("Enable/disable SQLi using the Brics regex engine, see also alternative global setting: PROTECT_PATTERN_EVALUATION_V2_ENABLE").a(Category.RULES_CONFIG).b(d.a("protect.xss.engine_v2")).h()),
    SMTP_INJECTION_SAFE_TAGS(e.a(String.class).a("smtp-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    SSRF_SAFE_TAGS(e.a(String.class).a("ssrf.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    UNSAFE_XML_DECODE_SAFE_TAGS(e.a(String.class).a("unsafe-xml-decode.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    HARDCODED_PASSWORD_SAFE_TAGS(e.a(String.class).a("hardcoded-password.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    HARDCODED_KEY_SAFE_TAGS(e.a(String.class).a("hardcoded-key.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    SPRING_UNCHECKED_AUTOBINDING_SAFE_TAGS(e.a(String.class).a("spring-unchecked-autobinding.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    SCALA_PLAY_UNCHECKED_AUTOBINDING_SAFE_TAGS(e.a(String.class).a("scala-play-unchecked-autobinding.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    XXE_SAFE_TAGS(e.a(String.class).a("xxe.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    INSECURE_AUTH_PROTOCOL_SAFE_TAGS(e.a(String.class).a("insecure-auth-protocol.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    CLICKJACKING_CONTROL_MISSING_SAFE_TAGS(e.a(String.class).a("clickjacking-control-missing.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    SESSION_REWRITING_SAFE_TAGS(e.a(String.class).a("session-rewriting.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    PARAMETER_POLLUTION_SAFE_TAGS(e.a(String.class).a("parameter-pollution.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    CACHE_CONTROLS_MISSING_SAFE_TAGS(e.a(String.class).a("cache-controls-missing.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    AUTOCOMPLETE_MISSING_SAFE_TAGS(e.a(String.class).a("autocomplete-missing.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    CSRF_SAFE_TAGS(e.a(String.class).a("csrf.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    INSECURE_JSP_ACCESS_SAFE_TAGS(e.a(String.class).a("insecure-jsp-access.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    SESSION_TIMEOUT_SAFE_TAGS(e.a(String.class).a("session-timeout.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    VERB_TAMPERING_SAFE_TAGS(e.a(String.class).a("verb-tampering.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    OVERLY_PERMISSIVE_CROSS_DOMAIN_POLICY_SAFE_TAGS(e.a(String.class).a("overly-permissive-cross-domain-policy.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    CMD_INJECTION_SAFE_TAGS(e.a(String.class).a("cmd-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    COOKIE_FLAGS_MISSING_SAFE_TAGS(e.a(String.class).a("cookie-flags-missing.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    CRYPTO_BAD_CIPHERS_SAFE_TAGS(e.a(String.class).a("crypto-bad-ciphers.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    CRYPTO_BAD_MAC_SAFE_TAGS(e.a(String.class).a("crypto-bad-mac.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    CRYPTO_WEAK_RANDOMNESS_SAFE_TAGS(e.a(String.class).a("crypto-weak-randomness.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    EXPRESSION_LANGUAGE_INJECTION_SAFE_TAGS(e.a(String.class).a("expression-language-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    HTTPONLY_SAFE_TAGS(e.a(String.class).a("httponly.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    LDAP_INJECTION_SAFE_TAGS(e.a(String.class).a("ldap-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    LOG_INJECTION_SAFE_TAGS(e.a(String.class).a("log-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    PATH_TRAVERSAL_SAFE_TAGS(e.a(String.class).a("path-traversal.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    REFLECTED_XSS_SAFE_TAGS(e.a(String.class).a("reflected-xss.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    REFLECTION_INJECTION_SAFE_TAGS(e.a(String.class).a("reflection-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    HQL_INJECTION_SAFE_TAGS(e.a(String.class).a("hql-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    NOSQL_INJECTION_SAFE_TAGS(e.a(String.class).a("nosql-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    NOSQL_INJECTION_DYNAMODB_SAFE_TAGS(e.a(String.class).a("nosql-injection-dynamodb.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    SQL_INJECTION_SAFE_TAGS(e.a(String.class).a("sql-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    TRUST_BOUNDARY_VIOLATION_SAFE_TAGS(e.a(String.class).a("trust-boundary-violation.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    TOMCAT_CONTEXT_CONFIG_WORKAROUND(e.a(Boolean.class).a((Boolean)true).e().b("boolean to enable/disable the Tomcat ContextConfig workaround for Contrast classes").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_tomcat_context_config_workaround")).h()),
    UNSAFE_READLINE_SAFE_TAGS(e.a(String.class).a("unsafe-readline.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    UNVALIDATED_FORWARD_SAFE_TAGS(e.a(String.class).a("unvalidated-forward.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    UNVALIDATED_REDIRECT_SAFE_TAGS(e.a(String.class).a("unvalidated-redirect.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    XPATH_INJECTION_SAFE_TAGS(e.a(String.class).a("xpath-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    HEADER_INJECTION_SAFE_TAGS(e.a(String.class).a("header-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    UNTRUSTED_DESERIALIZATION_SAFE_TAGS(e.a(String.class).a("untrusted-deserialization.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    HSTS_HEADER_MISSING_SAFE_TAGS(e.a(String.class).a("hsts-header-missing.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    XCONTENTTYPE_HEADER_MISSING_SAFE_TAGS(e.a(String.class).a("xcontenttype-header-missing.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    XXSSPROTECTION_HEADER_DISABLED_SAFE_TAGS(e.a(String.class).a("xxssprotection-header-disabled.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    CSP_HEADER_MISSING_SAFE_TAGS(e.a(String.class).a("csp-header-missing.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    CSP_HEADER_INSECURE_SAFE_TAGS(e.a(String.class).a("csp-header-insecure.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    REDOS_SAFE_TAGS(e.a(String.class).a("redos.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).e().d("Safe-tags are not supported by the Common Config spec").h()),
    NONEXISTENT_CONFIG_PROPERTY(e.a(String.class).a("config.does-not-exist").c().b("A nonexistent config property that will always return null").a(Category.INTERNAL_USAGE).e().d("Test properties cannot be set via YAML").h()),
    TEST_CONFIG_STRING_PROPERTY(e.a(String.class).a("config.test.string").a("foo").b("Test config property used in unit tests for the Config or ConfigProviders").a(Category.INTERNAL_USAGE).e().d("Test properties cannot be set via YAML").h()),
    TEST_CONFIG_INT_PROPERTY(e.a(Integer.class).a((Integer)((Object)"config.test.int")).a(420).b("Test config property used in unit tests for the Config or ConfigProviders").a(Category.INTERNAL_USAGE).e().d("Test properties cannot be set via YAML").h()),
    TEST_CONFIG_BOOLEAN_PROPERTY(e.a(Boolean.class).a((Boolean)((Object)"config.test.boolean")).a((Boolean)false).b("Test config property used in unit tests for the Config or ConfigProviders").a(Category.INTERNAL_USAGE).e().d("Test properties cannot be set via YAML").h()),
    TEST_CONFIG_ENUM_PROPERTY(e.a(LogLevel.class).a((LogLevel)((Object)"config.test.enum")).a(LogLevel.INFO).b("Test config property used in unit tests for the Config or ConfigProviders").a(Category.INTERNAL_USAGE).e().d("Test properties cannot be set via YAML").h()),
    PROTECT_FAKE_RULE_MODE(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.fake-rule.mode")).c().b("Test property for enabling ProtectRule").a(Category.INTERNAL_USAGE).e().d("Test properties cannot be set via YAML").h()),
    FAKE_RULE_MODE_ENABLED(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"enabled-fake-rule")).c().b("Test property for enabling ProtectRule").a(Category.INTERNAL_USAGE).e().d("Test properties cannot be set via YAML").h()),
    FAKE_RULE_MODE_DISABLED(e.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"disabled-fake-rule")).c().b("Test property for disabling ProtectRule").a(Category.INTERNAL_USAGE).e().d("Test properties cannot be set via YAML").h()),
    FAKE_FEATURES_CONFIGURABLE_STRING_PROPERTY(e.a(String.class).a("test-key").c().a(serverSettingsDTM -> "foo").a(Category.INTERNAL_USAGE).e().d("Test properties cannot be set via YAML").h()),
    FAKE_FEATURES_CONFIGURABLE_INT_PROPERTY(e.a(Integer.class).a((Integer)((Object)"test-key-int")).a(17).a(serverSettingsDTM -> 42).a(Category.INTERNAL_USAGE).e().d("Test properties cannot be set via YAML").h()),
    FAKE_FEATURES_CONFIGURABLE_LONG_PROPERTY(e.a(Long.class).a((Long)((Object)"test-key-long")).a(100000000000L).a(serverSettingsDTM -> 420L).a(Category.INTERNAL_USAGE).e().d("Test properties cannot be set via YAML").h()),
    FAKE_FEATURES_CONFIGURABLE_BOOLEAN_PROPERTY(e.a(Boolean.class).a((Boolean)((Object)"test-key-bool")).a((Boolean)false).a(serverSettingsDTM -> true).a(Category.INTERNAL_USAGE).e().d("Test properties cannot be set via YAML").h()),
    PROPERTY_OVERRIDE_PATTERN_JSON(e.a(String.class).a("contrast.pattern.json.override").c().a(Category.INTERNAL_USAGE).e().d("Test properties cannot be set via YAML").h()),
    PROPERTY_OVERRIDE_KEYWORD_JSON(e.a(String.class).a("contrast.keyword.json.override").c().a(Category.INTERNAL_USAGE).e().d("Test properties cannot be set via YAML").h()),
    PROPERTY_OVERRIDE_BREAK_ON_THRESHOLD(e.a(Boolean.class).a((Boolean)((Object)"contrast.break.on.threshold")).a((Boolean)true).a(Category.INTERNAL_USAGE).e().d("Test properties cannot be set via YAML").h()),
    AGENT_TELEMETRY_OPT_OUT(e.a(Boolean.class).a((Boolean)false).b("Opt out of the collection of metrics and their submission to the remote endpoint.").a(Category.TELEMETRY).e().b(d.a("agent.telemetry.optout")).h()),
    SUPPORTER_TELEMETRY(e.a(Boolean.class).a((Boolean)true).e().b("boolean to enable/disable support for telemetry").a(Category.FRAMEWORK_SUPPORT).b(d.a("agent.java.enable_telemetry_support")).h()),
    AGENT_TELEMETRY_INITIAL_DELAY(e.a(Long.class).a(TimeUnit.MINUTES.toMillis(2L)).b("Grace period following startup. Metric publishing will not take place until the grace period has elapsed.").a(Category.TELEMETRY).e().b(d.a("agent.telemetry.metrics.initial_delay_ms")).h()),
    AGENT_TELEMETRY_SUBMISSION_CADENCE(e.a(Long.class).a(TimeUnit.HOURS.toMillis(3L)).b("Time between submissions of metric registry contents to remote endpoint in ms.").a(Category.TELEMETRY).e().b(d.a("agent.telemetry.metrics.interval_ms")).h()),
    AGENT_TELEMETRY_SUBMISSION_ENDPOINT(e.a(String.class).a("https://telemetry.java.contrastsecurity.com/api/v1/telemetry/").b("The URL where metrics and errors will be sent at submission.").a(Category.TELEMETRY).e().b(d.a("agent.telemetry.endpoint")).h()),
    AGENT_TELEMETRY_SUBMISSION_TIMEOUT(e.a(Integer.class).a(30000).b("The connect timeout for submitting to Telemetry.").a(Category.TELEMETRY).e().b(d.a("agent.telemetry.connect_timeout_ms")).h()),
    AGENT_TELEMETRY_USE_AUTH(e.a(Boolean.class).a((Boolean)false).b("Whether to use authentication headers Authorization and API-Key for the Telemetry client.").a(Category.TELEMETRY).e().b(d.a("agent.telemetry.use_auth")).h()),
    AGENT_TELEMETRY_CUSTOM_TAGS(e.a(String.class).c().b("Allows specific tags to be set for Telemetry. Two tags can be set using this value separated by a comma. Commas are not allowed as tag values. Any leading or trailing whitespace will be trimmed for each tag value. The first tag will be named 'customTag1' and the second 'customTag2'.").a(Category.TELEMETRY).e().b(d.a("agent.telemetry.tags")).h()),
    AGENT_TELEMETRY_INITIALIZE_BUCKETS(e.a(String.class).c().b("Comma separated list of telemetry metric names for distributions with buckets whose columns must be initialized on the Telemetry backend in order for the front-end to render the charts.").a(Category.TELEMETRY).e().b(d.a("agent.java.telemetry.initialize_buckets")).h()),
    APPMGR_JARANALYZER_TTL(e.a(Long.class).a((Long)((Object)"contrast.agent.appmgr.jaranalyzer.ttl")).a(TimeUnit.MINUTES.toMillis(10L)).b("TTL for JarAnalyzer in ApplicationManager in milliseconds, default 10 minutes").a(Category.PERFORMANCE).e().d("Agent-only config").h()),
    TELEMETRY_ERROR_MAX_RETAINED_IN_MEM_BYTES(e.a(Long.class).a(0x600000L).b("The max size in bytes allowed to be stored in memory before error submissions. This is a best-effort setting and the size in some JVMs may be larger than this value.").a(Category.TELEMETRY).e().b(d.a("agent.telemetry.errors.max_retained_bytes")).h()),
    TELEMETRY_ERROR_MAX_QUEUE_SIZE(e.a(Integer.class).a(32).b("The max number of Throwables to emit for Agent Telemetry Error Reporting.").a(Category.TELEMETRY).e().b(d.a("agent.telemetry.errors.max_queue_size")).h()),
    PROTECT_PATTERN_EVALUATION_V2_ENABLE(e.a(Boolean.class).a((Boolean)true).b("Whether the agent should use its v2 Protect pattern evaluation").a(Category.INTERNAL_USAGE).e().b(d.a("agent.java.protect_pattern_evaluation_engine_v2")).h()),
    PROTECT_BODY_IOUTILS_NOOP(e.a(Boolean.class).a((Boolean)false).b("Whether the agent should match the behaviour prior to JAVA-8558 and skip the body for IOUtils to... methods handling").a(Category.GENERAL_PROPERTIES).e().b(d.a("agent.java.protect_ioutils_skip")).h()),
    INPUT_EXCLUSION_NAME_STRICT_REGEX(e.a(Boolean.class).a((Boolean)false).b("When false, enables simple string matching of input names as a fallback for exclusions specifying an invalid input name matching pattern.  Exclusion input name matching allows a small subset of regex, including just \".\", \"\\.\", \".*\" \".+\" and \".?\".  See https://docs.contrastsecurity.com/en/add-exclusions.html for details.  The default value, false, is intended to allow a gradual migration away from legacy exclusions defined for simpler string pattern matching. ").a(Category.GENERAL_PROPERTIES).e().b(d.a("agent.java.input_exclusion_name_nonregex_match")).h()),
    PROCESS_DENYLIST_OVERRIDE(e.a(Boolean.class).a((Boolean)false).b("Whether to override the process denylist and allow all processes to be instrumented.").a(Category.INTERNAL_USAGE).e().d("agent.java.process_denylist_override").a((Boolean)((Object)"agent.java.process_denylist_override")).h());

    public static final int INT_PROPERTY_NOT_SET = -1;
    public static final boolean SUPPORTER_CLASSLOADER_DEFAULT = true;
    public static final int DEFAULT_TEAMSERVER_TIMEOUT_MS = 10000;
    public static final long DEFAULT_BACKOFF_FACTOR_MS = 1000L;
    public static final long DEFAULT_MAX_TOTAL_BACKOFF_MS = 60000L;
    public static final int DEFAULT_CLASS_EVENT_QUEUE_SIZE = 1024;
    public static final int DEFAULT_SMAP_QUEUE_SIZE = 1024;
    public static final int DEFAULT_MAX_CONTEXT_SOURCE_EVENTS = 100;
    public static final int DEFAULT_MAX_CONTEXT_PROPAGATION_EVENTS = 250;
    public static final int DEFAULT_GLOBAL_TRACE_MAP_FACTOR = 3;
    public static final int DEFAULT_MAX_RESPONSE_BODY_SIZE = 524288;
    private final e<?> metadata;

    private static DiagnosticsLoggerDTM getDiagnosticsLogger(ServerSettingsDTM serverSettingsDTM) {
        if (serverSettingsDTM == null) {
            return null;
        }
        DiagnosticsDTM diagnosticsDTM = serverSettingsDTM.getDiagnostics();
        if (diagnosticsDTM == null) {
            return null;
        }
        return diagnosticsDTM.getDiagnosticsLogger();
    }

    private ConfigProperty(e<?> e2) {
        this.metadata = Objects.requireNonNull(e2);
    }

    public boolean isHidden() {
        return this.metadata.i();
    }

    public String legacySystemPropertyName() {
        return this.metadata.b();
    }

    public Class<?> type() {
        return this.metadata.a();
    }

    public String description() {
        return this.metadata.c();
    }

    public boolean hasNullDefaultValue() {
        return this.metadata.e();
    }

    public String deprecationAlternative() {
        return this.metadata.p();
    }

    public boolean isDeprecated() {
        return this.metadata.g();
    }

    public Object defaultValue() {
        if (this.hasNullDefaultValue()) {
            return null;
        }
        return this.metadata.d();
    }

    public boolean isAppSpecific() {
        return this.metadata.k();
    }

    public Category category() {
        return this.metadata.h();
    }

    public boolean isCommonConfigExempt() {
        return this.metadata.n() != null;
    }

    public boolean isYamlConfigurable() {
        return this.metadata.q() != null;
    }

    public String commonConfigPathOrNull() {
        return this.metadata.q() != null ? this.metadata.q().a() : null;
    }

    public final String commonConfigSystemPropertyName() {
        d d2 = this.metadata.q();
        if (d2 == null) {
            throw new UnsupportedOperationException("This property does not support common config");
        }
        return "contrast." + d2.a();
    }

    public final String commonConfigEnvVarName() {
        String string = this.canonicalName();
        if (string == null) {
            throw new UnsupportedOperationException("This property does not support common config");
        }
        return ConfigProperty.commonConfigPathToEnvVarName(string);
    }

    public static String commonConfigPathToEnvVarName(String string) {
        return ("CONTRAST__" + StringUtils.join((Object[])StringUtils.split(string, "."), "__")).toUpperCase(Locale.US);
    }

    public final String canonicalName() {
        return this.metadata.q() != null ? this.metadata.q().a() : this.metadata.b();
    }

    public List<String> deprecatedPathsOrEmpty() {
        return this.metadata.q() != null ? this.metadata.q().b() : Collections.emptyList();
    }

    public boolean shouldMask() {
        return this.metadata.j();
    }

    public boolean supportsProfile() {
        if (this.metadata.q() != null) {
            return this.metadata.q().c();
        }
        return false;
    }

    public Object parse(String string, f f2, k k2) {
        try {
            return f2.a(this.type(), string);
        }
        catch (com.contrastsecurity.agent.config.exception.c c2) {
            k2.a(this, c2.getMessage());
            return null;
        }
        catch (com.contrastsecurity.agent.config.exception.a | NumberFormatException illegalArgumentException) {
            throw new ContrastConfigurationException("Value " + string + " for config property " + this.legacySystemPropertyName() + " could not be parsed as a " + this.type().getName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ContrastConfigurationException("Attempted to parse " + this.legacySystemPropertyName() + " as a " + this.type().getName() + " but " + this.type().getName() + " is not a supported configuration property type");
        }
    }

    public static ConfigProperty propertyFromString(String string) {
        Objects.requireNonNull(string);
        for (ConfigProperty configProperty : ConfigProperty.values()) {
            if (!string.equals(configProperty.legacySystemPropertyName())) continue;
            return configProperty;
        }
        return null;
    }

    public static ConfigProperty propertyFromYamlString(String string) {
        for (ConfigProperty configProperty : g.b.a()) {
            Object object;
            String string2 = configProperty.commonConfigPathOrNull();
            if (string2 != null) {
                if (string2.equals(string)) {
                    return configProperty;
                }
                object = "contrast." + string2;
                if (((String)object).equals(string)) {
                    return configProperty;
                }
            }
            object = configProperty.deprecatedPathsOrEmpty();
            Iterator<String> iterator = object.iterator();
            while (iterator.hasNext()) {
                String string3 = iterator.next();
                if (string3.equals(string)) {
                    return configProperty;
                }
                String string4 = "contrast." + string3;
                if (!string4.equals(string)) continue;
                return configProperty;
            }
        }
        return null;
    }

    public c<?> serverSettingsExtractor() {
        return this.metadata.l();
    }

    public boolean isFeatureConfigurable() {
        return this.metadata.l() != null;
    }

    public Object fromServerSettings(ServerSettingsDTM serverSettingsDTM) {
        c<?> c2 = this.serverSettingsExtractor();
        return c2.extract(serverSettingsDTM);
    }

    public a<?> appSettingsExtractorClass() {
        return this.metadata.m();
    }

    public boolean isAppSettingsConfigurable() {
        return this.metadata.m() != null;
    }

    public Object fromAppSettings(ApplicationSettingsDTM applicationSettingsDTM) {
        a<?> a2 = this.appSettingsExtractorClass();
        return a2.extract(applicationSettingsDTM);
    }

    public String toString() {
        return this.canonicalName();
    }

    private static boolean isPositive(Integer n2) {
        return n2 != null && n2 > 0;
    }

    @DontObfuscate
    public static enum Category {
        GENERAL_PROPERTIES,
        LOGGING_ASSESS,
        LOGGING_PROTECT,
        DIAGNOSTICS,
        PERFORMANCE,
        POLICY,
        RULES_CONFIG,
        PROTECT_MODE_CONFIG,
        FRAMEWORK_SUPPORT,
        PROXY_SETTINGS,
        INTERNAL_USAGE,
        SAFE_TAGS,
        TELEMETRY;

    }
}

