/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.context;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationContext;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.config.enums.LogContextSwitch;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.protect.ProtectContext;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.scope.ScopeType;
import com.contrastsecurity.agent.test.integration.IntegrationTestServices;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;

@DontObfuscate
public final class ConcurrencyContext
implements ContrastConcurrencyContext {
    private final long testThreadContextId = IntegrationTestServices.currentThreadContextId();
    private final ContrastContext context;
    private final Clock clock;
    private final long created;
    private final long sourceThreadId;
    private final String sourceThreadName;
    private ConcurrencyContext previousState;
    private boolean shouldClearOnEnd = true;
    private final int samplingScope;
    private static final Logger logger = LoggerFactory.getLogger(ConcurrencyContext.class);

    public ConcurrencyContext(Clock clock, ContrastContext contrastContext) {
        this.clock = clock;
        this.created = clock.now();
        this.context = contrastContext.copy();
        this.samplingScope = contrastContext.scope().value(ScopeType.ASSESS_SAMPLING);
        AssessmentContext assessmentContext = this.context.assessment();
        if (assessmentContext != null) {
            assessmentContext.jumpingContexts();
        }
        Thread thread = Thread.currentThread();
        this.sourceThreadId = thread.getId();
        this.sourceThreadName = thread.getName();
        if (LogContextSwitch.enabled()) {
            logger.debug("Saving app=[{}], HttpContext=[{}], and AssessmentContext=[{}] to ConcurrencyContext=[{}]", contrastContext.application(), contrastContext.http(), assessmentContext, JVMUtils.getSafeToString(this, true));
        }
    }

    public void change(Object object) {
        if (IntegrationTestServices.isEnabled()) {
            IntegrationTestServices.getInstance().threadContextId().set(this.testThreadContextId);
        }
        ContrastContext contrastContext = (ContrastContext)object;
        HttpContext httpContext = contrastContext.http();
        httpContext.setRequest(this.httpRequest());
        httpContext.setResponse(this.httpResponse());
        ApplicationContext applicationContext = contrastContext.application();
        applicationContext.current(this.application());
        contrastContext.assessment(this.assessmentContext());
        contrastContext.protect(this.protectContext());
        contrastContext.observe(this.observeContext());
        contrastContext.scope().set(ScopeType.ASSESS_SAMPLING, this.samplingScope);
    }

    public void saveState(Object object) {
        this.previousState = new ConcurrencyContext(this.clock, (ContrastContext)object);
    }

    public void restoreState(Object object) {
        this.previousState.change(object);
    }

    public long threadContextId() {
        return this.testThreadContextId;
    }

    public long created() {
        return this.created;
    }

    public Application application() {
        return this.context.application().current();
    }

    public HttpRequest httpRequest() {
        return this.context.http().getRequest();
    }

    public HttpResponse httpResponse() {
        return this.context.http().getResponse();
    }

    public AssessmentContext assessmentContext() {
        return this.context.assessment();
    }

    public ProtectContext protectContext() {
        return this.context.protect();
    }

    public RootSpan observeContext() {
        return this.context.observe();
    }

    public long getSourceThreadId() {
        return this.sourceThreadId;
    }

    public String getSourceThreadName() {
        return this.sourceThreadName;
    }

    public boolean shouldClearOnEnd() {
        return this.shouldClearOnEnd;
    }

    public void setShouldClearOnEnd(boolean bl2) {
        this.shouldClearOnEnd = bl2;
    }

    public void clearState() {
        this.context.clear();
    }

    public Object currentContext() {
        return ContrastContext.current();
    }

    public String deployableContextSummary() {
        return this.context.toSummaryString();
    }

    public String toString() {
        return "ConcurrencyContext{created=" + this.created + ", application=" + this.application() + ", httpRequest=" + this.httpRequest() + ", httpResponse=" + this.httpResponse() + ", assessmentContext=" + this.assessmentContext() + ", protectContext=" + this.protectContext() + ", sourceThreadId=" + this.sourceThreadId + ", sourceThreadName='" + this.sourceThreadName + '\'' + '}';
    }
}

