/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.finding.trace;

import java.util.Objects;

public class StackDTM {
    private final String signature;
    private final String method;
    private final String file;
    private final int lineNumber;
    private final String type;
    private final String eval;

    public static StackDTM of(StackTraceElement stackTraceElement) {
        return new StackDTM(stackTraceElement.toString(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber(), null, null);
    }

    public static StackDTM ofSummarizedEventSignature(String string) {
        return new StackDTM(string, null, null, 0, null, null);
    }

    private StackDTM(String string, String string2, String string3, int n2, String string4, String string5) {
        Objects.requireNonNull(string);
        this.signature = string;
        this.method = string2;
        this.file = string3;
        this.lineNumber = n2;
        this.type = string4;
        this.eval = string5;
    }

    private StackDTM(Builder builder) {
        Objects.requireNonNull(builder.signature);
        this.signature = builder.signature;
        this.method = builder.method;
        this.file = builder.file;
        this.lineNumber = builder.lineNumber;
        this.type = builder.type;
        this.eval = builder.eval;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getMethod() {
        return this.method;
    }

    public String getFile() {
        return this.file;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getType() {
        return this.type;
    }

    public String getEval() {
        return this.eval;
    }

    public static final class Builder {
        private String signature;
        private String method;
        private String file;
        private int lineNumber;
        private String type;
        private String eval;

        public Builder(String string) {
            this.signature = string;
        }

        public Builder method(String string) {
            this.method = string;
            return this;
        }

        public Builder file(String string) {
            this.file = string;
            return this;
        }

        public Builder lineNumber(int n2) {
            this.lineNumber = n2;
            return this;
        }

        public Builder type(String string) {
            this.type = string;
            return this;
        }

        public Builder eval(String string) {
            this.eval = string;
            return this;
        }

        public StackDTM build() {
            return new StackDTM(this);
        }
    }
}

