/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.java.matcher;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.commons.Preconditions;
import com.contrastsecurity.agent.commons.Suppliers;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.generated.tags.Tag;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.frameworks.antlr.g;
import com.contrastsecurity.agent.plugins.frameworks.java.matcher.b;
import com.contrastsecurity.agent.plugins.observe.j;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.RegexSecurityControls;
import com.contrastsecurity.agent.plugins.security.controller.EventContext;
import com.contrastsecurity.agent.plugins.security.controller.maps.TraceMap;
import com.contrastsecurity.agent.plugins.security.controller.propagate.c;
import com.contrastsecurity.agent.plugins.security.model.PropagationEvent;
import com.contrastsecurity.agent.plugins.security.model.TagEvent;
import com.contrastsecurity.agent.plugins.security.model.f;
import com.contrastsecurity.agent.plugins.security.model.k;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicyManager;
import com.contrastsecurity.agent.plugins.security.policy.Location;
import com.contrastsecurity.agent.plugins.security.policy.propagators.Propagator;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.agent.scope.ScopeAssess;
import com.contrastsecurity.agent.scope.ScopeType;
import com.contrastsecurity.agent.scope.Scoping;
import com.contrastsecurity.agent.stack.i;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.TagRange;
import com.contrastsecurity.agent.trace.TagRanges;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.trace.d;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.agent.weakmap.ConcurrentReferenceHashMap;
import com.contrastsecurity.thirdparty.iot.api.trace.Span;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

@DontObfuscate
@o
final class ContrastMatcherDispatcherImpl
implements ContrastMatcherDispatcher {
    private final Config config;
    private final com.contrastsecurity.agent.plugins.security.model.c codeEventFactory;
    private final EventContext eventContext;
    private final Supplier<Propagator> appendReplacementPropagatorSupplier;
    private final Supplier<Propagator> quoteReplacementPropagatorSupplier;
    private final i stackCaptureFactory;
    private final d traceFactory;
    private final Map<Matcher, CharSequence> matcherInputCache = new ConcurrentReferenceHashMap<Matcher, CharSequence>(16, 0.75f, 256);
    private final String sensorId;
    @q
    static final int NO_INNER_ESCAPE = -1;
    private static final String MATCHES_METHOD_NAME = "matches";
    private static final Logger logger = LoggerFactory.getLogger(ContrastMatcherDispatcherImpl.class);

    public ContrastMatcherDispatcherImpl(Config config, com.contrastsecurity.agent.plugins.security.model.c c2, EventContext eventContext, i i2, d d2, ContrastPolicyManager contrastPolicyManager) {
        this.config = config;
        this.codeEventFactory = c2;
        this.eventContext = eventContext;
        this.stackCaptureFactory = i2;
        this.traceFactory = d2;
        this.appendReplacementPropagatorSupplier = Suppliers.memoize(() -> {
            ContrastPolicy contrastPolicy = contrastPolicyManager.currentPolicy();
            if (contrastPolicy != null) {
                Propagator propagator = new Propagator(contrastPolicy.getId(), contrastPolicy.getLocation(), "zzz-common-append-replacement-propagator", new Location[]{Location.P1, Location.P2}, Location.COMMON_P1, Propagator.Command.KEEP, null, null, null, false, false, new g());
                contrastPolicyManager.addPropagator(propagator);
                return propagator;
            }
            return null;
        });
        this.quoteReplacementPropagatorSupplier = Suppliers.memoize(() -> {
            ContrastPolicy contrastPolicy = contrastPolicyManager.currentPolicy();
            if (contrastPolicy != null) {
                Propagator propagator = new Propagator(contrastPolicy.getId(), contrastPolicy.getLocation(), "zzz-matcher-quote-replace", new Location[]{Location.P1}, Location.COMMON_R, Propagator.Command.KEEP, null, null, null, false, false, new g());
                contrastPolicyManager.addPropagator(propagator);
                return propagator;
            }
            return null;
        });
        this.sensorId = j.a();
    }

    public void onInputSet(Object object, Matcher matcher, CharSequence charSequence) {
        if (!this.config.getBoolean(ConfigProperty.ASSESS_ENABLED)) {
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        Scoping scoping = contrastContext.scope();
        if (scoping.inNestedScope(ScopeType.GENERAL) || scoping.inScope(ScopeType.ASSESS_SAMPLING)) {
            return;
        }
        if (!RegexSecurityControls.anyRegexs(contrastContext)) {
            return;
        }
        this.matcherInputCache.put(matcher, charSequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMatches(Object object, Matcher matcher) {
        if (!this.config.getBoolean(ConfigProperty.ASSESS_ENABLED)) {
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        Scoping scoping = contrastContext.scope();
        if (scoping.inNestedScope(ScopeType.GENERAL) || scoping.inScope(ScopeType.ASSESS_SAMPLING)) {
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        RegexSecurityControls.TagSetAndRuleString tagSetAndRuleString = RegexSecurityControls.tagsForRegex(application, matcher.pattern().pattern());
        if (tagSetAndRuleString == null) {
            return;
        }
        if (this.matcherInputCache.isEmpty()) {
            return;
        }
        CharSequence charSequence = this.matcherInputCache.get(matcher);
        if (charSequence == null) {
            return;
        }
        Trace trace = (Trace)this.eventContext.getTraceMap(contrastContext.assessment()).get(charSequence);
        if (trace == null) {
            return;
        }
        Span span = com.contrastsecurity.agent.plugins.observe.java.securitycontrols.a.a(contrastContext, this.config, this.sensorId, MATCHES_METHOD_NAME, tagSetAndRuleString.ruleString(), "regex-validator");
        try {
            boolean bl2;
            CodeEvent codeEvent = trace.getLastEvent();
            TagRanges tagRanges = codeEvent.getTagRanges();
            ArrayList<TagRange> arrayList = new ArrayList<TagRange>(tagRanges.size() + tagSetAndRuleString.tags().size());
            for (TagRange object22 : tagRanges) {
                arrayList.add(object22);
            }
            for (Tag tag : tagSetAndRuleString.tags()) {
                arrayList.add(new TagRange(matcher.regionStart(), matcher.regionEnd(), tag));
            }
            TagEvent tagEvent = ((k)((k)((k)((k)((k)((k)((k)((k)this.codeEventFactory.a(contrastContext.assessment()).a(b.b.f.a())).a(matcher)).b(true)).a(Empty.OBJ_ARRAY)).d("java.lang.CharSequence")).a(this.stackCaptureFactory.a(i.a.c))).a(new TagRanges(arrayList))).c(codeEvent)).g();
            AssessmentContext assessmentContext = contrastContext.assessment();
            trace.addEvent(assessmentContext, tagEvent);
            boolean bl3 = bl2 = assessmentContext != null && assessmentContext.isIdentityTaggingEnabled();
            if (!bl2) {
                return;
            }
            int n2 = charSequence.hashCode();
            int n3 = trace.getIdentitySourceHash();
            int n4 = AssessmentContext.calculateIdentity(n2, n3);
            assessmentContext.applyTags(n4, tagSetAndRuleString.tags(), charSequence.length());
        }
        finally {
            com.contrastsecurity.agent.plugins.observe.d.a(this.config, span, contrastContext.observe(), contrastContext.application().current(), "security-control");
        }
    }

    public void onAppendReplacementEndUsingStringBuffer(Object object, Matcher matcher, int n2, CharSequence charSequence, String string, CharSequence charSequence2, int n3) {
        if (!this.config.getBoolean(ConfigProperty.ASSESS_ENABLED)) {
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        Scoping scoping = contrastContext.scope();
        if (ScopeAssess.inAssessOrSamplingScope(scoping)) {
            return;
        }
        com.contrastsecurity.agent.scope.a a2 = scoping.enterAutoScope(ScopeType.ASSESS);
        try {
            this.onAppendReplacementEnd(contrastContext, matcher, n2, charSequence, string, charSequence2, n3, b.b.a);
            if (a2 != null) {
                a2.close();
            }
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            if (a2 != null) {
                try {
                    a2.close();
                }
                catch (Throwable throwable3) {
                    Throwables.throwIfCritical(throwable3);
                    Throwable throwable4 = throwable3;
                    throwable2.addSuppressed(throwable4);
                }
            }
            throw throwable2;
        }
    }

    public void onAppendReplacementEndUsingStringBuilder(Object object, Matcher matcher, int n2, CharSequence charSequence, String string, CharSequence charSequence2, int n3) {
        if (!this.config.getBoolean(ConfigProperty.ASSESS_ENABLED)) {
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        Scoping scoping = contrastContext.scope();
        if (ScopeAssess.inAssessOrSamplingScope(scoping)) {
            return;
        }
        com.contrastsecurity.agent.scope.a a2 = scoping.enterAutoScope(ScopeType.ASSESS);
        try {
            this.onAppendReplacementEnd(contrastContext, matcher, n2, charSequence, string, charSequence2, n3, b.b.b);
            if (a2 != null) {
                a2.close();
            }
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            if (a2 != null) {
                try {
                    a2.close();
                }
                catch (Throwable throwable3) {
                    Throwables.throwIfCritical(throwable3);
                    Throwable throwable4 = throwable3;
                    throwable2.addSuppressed(throwable4);
                }
            }
            throw throwable2;
        }
    }

    @q
    Map<Matcher, CharSequence> matcherInputCache() {
        return Collections.unmodifiableMap(this.matcherInputCache);
    }

    private void onAppendReplacementEnd(ContrastContext contrastContext, Matcher matcher, int n2, CharSequence charSequence, String string, CharSequence charSequence2, int n3, b.b b2) {
        AssessmentContext assessmentContext = contrastContext.assessment();
        if (assessmentContext == null) {
            return;
        }
        TraceMap traceMap = this.eventContext.getTraceMap(assessmentContext);
        if (traceMap.hasReachedMaximumPropagationEvents()) {
            this.appendReplacementPropagatorSupplier.get().logExceededMaximumEvents();
            return;
        }
        Trace trace = (Trace)traceMap.get(charSequence2);
        Trace trace2 = (Trace)traceMap.get(string);
        if (trace == null && trace2 == null) {
            return;
        }
        Trace trace3 = this.traceFactory.a();
        ArrayList<TagRange> arrayList = new ArrayList<TagRange>();
        long l2 = -1L;
        int n4 = n2 - n3;
        int n5 = matcher.start() + n4;
        boolean bl2 = false;
        Trace trace4 = (Trace)traceMap.get(charSequence);
        if (trace4 != null) {
            l2 = trace4.getId();
            trace3.copyEvents(assessmentContext, trace4);
            arrayList.addAll(trace4.getTagRanges().getTagRanges());
            bl2 = true;
        }
        if (trace2 != null) {
            l2 = l2 == -1L ? trace2.getId() : l2;
            trace3.copyEvents(assessmentContext, trace2);
            arrayList.addAll(ContrastMatcherDispatcherImpl.adjustReplacementTags(trace2.getTagRanges(), matcher, string, n5));
        } else {
            l2 = trace.getId();
            trace3.copyEvents(assessmentContext, trace);
        }
        traceMap.put(charSequence, trace3);
        PropagationEvent propagationEvent = ((f)((f)((f)((f)((f)((f)((f)((f)this.codeEventFactory.b(assessmentContext, this.appendReplacementPropagatorSupplier.get()).b(trace3.getId())).a((Collection<Long>)Collections.singleton(l2))).a(b2.a())).b(matcher)).a(bl2 ? null : this.stackCaptureFactory.a(i.a.b))).a(charSequence)).a(new Object[]{charSequence, string})).a(new TagRanges(arrayList))).g();
        trace3.addEvent(assessmentContext, propagationEvent);
        traceMap.incrementPropagationEventCount();
    }

    @IgnoreJRERequirement
    private static List<TagRange> adjustReplacementTags(TagRanges tagRanges, Matcher matcher, String string, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        LinkedHashMap<a, String> linkedHashMap = new LinkedHashMap<a, String>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl2 = false;
        while (n6 < string.length()) {
            char c2 = string.charAt(n6);
            if (c2 == '\\') {
                if (!bl2) {
                    bl2 = true;
                    arrayList.add(n6);
                } else {
                    bl2 = false;
                }
                ++n6;
                continue;
            }
            if (c2 == '$' && !bl2) {
                int n7 = n6++;
                c2 = string.charAt(n6);
                if (!JVMUtils.isJava6() && c2 == '{') {
                    Comparable<TagRange> comparable = new StringBuilder();
                    c2 = string.charAt(++n6);
                    while (c2 != '}') {
                        ((StringBuilder)comparable).append(c2);
                        c2 = string.charAt(++n6);
                    }
                    linkedHashMap.put(a.b(n7, ++n6), matcher.group(((StringBuilder)comparable).toString()));
                } else {
                    int n8 = c2 - 48;
                    ++n6;
                    n5 = 0;
                    while (n5 == 0 && n6 < string.length() && (n4 = string.charAt(n6) - 48) >= 0 && n4 <= 9) {
                        n3 = n8 * 10 + n4;
                        if (matcher.groupCount() < n3) {
                            n5 = 1;
                            continue;
                        }
                        n8 = n3;
                        ++n6;
                    }
                    linkedHashMap.put(a.b(n7, n6), matcher.group(n8));
                }
                bl2 = false;
                continue;
            }
            bl2 = false;
            ++n6;
        }
        ArrayList<TagRange> arrayList2 = new ArrayList<TagRange>();
        for (Comparable<TagRange> comparable : tagRanges) {
            n5 = ContrastMatcherDispatcherImpl.escapesBefore(((TagRange)comparable).getStart(), arrayList);
            n4 = ContrastMatcherDispatcherImpl.escapesBefore(((TagRange)comparable).getStop(), arrayList);
            if (linkedHashMap.isEmpty()) {
                arrayList2.add(new TagRange(n2 + ((TagRange)comparable).getStart() - n5, n2 + ((TagRange)comparable).getStop() - n4, ((TagRange)comparable).getTag()));
                continue;
            }
            n3 = n2;
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                int n9 = ContrastMatcherDispatcherImpl.addResultingReplacementTagRange(arrayList2, comparable, n3, ((String)entry.getValue()).length(), (a)entry.getKey(), n5, n4, arrayList);
                n3 += n9;
            }
        }
        return Collections.unmodifiableList(arrayList2);
    }

    private static int addResultingReplacementTagRange(List<TagRange> list, TagRange tagRange, int n2, int n3, a a2, int n4, int n5, List<Integer> list2) {
        int n6;
        int n7;
        int n8 = n3 - (a2.b - a2.a);
        switch (tagRange.compareRange(a2.a, a2.b)) {
            case f: {
                n7 = Math.max(0, tagRange.getStart() + n8 + n2 - n4);
                n6 = tagRange.getStop() + n8 + n2 - n5;
                break;
            }
            case b: {
                n7 = Math.max(0, tagRange.getStart() + n2 - n4);
                n6 = a2.b + n8 + n2 - ContrastMatcherDispatcherImpl.escapesBefore(a2.b, list2);
                break;
            }
            case e: {
                n7 = Math.max(0, a2.a + n2 - ContrastMatcherDispatcherImpl.escapesBefore(a2.a, list2));
                n6 = tagRange.getStop() + n8 + n2 - n5;
                break;
            }
            case c: {
                n7 = Math.max(0, a2.a + n2 - ContrastMatcherDispatcherImpl.escapesBefore(a2.a, list2));
                n6 = a2.b + n8 + n2 - ContrastMatcherDispatcherImpl.escapesBefore(a2.b, list2);
                break;
            }
            case d: {
                n7 = Math.max(0, tagRange.getStart() + n2 - n4);
                n6 = tagRange.getStop() + n8 + n2 - n5;
                break;
            }
            case a: {
                n7 = Math.max(0, tagRange.getStart() + n2 - n4);
                n6 = tagRange.getStop() + n2 - n5;
                break;
            }
            default: {
                n7 = 0;
                n6 = 0;
            }
        }
        if (n7 < n6) {
            list.add(new TagRange(n7, n6, tagRange.getTag()));
        }
        return n8;
    }

    public void onQuoteReplacementEnd(Object object, String string, String string2) {
        if (!this.config.getBoolean(ConfigProperty.ASSESS_ENABLED)) {
            return;
        }
        if (string == string2) {
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        if (contrastContext.scope().inNestedScope(ScopeType.GENERAL)) {
            return;
        }
        AssessmentContext assessmentContext = contrastContext.assessment();
        TraceMap traceMap = this.eventContext.getTraceMap(assessmentContext);
        if (traceMap.hasReachedMaximumPropagationEvents()) {
            this.quoteReplacementPropagatorSupplier.get().logExceededMaximumEvents();
            return;
        }
        Trace trace = (Trace)traceMap.get(string);
        if (trace == null) {
            return;
        }
        Trace trace2 = this.traceFactory.a();
        ArrayList<TagRange> arrayList = new ArrayList<TagRange>();
        long l2 = trace.getId();
        trace2.copyEvents(assessmentContext, trace);
        ContrastMatcherDispatcherImpl.calculateAfterQuotingTagRanges(arrayList, string, trace.getTagRanges());
        if (arrayList.isEmpty()) {
            return;
        }
        TagRanges tagRanges = new TagRanges(arrayList);
        traceMap.put(string2, trace2);
        PropagationEvent propagationEvent = ((f)((f)((f)((f)((f)((f)((f)((f)this.codeEventFactory.b(assessmentContext, this.quoteReplacementPropagatorSupplier.get()).b(trace2.getId())).a((Collection<Long>)Collections.singleton(l2))).a(b.b.c.a())).b((Object)string2)).a((Object)string)).a(new Object[]{string})).a(tagRanges)).a(this.stackCaptureFactory.a(i.a.b))).g();
        trace2.addEvent(assessmentContext, propagationEvent);
        traceMap.incrementPropagationEventCount();
        if (assessmentContext == null || !assessmentContext.isIdentityTaggingEnabled()) {
            return;
        }
        c.a(string2, trace2, trace, assessmentContext);
    }

    @q
    static void calculateAfterQuotingTagRanges(List<TagRange> list, String string, TagRanges tagRanges) {
        ArrayList<TagRange> arrayList = new ArrayList<TagRange>(tagRanges.size() * 2);
        for (TagRange tagRange : tagRanges) {
            arrayList.add(tagRange.copy());
        }
        List<Integer> list2 = ContrastMatcherDispatcherImpl.findInsertedEscapeIndexes(string);
        int n2 = 0;
        while (n2 < arrayList.size()) {
            TagRange tagRange = (TagRange)arrayList.get(n2++);
            int n3 = ContrastMatcherDispatcherImpl.escapesBeforeOrAt(tagRange.getStart(), list2);
            int n4 = ContrastMatcherDispatcherImpl.firstInnerEscapeIdx(tagRange.getStart(), tagRange.getStop(), list2);
            if (n4 == -1) {
                list.add(new TagRange(tagRange.getStart() + n3, tagRange.getStop() + n3, tagRange.getTag()));
                continue;
            }
            list.add(new TagRange(tagRange.getStart() + n3, n4 + n3, tagRange.getTag()));
            arrayList.add(new TagRange(n4, tagRange.getStop(), tagRange.getTag()));
        }
    }

    @q
    static List<Integer> findInsertedEscapeIndexes(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '\\' && c2 != '$') continue;
            arrayList.add(i2);
        }
        return arrayList;
    }

    @q
    static int escapesBefore(int n2, List<Integer> list) {
        int n3 = 0;
        for (Integer n4 : list) {
            if (n4 < n2) {
                ++n3;
                continue;
            }
            return n3;
        }
        return n3;
    }

    @q
    static int escapesBeforeOrAt(int n2, List<Integer> list) {
        int n3 = ContrastMatcherDispatcherImpl.escapesBefore(n2, list);
        return list.contains(n2) ? n3 + 1 : n3;
    }

    @q
    static int firstInnerEscapeIdx(int n2, int n3, List<Integer> list) {
        for (Integer n4 : list) {
            if (n4 <= n2) continue;
            if (n4 >= n3) break;
            return n4;
        }
        return -1;
    }

    private static final class a {
        private final int a;
        private final int b;

        private a(int n2, int n3) {
            Preconditions.check(n2 <= n3 && n2 >= 0, "Bad Match start and end: (%s, %s)", n2, n3);
            this.a = n2;
            this.b = n3;
        }

        private static a b(int n2, int n3) {
            return new a(n2, n3);
        }

        public String toString() {
            return "Match{start=" + this.a + ", end=" + this.b + '}';
        }
    }
}

