/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.protect;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Assert;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.app.activity.protect.details.UserInputDTM;
import com.contrastsecurity.agent.plugins.protect.AttackBlockedException;
import com.contrastsecurity.agent.plugins.protect.N;
import com.contrastsecurity.agent.plugins.protect.O;
import com.contrastsecurity.agent.plugins.protect.ProtectContext;
import com.contrastsecurity.agent.plugins.protect.ProtectManager;
import com.contrastsecurity.agent.plugins.protect.b.b;
import com.contrastsecurity.agent.plugins.protect.b.c;
import com.contrastsecurity.agent.plugins.protect.b.d;
import com.contrastsecurity.agent.plugins.protect.c;
import com.contrastsecurity.agent.plugins.protect.e;
import com.contrastsecurity.agent.plugins.protect.r;
import com.contrastsecurity.agent.plugins.protect.rules.k;
import com.contrastsecurity.agent.plugins.protect.rules.p;
import com.contrastsecurity.agent.plugins.protect.v;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.agent.telemetry.metrics.Counter;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.telemetry.metrics.d;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.net.URLDecoder;
import java.util.Objects;

@DontObfuscate
abstract class ProtectInputScanner {
    private final c analysisCache;
    private final Config config;
    private final Counter ignoredInputCounter;
    private final Counter usedAnalysisCacheCounter;
    private final Counter skippedAnalysisCacheCounter;
    private final d.b<c.a, Counter> codecsCounter;
    protected final ProtectManager manager;
    protected final com.contrastsecurity.agent.plugins.protect.g.b logEnhancer;
    protected final e publisher;
    @q
    static final v IGNORED = new v(r.a);
    @q
    static final String COUNTER_IGNORED_INPUT = "ignoredInputCount";
    @q
    static final String COUNTER_ANALYSIS_CACHE_USED = "analysisCacheUsedCount";
    @q
    static final String COUNTER_ANALYSIS_CACHE_UNUSED = "analysisCacheUnusedCount";
    private static final Logger logger = LoggerFactory.getLogger(ProtectInputScanner.class);

    ProtectInputScanner(com.contrastsecurity.agent.plugins.protect.g.b b2, Config config, ProtectManager protectManager, a a2, c c2, e e2) {
        this.logEnhancer = Objects.requireNonNull(b2);
        this.config = Objects.requireNonNull(config);
        this.manager = Objects.requireNonNull(protectManager);
        this.analysisCache = Objects.requireNonNull(c2);
        this.publisher = Objects.requireNonNull(e2);
        this.ignoredInputCounter = Objects.requireNonNull(a2).a;
        this.skippedAnalysisCacheCounter = a2.c;
        this.usedAnalysisCacheCounter = a2.b;
        this.codecsCounter = a2.d;
    }

    public v evaluate(ContrastContext contrastContext, UserInputDTM.InputType inputType, String string, String string2, k k2) throws AttackBlockedException {
        return this.evaluate(contrastContext, inputType, string, string2, k2, -1);
    }

    public v evaluate(ContrastContext contrastContext, UserInputDTM.InputType inputType, String string, String string2, k k2, int n2) throws AttackBlockedException {
        v v2;
        com.contrastsecurity.agent.plugins.protect.d d2 = contrastContext.threadLocals().c().b();
        if (string2 == null || string2.length() < k2.c()) {
            v2 = IGNORED;
            this.ignoredInputCounter.increment();
        } else {
            String string3 = k2.getRuleId().id();
            d2.a(string3, inputType, string2, string);
            v2 = this.analysisCache.a(d2);
            if (v2 == null) {
                this.skippedAnalysisCacheCounter.increment();
                b b2 = contrastContext.protect().canonicalize(string2);
                String string4 = b2.c();
                int n3 = n2 != -1 ? n2 : N.a(string2);
                v2 = k2.evaluateInput(contrastContext, inputType, string, string2, string4, n3);
                if (v2 == null) {
                    v2 = IGNORED;
                }
                this.analysisCache.a(d2, v2);
                if (r.a != v2.a()) {
                    for (d d3 : b2.a()) {
                        this.codecsCounter.get(d3.b()).increment();
                    }
                }
            } else {
                this.usedAnalysisCacheCounter.increment();
            }
        }
        if (r.c == v2.a() && this.manager.shouldBlockAtPerimeter(contrastContext, k2, inputType)) {
            this.recordPerimeterBlockSample(contrastContext, k2, inputType, string, string2, v2);
            throw new AttackBlockedException("Attack detected");
        }
        return v2;
    }

    void saveInput(ContrastContext contrastContext, k k2, O o2) {
        Object object;
        Object object2;
        UserInputDTM userInputDTM = o2.a();
        UserInputDTM.InputType inputType = userInputDTM.getType();
        if (inputType == UserInputDTM.InputType.COOKIE_VALUE) {
            object2 = userInputDTM.getValue();
            try {
                object = URLDecoder.decode((String)object2, "UTF-8");
                if (!((String)object2).equals(object)) {
                    o2.a(UserInputDTM.builder(userInputDTM).value((String)object).build());
                }
            }
            catch (AttackBlockedException attackBlockedException) {
                throw attackBlockedException;
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
            }
        }
        if (k2.a((HttpRequest)(object2 = contrastContext.http().getRequest()))) {
            object = contrastContext.protect();
            ((ProtectContext)object).saveInput(contrastContext, this.config, k2, o2);
        } else {
            logger.debug("Not saving context input {} for rule {} because of HTTP request type", (Object)o2.a().getType(), (Object)k2.getRuleId().id());
            if (o2.d()) {
                this.publisher.a(contrastContext, k2.getRuleId(), o2.a(), k2.a_());
            }
        }
    }

    protected void logResult(ContrastContext contrastContext, r r2, k k2, String string, String string2, String string3) {
        switch (r2) {
            case a: {
                this.logEnhancer.c(contrastContext, k2.getRuleId(), string, string2, string3);
                break;
            }
            case b: {
                this.logEnhancer.b(contrastContext, k2.getRuleId(), string, string2, string3);
                break;
            }
            case c: {
                this.logEnhancer.a(contrastContext, k2.getRuleId(), string, string2, string3);
                break;
            }
            default: {
                Assert.fail("Unexpected EvaluationResult value encountered: " + (Object)((Object)r2));
                logger.debug("Unexpected EvaluationResult value encountered: {}", (Object)r2);
            }
        }
    }

    private void recordPerimeterBlockSample(ContrastContext contrastContext, p p2, UserInputDTM.InputType inputType, String string, String string2, v v2) {
        this.publisher.a(contrastContext, p2.getRuleId(), UserInputDTM.builder().type(inputType).name(string).value(string2).filters(v2.b()).build());
    }

    public static final class a {
        final Counter a;
        final Counter b;
        final Counter c;
        final d.b<c.a, Counter> d;

        a(TelemetryMetrics telemetryMetrics) {
            this.a = telemetryMetrics.newCounter(ProtectInputScanner.COUNTER_IGNORED_INPUT, TelemetryMetrics.TelemetryCategory.PROTECT).withDescription("The number of times the evaluate() method was called and the EvaluationResult was IGNORED").register();
            this.b = telemetryMetrics.newCounter(ProtectInputScanner.COUNTER_ANALYSIS_CACHE_USED, TelemetryMetrics.TelemetryCategory.PROTECT).withDescription("The number of times the AnalysisCache was used").register();
            this.c = telemetryMetrics.newCounter(ProtectInputScanner.COUNTER_ANALYSIS_CACHE_UNUSED, TelemetryMetrics.TelemetryCategory.PROTECT).withDescription("The number of times the AnalysisCache was empty and was not used").register();
            this.d = telemetryMetrics.newGrouped(telemetryMetrics.newCounter("codecsUsedInWorthWatchingCount", TelemetryMetrics.TelemetryCategory.CANONICALIZER).withDescription("The times each Codec was involved in the decoding of an input that was marked Worth Watching or higher").withExpiration(com.contrastsecurity.agent.telemetry.d.a)).a("codecName").a(c.a.class);
        }
    }
}

