/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.rules.providers;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.context.RequestContext;
import com.contrastsecurity.agent.http.ContrastContentType;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.messages.finding.trace.PropertyKey;
import com.contrastsecurity.agent.plugins.security.j;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.DoNothingHttpWatcher;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.ProviderUtil;
import com.contrastsecurity.agent.util.p;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.ArrayUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.EnumMap;
import java.util.zip.CRC32;

@DontObfuscate
@HeapUsage.SupportsHeapProfiling
public abstract class HeaderHttpWatcher
extends DoNothingHttpWatcher {
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    protected final ProviderUtil providerUtil;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    private final j.e requestHasher;
    private static final int[] UNDESIRED_RESPONSE_CODES = new int[]{301, 302, 307, 404, 410, 500};
    protected static final Logger logger = LoggerFactory.getLogger(HeaderHttpWatcher.class);

    public HeaderHttpWatcher(ProviderUtil providerUtil, j j2) {
        this.providerUtil = providerUtil;
        this.requestHasher = j2.g();
    }

    @Override
    public boolean supports(HttpRequest httpRequest) {
        return !p.b(httpRequest);
    }

    @Override
    public void onResponseEnd(ContrastContext contrastContext) {
        HttpResponse httpResponse = contrastContext.http().getResponse();
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpResponse == null || this.isSafe(httpRequest.context())) {
            return;
        }
        if (this.undesiredResponseCode(httpResponse)) {
            if (logger.isDebugEnabled()) {
                logger.debug("suppressing finding for {} rule, response code is: {}", (Object)this.getRuleName(), (Object)httpResponse.getStatus());
            }
            return;
        }
        ContrastContentType contrastContentType = httpResponse.getContentType();
        if (this.isUndesiredContentType(contrastContentType)) {
            return;
        }
        long l2 = this.requestHasher.a(this.getRuleName(), httpRequest);
        EnumMap<PropertyKey, String> enumMap = new EnumMap<PropertyKey, String>(PropertyKey.class);
        enumMap.put(PropertyKey.DATA, this.getData(httpRequest.context()));
        this.providerUtil.reportFinding(contrastContext, this.getRuleName(), enumMap, l2);
    }

    @Override
    public long getRuleRequestHash(HttpRequest httpRequest, CRC32 cRC32) {
        return this.requestHasher.a(cRC32, this.getRuleName(), httpRequest);
    }

    protected abstract boolean isSafe(RequestContext var1);

    protected abstract String getRuleName();

    protected abstract String getData(RequestContext var1);

    protected boolean isUndesiredContentType(ContrastContentType contrastContentType) {
        return false;
    }

    private boolean undesiredResponseCode(HttpResponse httpResponse) {
        boolean bl2 = false;
        try {
            int n2 = httpResponse.getStatus();
            if (ArrayUtils.contains(UNDESIRED_RESPONSE_CODES, n2)) {
                bl2 = true;
            }
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.debug("Problem catching response code for HTTP Header check", throwable2);
        }
        return bl2;
    }
}

