/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.queues.lockfree;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.thirdparty.ojt.queues.MessagePassingQueue;
import com.contrastsecurity.thirdparty.ojt.queues.MpscArrayQueue;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

@DontObfuscate
final class ContrastJ8MpscBlockingQueue<E>
extends MpscArrayQueue<E>
implements BlockingQueue<E> {
    private final MessagePassingQueue.WaitStrategy waitStrategy;
    private final int offerIfBelowThreshold;

    ContrastJ8MpscBlockingQueue(int n2, int n3, MessagePassingQueue.WaitStrategy waitStrategy) {
        super(n2);
        this.offerIfBelowThreshold = n3 == 0 ? n2 : n3;
        this.waitStrategy = waitStrategy;
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        return this.drainTo(collection, this.capacity());
    }

    @Override
    public int drainTo(Collection<? super E> collection, int n2) {
        return this.drain((E object) -> collection.add(object), n2);
    }

    @Override
    public boolean offer(E e2, long l2, TimeUnit timeUnit) throws InterruptedException {
        int n2 = 0;
        long l3 = System.nanoTime() + timeUnit.toNanos(l2);
        while (!this.offer(e2)) {
            if (System.nanoTime() - l3 > 0L) {
                return false;
            }
            n2 = this.waitStrategy.idle(n2);
            if (!Thread.interrupted()) continue;
            throw new InterruptedException();
        }
        return true;
    }

    @Override
    public E poll(long l2, TimeUnit timeUnit) throws InterruptedException {
        int n2 = 0;
        long l3 = System.nanoTime() + timeUnit.toNanos(l2);
        do {
            Object e2;
            if ((e2 = this.poll()) != null) {
                return e2;
            }
            if (System.nanoTime() - l3 > 0L) {
                return null;
            }
            n2 = this.waitStrategy.idle(n2);
        } while (!Thread.interrupted());
        throw new InterruptedException();
    }

    @Override
    public void put(E e2) throws InterruptedException {
        int n2 = 0;
        while (!this.offer(e2)) {
            n2 = this.waitStrategy.idle(n2);
            if (!Thread.interrupted()) continue;
            throw new InterruptedException();
        }
    }

    @Override
    public boolean offer(E e2) {
        return this.offerIfBelowThreshold(e2, this.offerIfBelowThreshold);
    }

    @Override
    public int remainingCapacity() {
        return this.capacity() - this.size();
    }

    @Override
    public E take() throws InterruptedException {
        int n2 = 100;
        do {
            Object e2;
            if ((e2 = this.relaxedPoll()) != null) {
                return e2;
            }
            n2 = this.waitStrategy.idle(n2);
        } while (!Thread.interrupted());
        throw new InterruptedException();
    }

    static {
        Class<LockSupport> clazz = LockSupport.class;
    }
}

