/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.services;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Preconditions;
import com.contrastsecurity.agent.commons.Purgeable;
import com.contrastsecurity.agent.commons.SimpleSleeper;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.commons.e;
import com.contrastsecurity.agent.commons.g;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.agent.services.f;
import com.contrastsecurity.agent.telemetry.errors.o;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.agent.util.PreConfigUtil;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@DontObfuscate
public final class PurgeThread
extends Thread {
    private final Clock clock;
    private final f shouldKeepReporting;
    private final g sleeper;
    private final o errorEmitter;
    private final List<Purgeable> purgeables;
    private final boolean profilePurgeables;
    private final int purgingDelay;
    private static final Logger logger = LoggerFactory.getLogger(PurgeThread.class);

    PurgeThread(Clock clock, f f2, Config config, List<Purgeable> list, o o2) {
        this(clock, f2, config, list, new SimpleSleeper(), o2);
    }

    @q
    PurgeThread(Clock clock, f f2, Config config, List<Purgeable> list, g g2, o o2) {
        this.clock = Objects.requireNonNull(clock);
        this.shouldKeepReporting = Objects.requireNonNull(f2);
        this.purgeables = list == null ? Collections.emptyList() : list;
        this.errorEmitter = Objects.requireNonNull(o2);
        this.sleeper = Objects.requireNonNull(g2);
        this.profilePurgeables = config.getBoolean(ConfigProperty.PROFILE_PURGEABLES);
        this.purgingDelay = config.getInt(ConfigProperty.PURGING_DELAY);
        Preconditions.check(this.purgingDelay > 0, "Purging delay must be greater than 0");
    }

    @Override
    @ScopedSensor
    public void run() {
        ScopeProvider scopeProvider = ContrastContext.current().scopeProvider().enterScope();
        try {
            while (this.shouldKeepReporting.a()) {
                long l2 = this.clock.nanoTime();
                int n2 = 0;
                int n3 = 0;
                for (Purgeable purgeable : this.purgeables) {
                    Object object;
                    try {
                        object = purgeable.purgeStale();
                        int n4 = ((e)object).c();
                        n2 += ((e)object).b();
                        n3 += n4;
                        if (this.profilePurgeables) {
                            PreConfigUtil.out("Purgeable: [" + JVMUtils.getSafeToString(purgeable, true) + "], before=" + ((e)object).a() + ", after=" + ((e)object).c());
                        }
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Purgeable={}, before={}, after={}", JVMUtils.getSafeToString(purgeable, true), ((e)object).a(), n4);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                    }
                    catch (Throwable throwable) {
                        Throwables.throwIfCritical(throwable);
                        object = throwable;
                        object = Throwables.addClassLoaderInfoIfNecessary((Throwable)object);
                        this.errorEmitter.a((Throwable)object);
                        logger.error("Problem clearing purgeable {}", (Object)JVMUtils.getSafeToString(purgeable, true), object);
                    }
                }
                long l3 = this.clock.nanoTime();
                long l4 = TimeUnit.NANOSECONDS.toMillis(l3 - l2);
                logger.debug("Total purged={}, total still alive={}, in {}ms", n2, n3, l4);
                long l5 = (long)this.purgingDelay - l4;
                if (l5 <= 0L) continue;
                this.sleeper.sleep(l5);
            }
            logger.info("Stopped purging thread.");
            scopeProvider.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeProvider.leaveScope();
            throw throwable;
        }
    }
}

