/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.startup;

import com.contrastsecurity.agent.commons.SimpleSleeper;
import com.contrastsecurity.agent.commons.g;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.contrastapi_v1_0.inventory.ServerInventoryDTM;
import com.contrastsecurity.agent.e.d;
import com.contrastsecurity.agent.e.e;
import com.contrastsecurity.agent.h.b;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.agent.services.a.F;
import com.contrastsecurity.agent.telemetry.errors.o;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.agent.util.t;
import com.contrastsecurity.thirdparty.cggl.gson.JsonSyntaxException;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.oa4j.http.client.methods.HttpGet;
import com.contrastsecurity.thirdparty.oa4j.http.client.methods.HttpPut;
import com.contrastsecurity.thirdparty.oa4j.http.client.methods.HttpRequestBase;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import com.sun.management.OperatingSystemMXBean;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class v
implements com.contrastsecurity.agent.services.a {
    private final b a;
    private final Config b;
    private final F<ServerInventoryDTM> c;
    private final o d;
    private static final Logger e = LoggerFactory.getLogger(v.class);

    public v(b b2, Config config, F<ServerInventoryDTM> f2, o o2) {
        this.a = b2;
        this.b = config;
        this.c = f2;
        this.d = o2;
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean blocksOnStop() {
        return false;
    }

    @Override
    public void start(Instrumentation instrumentation, List<? extends ContrastPlugin> list) {
        Thread thread = com.contrastsecurity.agent.scope.b.a("Server Inventory Service", new a(this.a, this.b, this.c), this.d);
        thread.setDaemon(true);
        thread.start();
    }

    @q
    static ServerInventoryDTM.MemoryMetrics a(MemoryMXBean memoryMXBean, OperatingSystemMXBean operatingSystemMXBean, List<MemoryPoolMXBean> list) {
        if (operatingSystemMXBean == null || memoryMXBean == null) {
            e.debug("Cannot calculate memory metrics, OperatingSystemMXBean or MemoryMXBean is null.");
            return null;
        }
        long l2 = operatingSystemMXBean.getTotalPhysicalMemorySize();
        long l3 = memoryMXBean.getHeapMemoryUsage().getMax();
        long l4 = memoryMXBean.getNonHeapMemoryUsage().getMax();
        if (l4 == -1L) {
            e.debug("There is no max limit set for non-heap memory ( non-heap: {} ), JVM might be misconfigured. Calculating alternative max non-heap memory limit from memory pool.", (Object)l4);
            l4 = v.a(list);
        }
        if (l3 == -1L) {
            e.debug("There is no max limit set for heap memory ( heap: {} ), JVM might be misconfigured. Sending host memory limit as max.", (Object)l3);
            return new ServerInventoryDTM.MemoryMetrics(l2, l2);
        }
        return new ServerInventoryDTM.MemoryMetrics(l3 + l4, l2);
    }

    private static long a(List<MemoryPoolMXBean> list) {
        long l2 = 0L;
        for (MemoryPoolMXBean memoryPoolMXBean : list) {
            if (memoryPoolMXBean.getType() != MemoryType.NON_HEAP) continue;
            long l3 = memoryPoolMXBean.getUsage().getMax();
            if (l3 > 0L) {
                l2 += l3;
                continue;
            }
            l2 += memoryPoolMXBean.getUsage().getCommitted();
        }
        return l2;
    }

    private static String b(Map<?, ?> map, String string) {
        Object obj = map.get(string);
        if (obj instanceof String) {
            return StringUtils.trimToNull((String)obj);
        }
        return null;
    }

    private static String b(HttpRequestBase httpRequestBase, d.b<String> b2) {
        if (d.b.b.a != b2.a()) {
            e.trace("Request to {} failed with error code: {}.", httpRequestBase.getURI(), b2.b(), b2.e());
            return null;
        }
        return b2.d();
    }

    @Override
    public String getName() {
        return "ServerInventoryService";
    }

    @q
    static final class a
    implements Runnable {
        private final Config a;
        private final b b;
        private final F<ServerInventoryDTM> c;
        private final d d;
        private final long e;
        private final long f;
        private final t g;
        private final g h;

        a(b b2, Config config, F<ServerInventoryDTM> f2) {
            this(b2, config, f2, com.contrastsecurity.agent.e.e.a(config).a(b2).a(false).a(config.getInt(ConfigProperty.CLOUD_RESOURCE_DETECTOR_TIMEOUT_MS)).a(new int[]{410, 429, 500}).b(), t.a, new SimpleSleeper());
        }

        a(b b2, Config config, F<ServerInventoryDTM> f2, d d2, t t2, g g2) {
            this.a = config;
            this.b = b2;
            this.c = f2;
            this.d = d2;
            this.e = config.getLong(ConfigProperty.CLOUD_RESOURCE_DETECTOR_BACKOFF_FACTOR_MS);
            this.f = config.getLong(ConfigProperty.CLOUD_RESOURCE_DETECTOR_MAX_TOTAL_BACKOFF_MS);
            this.g = t2;
            this.h = g2;
        }

        @Override
        public void run() {
            List<MemoryPoolMXBean> list;
            OperatingSystemMXBean operatingSystemMXBean;
            String string = StringUtils.joinWith(" ", this.b.i(), this.b.k(), this.b.h());
            ServerInventoryDTM serverInventoryDTM = new ServerInventoryDTM(string, this.b.d(), JVMUtils.getJavaRuntimeName() + " " + JVMUtils.getJavaRuntimeVersion(), JVMUtils.getJavaHomePath());
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            ServerInventoryDTM.MemoryMetrics memoryMetrics = v.a(memoryMXBean, operatingSystemMXBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class), list = ManagementFactory.getMemoryPoolMXBeans());
            if (memoryMetrics != null) {
                serverInventoryDTM.memoryMetrics(memoryMetrics);
            }
            if (this.b.l() == com.contrastsecurity.agent.h.a.d) {
                serverInventoryDTM.isKubernetes(true);
            }
            if (this.b.l() == com.contrastsecurity.agent.h.a.b) {
                serverInventoryDTM.isDocker(true);
            }
            if (this.a.getBoolean(ConfigProperty.DISCOVER_CLOUD_RESOURCE_ID)) {
                for (ServerInventoryDTM.CloudProvider cloudProvider : ServerInventoryDTM.CloudProvider.values()) {
                    d.b<String> b2;
                    switch (cloudProvider) {
                        case AWS: {
                            b2 = this.a();
                            break;
                        }
                        case AZURE: {
                            b2 = this.b();
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported " + ServerInventoryDTM.CloudProvider.class.getSimpleName() + " of " + (Object)((Object)cloudProvider));
                        }
                    }
                    if (d.b.b.a == b2.a() && b2.d() != null) {
                        serverInventoryDTM.cloudProvider(cloudProvider);
                        serverInventoryDTM.cloudResourceId(b2.d());
                        continue;
                    }
                    e.debug("No cloud resource ID found for {}: {}. HTTP response code {}.", new Object[]{cloudProvider, b2.a(), b2.b()});
                }
            }
            try {
                this.d.close();
            }
            catch (IOException iOException) {
                e.debug("Failed to close HttpClient.", iOException);
            }
            this.c.a(serverInventoryDTM);
            if (e.isDebugEnabled()) {
                e.debug("Determined server inventory to be: {}", (Object)ObjectShare.GSON.toJson(serverInventoryDTM));
            }
        }

        private d.b<String> a() {
            HttpPut httpPut = new HttpPut("http://169.254.169.254/latest/api/token");
            httpPut.addHeader("X-aws-ec2-metadata-token-ttl-seconds", Long.toString(TimeUnit.MILLISECONDS.toSeconds(this.f * 2L)));
            d.b<String> b2 = this.d.a(httpPut, d::a, this.e, this.f, this.g, this.h);
            if (b2.a() == d.b.b.b) {
                return b2;
            }
            String string = v.b(httpPut, b2);
            HttpGet httpGet = new HttpGet("http://169.254.169.254/latest/dynamic/instance-identity/document");
            if (string != null) {
                httpGet.addHeader("X-aws-ec2-metadata-token", string);
            } else {
                e.debug("Failed to obtain AWS token. Attempting to determine the cloud resource ID without it.");
            }
            return this.d.a(httpGet, httpResponse -> {
                String string = com.contrastsecurity.agent.e.d.a(httpResponse);
                try {
                    Map map = ObjectShare.GSON.fromJson(string, Map.class);
                    if (map == null) {
                        return null;
                    }
                    String string2 = v.b(map, "accountId");
                    if (string2 == null) {
                        return null;
                    }
                    String string3 = v.b(map, "region");
                    if (string3 == null) {
                        return null;
                    }
                    String string4 = v.b(map, "instanceId");
                    if (string4 == null) {
                        return null;
                    }
                    return "arn:aws:ec2:" + string3 + ":" + string2 + ":instance/" + string4;
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    e.debug("Unexpected JSON document found at {}:\n{}", (Object)httpGet.getURI(), (Object)string);
                    return null;
                }
            }, this.e, this.f, this.g, this.h);
        }

        private d.b<String> b() {
            HttpGet httpGet = new HttpGet("http://169.254.169.254/metadata/instance/compute/resourceId?api-version=2023-07-01&format=text");
            httpGet.addHeader("Metadata", "true");
            return this.d.a(httpGet, d::a, this.e, this.f, this.g, this.h);
        }
    }
}

