/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.cesyb;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.cesyb.Beans;
import com.contrastsecurity.thirdparty.cesyb.Version;
import com.contrastsecurity.thirdparty.cesyb.emitter.EmitterConfig;
import com.contrastsecurity.thirdparty.cesyb.scalar.DateSerializer;
import com.contrastsecurity.thirdparty.cesyb.scalar.ScalarSerializer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class YamlConfig {
    public WriteConfig writeConfig = new WriteConfig();
    public ReadConfig readConfig = new ReadConfig();
    final Map<String, String> classNameToTag = new HashMap<String, String>();
    final Map<String, Class> tagToClass = new HashMap<String, Class>();
    final Map<Class, ScalarSerializer> scalarSerializers = new IdentityHashMap<Class, ScalarSerializer>();
    final Map<Beans.Property, Class> propertyToElementType = new HashMap<Beans.Property, Class>();
    final Map<Beans.Property, Class> propertyToDefaultType = new HashMap<Beans.Property, Class>();
    boolean beanProperties = true;
    boolean privateFields;
    boolean privateConstructors = true;
    boolean allowDuplicates = true;
    String tagSuffix;

    public YamlConfig() {
        this.scalarSerializers.put(Date.class, new DateSerializer());
        this.tagToClass.put("tag:yaml.org,2002:str", String.class);
        this.tagToClass.put("tag:yaml.org,2002:int", Integer.class);
        this.tagToClass.put("tag:yaml.org,2002:seq", ArrayList.class);
        this.tagToClass.put("tag:yaml.org,2002:map", HashMap.class);
        this.tagToClass.put("tag:yaml.org,2002:float", Float.class);
    }

    public void setAllowDuplicates(boolean bl2) {
        this.allowDuplicates = bl2;
    }

    public void setClassTag(String string, Class clazz) {
        if (string == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (!string.startsWith("!")) {
            string = "!" + string;
        }
        this.classNameToTag.put(clazz.getName(), string);
        this.tagToClass.put(string, clazz);
    }

    public void setScalarSerializer(Class clazz, ScalarSerializer scalarSerializer) {
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (scalarSerializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.scalarSerializers.put(clazz, scalarSerializer);
    }

    public void setPropertyElementType(Class clazz, String string, Class clazz2) {
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("propertyName cannot be null.");
        }
        if (clazz2 == null) {
            throw new IllegalArgumentException("propertyType cannot be null.");
        }
        Beans.Property property = Beans.getProperty(clazz, string, this.beanProperties, this.privateFields, this);
        if (property == null) {
            throw new IllegalArgumentException("The class " + clazz.getName() + " does not have a property named: " + string);
        }
        if (!Collection.class.isAssignableFrom(property.getType()) && !Map.class.isAssignableFrom(property.getType())) {
            throw new IllegalArgumentException("The '" + string + "' property on the " + clazz.getName() + " class must be a Collection or Map: " + property.getType());
        }
        this.propertyToElementType.put(property, clazz2);
    }

    public void setPropertyDefaultType(Class clazz, String string, Class clazz2) {
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("propertyName cannot be null.");
        }
        if (clazz2 == null) {
            throw new IllegalArgumentException("defaultType cannot be null.");
        }
        Beans.Property property = Beans.getProperty(clazz, string, this.beanProperties, this.privateFields, this);
        if (property == null) {
            throw new IllegalArgumentException("The class " + clazz.getName() + " does not have a property named: " + string);
        }
        this.propertyToDefaultType.put(property, clazz2);
    }

    public void setBeanProperties(boolean bl2) {
        this.beanProperties = bl2;
    }

    public void setPrivateFields(boolean bl2) {
        this.privateFields = bl2;
    }

    public void setPrivateConstructors(boolean bl2) {
        this.privateConstructors = bl2;
    }

    public void setTagSuffix(String string) {
        this.tagSuffix = string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Quote {
        NONE('\u0000'),
        SINGLE('\''),
        DOUBLE('\"'),
        LITERAL('|'),
        FOLDED('>');

        char c;

        private Quote(char c2) {
            this.c = c2;
        }

        public char getStyle() {
            return this.c;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WriteClassName {
        ALWAYS,
        NEVER,
        AUTO;

    }

    static class ConstructorParameters {
        public Constructor constructor;
        public String[] parameterNames;

        ConstructorParameters() {
        }
    }

    public static class ReadConfig {
        Version defaultVersion = Version.DEFAULT_VERSION;
        ClassLoader classLoader;
        final Map<Class, ConstructorParameters> constructorParameters = new IdentityHashMap<Class, ConstructorParameters>();
        boolean ignoreUnknownProperties;
        boolean autoMerge = true;
        boolean classTags = false;
        boolean guessNumberTypes;
        boolean anchors = false;

        ReadConfig() {
        }

        public void setDefaultVersion(Version version) {
            if (version == null) {
                throw new IllegalArgumentException("defaultVersion cannot be null.");
            }
            this.defaultVersion = version;
        }

        public void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public void setConstructorParameters(Class clazz, Class[] classArray, String[] stringArray) {
            if (clazz == null) {
                throw new IllegalArgumentException("type cannot be null.");
            }
            if (classArray == null) {
                throw new IllegalArgumentException("parameterTypes cannot be null.");
            }
            if (stringArray == null) {
                throw new IllegalArgumentException("parameterNames cannot be null.");
            }
            ConstructorParameters constructorParameters = new ConstructorParameters();
            try {
                constructorParameters.constructor = clazz.getConstructor(classArray);
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                throw new IllegalArgumentException("Unable to find constructor: " + clazz.getName() + "(" + Arrays.toString(classArray) + ")", exception2);
            }
            constructorParameters.parameterNames = stringArray;
            this.constructorParameters.put(clazz, constructorParameters);
        }

        public void setIgnoreUnknownProperties(boolean bl2) {
            this.ignoreUnknownProperties = bl2;
        }

        public void setClassTags(boolean bl2) {
            if (bl2) {
                throw new IllegalArgumentException("Class Tags cannot be enabled in YamlConfig, use UnsafeYamlConfig instead.");
            }
        }

        public void setAutoMerge(boolean bl2) {
            this.autoMerge = bl2;
        }

        public void setGuessNumberTypes(boolean bl2) {
            this.guessNumberTypes = bl2;
        }

        public void setAnchors(boolean bl2) {
            if (bl2) {
                throw new IllegalArgumentException("Anchors cannot be enabled in YamlConfig, use UnsafeYamlConfig instead.");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WriteConfig {
        boolean explicitFirstDocument = false;
        boolean explicitEndDocument = false;
        boolean writeDefaultValues = false;
        boolean writeRootTags = true;
        boolean writeRootElementTags = true;
        boolean autoAnchor = false;
        boolean keepBeanPropertyOrder = false;
        WriteClassName writeClassName = WriteClassName.NEVER;
        Quote quote = Quote.NONE;
        Version version;
        Map<String, String> tags;
        boolean flowStyle;
        EmitterConfig emitterConfig = new EmitterConfig();

        WriteConfig() {
            this.emitterConfig.setUseVerbatimTags(false);
        }

        public void setExplicitFirstDocument(boolean bl2) {
            this.explicitFirstDocument = bl2;
        }

        public void setExplicitEndDocument(boolean bl2) {
            this.explicitEndDocument = bl2;
        }

        public void setWriteRootTags(boolean bl2) {
            this.writeRootTags = bl2;
        }

        public void setWriteRootElementTags(boolean bl2) {
            this.writeRootElementTags = bl2;
        }

        public void setWriteDefaultValues(boolean bl2) {
            this.writeDefaultValues = bl2;
        }

        public void setAutoAnchor(boolean bl2) {
            this.autoAnchor = bl2;
        }

        public void setKeepBeanPropertyOrder(boolean bl2) {
            this.keepBeanPropertyOrder = bl2;
        }

        public void setVersion(Version version) {
            this.version = version;
        }

        public void setTags(Map<String, String> map) {
            this.tags = map;
        }

        public void setCanonical(boolean bl2) {
            this.emitterConfig.setCanonical(bl2);
        }

        public void setIndentSize(int n2) {
            this.emitterConfig.setIndentSize(n2);
        }

        public void setWrapColumn(int n2) {
            this.emitterConfig.setWrapColumn(n2);
        }

        public void setUseVerbatimTags(boolean bl2) {
            this.emitterConfig.setUseVerbatimTags(bl2);
        }

        public void setEscapeUnicode(boolean bl2) {
            this.emitterConfig.setEscapeUnicode(bl2);
        }

        public void setWriteClassname(WriteClassName writeClassName) {
            this.writeClassName = writeClassName;
        }

        public void setQuoteChar(Quote quote) {
            this.quote = quote;
        }

        public Quote getQuote() {
            return this.quote;
        }

        public void setFlowStyle(boolean bl2) {
            this.flowStyle = bl2;
        }

        public boolean isFlowStyle() {
            return this.flowStyle;
        }

        public void setPrettyFlow(boolean bl2) {
            this.emitterConfig.setPrettyFlow(bl2);
        }
    }
}

