/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.client.impl.nio;

import com.contrastsecurity.thirdparty.crmq.client.impl.nio.NioHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SslEngineHelper {
    public static boolean doHandshake(SocketChannel socketChannel, SSLEngine sSLEngine) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(sSLEngine.getSession().getApplicationBufferSize());
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(sSLEngine.getSession().getApplicationBufferSize());
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(sSLEngine.getSession().getPacketBufferSize());
        ByteBuffer byteBuffer4 = ByteBuffer.allocate(sSLEngine.getSession().getPacketBufferSize());
        SSLEngineResult.HandshakeStatus handshakeStatus = sSLEngine.getHandshakeStatus();
        while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            switch (handshakeStatus) {
                case NEED_TASK: {
                    handshakeStatus = SslEngineHelper.runDelegatedTasks(sSLEngine);
                    break;
                }
                case NEED_UNWRAP: {
                    handshakeStatus = SslEngineHelper.unwrap(byteBuffer4, byteBuffer2, socketChannel, sSLEngine);
                    break;
                }
                case NEED_WRAP: {
                    handshakeStatus = SslEngineHelper.wrap(byteBuffer, byteBuffer3, socketChannel, sSLEngine);
                }
            }
        }
        return true;
    }

    private static SSLEngineResult.HandshakeStatus runDelegatedTasks(SSLEngine sSLEngine) {
        Runnable runnable;
        while ((runnable = sSLEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return sSLEngine.getHandshakeStatus();
    }

    private static SSLEngineResult.HandshakeStatus unwrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ReadableByteChannel readableByteChannel, SSLEngine sSLEngine) throws IOException {
        SSLEngineResult.HandshakeStatus handshakeStatus = sSLEngine.getHandshakeStatus();
        if (readableByteChannel.read(byteBuffer) < 0) {
            throw new SSLException("Could not read from socket channel");
        }
        byteBuffer.flip();
        do {
            SSLEngineResult sSLEngineResult = sSLEngine.unwrap(byteBuffer, byteBuffer2);
            SSLEngineResult.Status status = sSLEngineResult.getStatus();
            switch (status) {
                case OK: {
                    byteBuffer2.clear();
                    handshakeStatus = SslEngineHelper.runDelegatedTasks(sSLEngine);
                    break;
                }
                case BUFFER_OVERFLOW: {
                    throw new SSLException("Buffer overflow during handshake");
                }
                case BUFFER_UNDERFLOW: {
                    byteBuffer.compact();
                    int n2 = NioHelper.read(readableByteChannel, byteBuffer);
                    if (n2 <= 0) {
                        SslEngineHelper.retryRead(readableByteChannel, byteBuffer);
                    }
                    byteBuffer.flip();
                    break;
                }
                case CLOSED: {
                    sSLEngine.closeInbound();
                    break;
                }
                default: {
                    throw new SSLException("Unexpected status from " + sSLEngineResult);
                }
            }
        } while (byteBuffer.hasRemaining());
        byteBuffer.compact();
        return handshakeStatus;
    }

    private static int retryRead(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
        int n2 = 0;
        for (int i2 = 0; i2 < 3; ++i2) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            n2 = NioHelper.read(readableByteChannel, byteBuffer);
            if (n2 > 0) break;
        }
        return n2;
    }

    private static SSLEngineResult.HandshakeStatus wrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, WritableByteChannel writableByteChannel, SSLEngine sSLEngine) throws IOException {
        SSLEngineResult.HandshakeStatus handshakeStatus = sSLEngine.getHandshakeStatus();
        SSLEngineResult.Status status = sSLEngine.wrap(byteBuffer, byteBuffer2).getStatus();
        switch (status) {
            case OK: {
                handshakeStatus = SslEngineHelper.runDelegatedTasks(sSLEngine);
                byteBuffer2.flip();
                while (byteBuffer2.hasRemaining()) {
                    writableByteChannel.write(byteBuffer2);
                }
                byteBuffer2.clear();
                break;
            }
            case BUFFER_OVERFLOW: {
                throw new SSLException("Buffer overflow during handshake");
            }
            default: {
                throw new SSLException("Unexpected status " + (Object)((Object)status));
            }
        }
        return handshakeStatus;
    }

    static int bufferCopy(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n2 = Math.min(byteBuffer2.remaining(), byteBuffer.remaining());
        ByteBuffer byteBuffer3 = byteBuffer.duplicate();
        byteBuffer3.limit(byteBuffer3.position() + n2);
        byteBuffer2.put(byteBuffer3);
        byteBuffer.position(byteBuffer.position() + n2);
        return n2;
    }

    public static void write(WritableByteChannel writableByteChannel, SSLEngine sSLEngine, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
        block6: while (byteBuffer.hasRemaining()) {
            byteBuffer2.clear();
            SSLEngineResult sSLEngineResult = sSLEngine.wrap(byteBuffer, byteBuffer2);
            switch (sSLEngineResult.getStatus()) {
                case OK: {
                    byteBuffer2.flip();
                    while (byteBuffer2.hasRemaining()) {
                        writableByteChannel.write(byteBuffer2);
                    }
                    continue block6;
                }
                case BUFFER_OVERFLOW: {
                    throw new SSLException("Buffer overflow occured after a wrap.");
                }
                case BUFFER_UNDERFLOW: {
                    throw new SSLException("Buffer underflow occured after a wrap.");
                }
                case CLOSED: {
                    throw new SSLException("Buffer closed");
                }
            }
            throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)sSLEngineResult.getStatus()));
        }
    }

    public static void close(WritableByteChannel writableByteChannel, SSLEngine sSLEngine) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(sSLEngine.getSession().getApplicationBufferSize());
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(sSLEngine.getSession().getPacketBufferSize());
        sSLEngine.closeOutbound();
        while (!sSLEngine.isOutboundDone()) {
            int n2;
            sSLEngine.wrap(byteBuffer, byteBuffer2);
            byteBuffer2.flip();
            while (byteBuffer2.hasRemaining() && (n2 = writableByteChannel.write(byteBuffer2)) != -1) {
            }
            byteBuffer2.clear();
        }
    }
}

