/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dfs;

import com.contrastsecurity.thirdparty.dfs.AsyncExecutionImpl;
import com.contrastsecurity.thirdparty.dfs.Call;
import com.contrastsecurity.thirdparty.dfs.CallImpl;
import com.contrastsecurity.thirdparty.dfs.ExecutionContext;
import com.contrastsecurity.thirdparty.dfs.Functions;
import com.contrastsecurity.thirdparty.dfs.Policy;
import com.contrastsecurity.thirdparty.dfs.SyncExecutionImpl;
import com.contrastsecurity.thirdparty.dfs.event.EventListener;
import com.contrastsecurity.thirdparty.dfs.event.ExecutionCompletedEvent;
import com.contrastsecurity.thirdparty.dfs.function.AsyncRunnable;
import com.contrastsecurity.thirdparty.dfs.function.CheckedRunnable;
import com.contrastsecurity.thirdparty.dfs.function.CheckedSupplier;
import com.contrastsecurity.thirdparty.dfs.function.ContextualRunnable;
import com.contrastsecurity.thirdparty.dfs.function.ContextualSupplier;
import com.contrastsecurity.thirdparty.dfs.internal.EventHandler;
import com.contrastsecurity.thirdparty.dfs.internal.util.Assert;
import com.contrastsecurity.thirdparty.dfs.spi.AsyncExecutionInternal;
import com.contrastsecurity.thirdparty.dfs.spi.ExecutionResult;
import com.contrastsecurity.thirdparty.dfs.spi.FailsafeFuture;
import com.contrastsecurity.thirdparty.dfs.spi.Scheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class FailsafeExecutor<R> {
    private Scheduler scheduler = Scheduler.DEFAULT;
    private Executor executor;
    final List<? extends Policy<R>> policies;
    private volatile EventHandler<R> completeHandler;
    private volatile EventHandler<R> failureHandler;
    private volatile EventHandler<R> successHandler;
    final BiConsumer<ExecutionResult<R>, ExecutionContext<R>> completionHandler = (executionResult, executionContext) -> {
        if (this.successHandler != null && executionResult.getSuccessAll()) {
            this.successHandler.handle((ExecutionResult<R>)executionResult, (ExecutionContext<R>)executionContext);
        } else if (this.failureHandler != null && !executionResult.getSuccessAll()) {
            this.failureHandler.handle((ExecutionResult<R>)executionResult, (ExecutionContext<R>)executionContext);
        }
        if (this.completeHandler != null) {
            this.completeHandler.handle((ExecutionResult<R>)executionResult, (ExecutionContext<R>)executionContext);
        }
    };

    FailsafeExecutor(List<? extends Policy<R>> list) {
        this.policies = list;
    }

    public List<? extends Policy<R>> getPolicies() {
        return this.policies;
    }

    public <P extends Policy<R>> FailsafeExecutor<R> compose(P p2) {
        Assert.notNull(p2, "innerPolicy");
        ArrayList<Policy<R>> arrayList = new ArrayList<Policy<R>>(this.policies);
        arrayList.add(p2);
        return new FailsafeExecutor<R>(arrayList);
    }

    public <T extends R> T get(CheckedSupplier<T> checkedSupplier) {
        return (T)this.call(Functions.toCtxSupplier(checkedSupplier));
    }

    public <T extends R> T get(ContextualSupplier<T, T> contextualSupplier) {
        return this.call(Assert.notNull(contextualSupplier, "supplier"));
    }

    public Call<Void> newCall(ContextualRunnable<Void> contextualRunnable) {
        return this.callSync(Functions.toCtxSupplier(contextualRunnable));
    }

    public <T extends R> Call<T> newCall(ContextualSupplier<T, T> contextualSupplier) {
        return this.callSync(Assert.notNull(contextualSupplier, "supplier"));
    }

    public <T extends R> CompletableFuture<T> getAsync(CheckedSupplier<T> checkedSupplier) {
        return this.callAsync(failsafeFuture -> Functions.getPromise(Functions.toCtxSupplier(checkedSupplier), this.executor), false);
    }

    public <T extends R> CompletableFuture<T> getAsync(ContextualSupplier<T, T> contextualSupplier) {
        return this.callAsync(failsafeFuture -> Functions.getPromise(contextualSupplier, this.executor), false);
    }

    public <T extends R> CompletableFuture<T> getAsyncExecution(AsyncRunnable<T> asyncRunnable) {
        return this.callAsync(failsafeFuture -> Functions.getPromiseExecution(asyncRunnable, this.executor), true);
    }

    public <T extends R> CompletableFuture<T> getStageAsync(CheckedSupplier<? extends CompletionStage<T>> checkedSupplier) {
        return this.callAsync(failsafeFuture -> Functions.getPromiseOfStage(Functions.toCtxSupplier(checkedSupplier), failsafeFuture, this.executor), false);
    }

    public <T extends R> CompletableFuture<T> getStageAsync(ContextualSupplier<T, ? extends CompletionStage<T>> contextualSupplier) {
        return this.callAsync(failsafeFuture -> Functions.getPromiseOfStage(contextualSupplier, failsafeFuture, this.executor), false);
    }

    public void run(CheckedRunnable checkedRunnable) {
        this.call(Functions.toCtxSupplier(checkedRunnable));
    }

    public void run(ContextualRunnable<Void> contextualRunnable) {
        this.call(Functions.toCtxSupplier(contextualRunnable));
    }

    public CompletableFuture<Void> runAsync(CheckedRunnable checkedRunnable) {
        return this.callAsync(failsafeFuture -> Functions.getPromise(Functions.toCtxSupplier(checkedRunnable), this.executor), false);
    }

    public CompletableFuture<Void> runAsync(ContextualRunnable<Void> contextualRunnable) {
        return this.callAsync(failsafeFuture -> Functions.getPromise(Functions.toCtxSupplier(contextualRunnable), this.executor), false);
    }

    public CompletableFuture<Void> runAsyncExecution(AsyncRunnable<Void> asyncRunnable) {
        return this.callAsync(failsafeFuture -> Functions.getPromiseExecution(asyncRunnable, this.executor), true);
    }

    public FailsafeExecutor<R> onComplete(EventListener<ExecutionCompletedEvent<R>> eventListener) {
        this.completeHandler = EventHandler.ofExecutionCompleted(Assert.notNull(eventListener, "listener"));
        return this;
    }

    public FailsafeExecutor<R> onFailure(EventListener<ExecutionCompletedEvent<R>> eventListener) {
        this.failureHandler = EventHandler.ofExecutionCompleted(Assert.notNull(eventListener, "listener"));
        return this;
    }

    public FailsafeExecutor<R> onSuccess(EventListener<ExecutionCompletedEvent<R>> eventListener) {
        this.successHandler = EventHandler.ofExecutionCompleted(Assert.notNull(eventListener, "listener"));
        return this;
    }

    public FailsafeExecutor<R> with(ScheduledExecutorService scheduledExecutorService) {
        this.scheduler = Scheduler.of(Assert.notNull(scheduledExecutorService, "scheduledExecutorService"));
        return this;
    }

    public FailsafeExecutor<R> with(ExecutorService executorService) {
        this.scheduler = Scheduler.of(Assert.notNull(executorService, "executorService"));
        return this;
    }

    public FailsafeExecutor<R> with(Executor executor) {
        Assert.notNull(executor, "executor");
        if (executor instanceof ExecutorService) {
            this.with((ExecutorService)executor);
        } else {
            this.executor = executor;
        }
        return this;
    }

    public FailsafeExecutor<R> with(Scheduler scheduler) {
        this.scheduler = Assert.notNull(scheduler, "scheduler");
        return this;
    }

    private <T> T call(ContextualSupplier<T, T> contextualSupplier) {
        SyncExecutionImpl syncExecutionImpl = new SyncExecutionImpl(this, this.scheduler, null, Functions.get(contextualSupplier, this.executor));
        return (T)syncExecutionImpl.executeSync();
    }

    private <T> Call<T> callSync(ContextualSupplier<T, T> contextualSupplier) {
        CallImpl callImpl = new CallImpl();
        new SyncExecutionImpl(this, this.scheduler, callImpl, Functions.get(contextualSupplier, this.executor));
        return callImpl;
    }

    private <T> CompletableFuture<T> callAsync(Function<FailsafeFuture<T>, Function<AsyncExecutionInternal<T>, CompletableFuture<ExecutionResult<T>>>> function, boolean bl2) {
        FailsafeFuture failsafeFuture = new FailsafeFuture(this.completionHandler);
        AsyncExecutionImpl asyncExecutionImpl = new AsyncExecutionImpl(this.policies, this.scheduler, failsafeFuture, bl2, function.apply(failsafeFuture));
        failsafeFuture.setExecution(asyncExecutionImpl);
        asyncExecutionImpl.executeAsync();
        return failsafeFuture;
    }
}

