/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.grpc;

import com.contrastsecurity.thirdparty.imm.core.instrument.binder.grpc.GrpcObservationDocumentation;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.grpc.GrpcServerObservationContext;
import com.contrastsecurity.thirdparty.imm.observation.Observation;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;

class ObservationGrpcServerCall<ReqT, RespT>
extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
    private final Observation.Scope scope;

    ObservationGrpcServerCall(ServerCall<ReqT, RespT> serverCall, Observation.Scope scope) {
        super(serverCall);
        this.scope = scope;
    }

    public void sendMessage(RespT RespT) {
        this.scope.getCurrentObservation().event(GrpcObservationDocumentation.GrpcServerEvents.MESSAGE_SENT);
        super.sendMessage(RespT);
    }

    public void close(Status status, Metadata metadata) {
        Observation observation = this.scope.getCurrentObservation();
        if (status.getCause() != null) {
            observation.error(status.getCause());
        }
        GrpcServerObservationContext grpcServerObservationContext = (GrpcServerObservationContext)observation.getContext();
        grpcServerObservationContext.setStatusCode(status.getCode());
        this.scope.close();
        observation.stop();
        super.close(status, metadata);
    }
}

