/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.httpcomponents.hc5;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.http.Outcome;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientContext;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientObservationConvention;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.httpcomponents.hc5.DefaultApacheHttpClientObservationConvention;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.httpcomponents.hc5.DefaultUriMapper;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.httpcomponents.hc5.HttpContextUtils;
import com.contrastsecurity.thirdparty.imm.core.instrument.observation.ObservationOrTimerCompatibleInstrumentation;
import com.contrastsecurity.thirdparty.imm.observation.ObservationRegistry;
import com.contrastsecurity.thirdparty.oa4j.hc.core5.http.ClassicHttpRequest;
import com.contrastsecurity.thirdparty.oa4j.hc.core5.http.ClassicHttpResponse;
import com.contrastsecurity.thirdparty.oa4j.hc.core5.http.HttpException;
import com.contrastsecurity.thirdparty.oa4j.hc.core5.http.HttpRequest;
import com.contrastsecurity.thirdparty.oa4j.hc.core5.http.HttpResponse;
import com.contrastsecurity.thirdparty.oa4j.hc.core5.http.impl.io.HttpRequestExecutor;
import com.contrastsecurity.thirdparty.oa4j.hc.core5.http.io.HttpClientConnection;
import com.contrastsecurity.thirdparty.oa4j.hc.core5.http.protocol.HttpContext;
import com.contrastsecurity.thirdparty.oa4j.hc.core5.util.Timeout;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;

public class MicrometerHttpRequestExecutor
extends HttpRequestExecutor {
    static final String METER_NAME = "httpcomponents.httpclient.request";
    private final MeterRegistry registry;
    private final ObservationRegistry observationRegistry;
    @Nullable
    private final ApacheHttpClientObservationConvention convention;
    private final Function<HttpRequest, String> uriMapper;
    private final Iterable<Tag> extraTags;
    private final boolean exportTagsForRoute;

    private MicrometerHttpRequestExecutor(Timeout timeout, MeterRegistry meterRegistry, Function<HttpRequest, String> function, Iterable<Tag> iterable, boolean bl2, ObservationRegistry observationRegistry, @Nullable ApacheHttpClientObservationConvention apacheHttpClientObservationConvention) {
        super(timeout, null, null);
        this.registry = Optional.ofNullable(meterRegistry).orElseThrow(() -> new IllegalArgumentException("registry is required but has been initialized with null"));
        this.uriMapper = Optional.ofNullable(function).orElseThrow(() -> new IllegalArgumentException("uriMapper is required but has been initialized with null"));
        this.extraTags = Optional.ofNullable(iterable).orElse(Collections.emptyList());
        this.exportTagsForRoute = bl2;
        this.observationRegistry = observationRegistry;
        this.convention = apacheHttpClientObservationConvention;
    }

    public static Builder builder(MeterRegistry meterRegistry) {
        return new Builder(meterRegistry);
    }

    public ClassicHttpResponse execute(ClassicHttpRequest classicHttpRequest, HttpClientConnection httpClientConnection, HttpContext httpContext) throws IOException, HttpException {
        ObservationOrTimerCompatibleInstrumentation<ApacheHttpClientContext> observationOrTimerCompatibleInstrumentation = ObservationOrTimerCompatibleInstrumentation.start(this.registry, this.observationRegistry, () -> new ApacheHttpClientContext((HttpRequest)classicHttpRequest, httpContext, this.uriMapper, this.exportTagsForRoute), this.convention, DefaultApacheHttpClientObservationConvention.INSTANCE);
        String string = "UNKNOWN";
        Outcome outcome = Outcome.UNKNOWN;
        try {
            ClassicHttpResponse classicHttpResponse = super.execute(classicHttpRequest, httpClientConnection, httpContext);
            observationOrTimerCompatibleInstrumentation.setResponse(classicHttpResponse);
            string = DefaultApacheHttpClientObservationConvention.INSTANCE.getStatusValue((HttpResponse)classicHttpResponse, null);
            outcome = DefaultApacheHttpClientObservationConvention.INSTANCE.getStatusOutcome((HttpResponse)classicHttpResponse);
            ClassicHttpResponse classicHttpResponse2 = classicHttpResponse;
            return classicHttpResponse2;
        }
        catch (HttpException | IOException | RuntimeException throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            string = "IO_ERROR";
            observationOrTimerCompatibleInstrumentation.setThrowable(throwable2);
            throw throwable2;
        }
        finally {
            String string2 = string;
            String string3 = outcome.name();
            observationOrTimerCompatibleInstrumentation.stop(METER_NAME, "Duration of Apache HttpClient request execution", () -> Tags.of("method", DefaultApacheHttpClientObservationConvention.INSTANCE.getMethodString((HttpRequest)classicHttpRequest), "uri", this.uriMapper.apply((HttpRequest)classicHttpRequest), "status", string2, "outcome", string3).and(this.exportTagsForRoute ? HttpContextUtils.generateTagsForRoute(httpContext) : Tags.empty()).and(this.extraTags));
        }
    }

    public static class Builder {
        private final MeterRegistry registry;
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;
        private Timeout waitForContinue = HttpRequestExecutor.DEFAULT_WAIT_FOR_CONTINUE;
        private Iterable<Tag> extraTags = Collections.emptyList();
        private Function<HttpRequest, String> uriMapper = new DefaultUriMapper();
        private boolean exportTagsForRoute = false;
        @Nullable
        private ApacheHttpClientObservationConvention observationConvention;

        Builder(MeterRegistry meterRegistry) {
            this.registry = meterRegistry;
        }

        public Builder waitForContinue(Timeout timeout) {
            this.waitForContinue = timeout;
            return this;
        }

        public Builder tags(Iterable<Tag> iterable) {
            this.extraTags = iterable;
            return this;
        }

        public Builder uriMapper(Function<HttpRequest, String> function) {
            this.uriMapper = function;
            return this;
        }

        public Builder exportTagsForRoute(boolean bl2) {
            this.exportTagsForRoute = bl2;
            return this;
        }

        public Builder observationRegistry(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
            return this;
        }

        public Builder observationConvention(ApacheHttpClientObservationConvention apacheHttpClientObservationConvention) {
            this.observationConvention = apacheHttpClientObservationConvention;
            return this;
        }

        public MicrometerHttpRequestExecutor build() {
            return new MicrometerHttpRequestExecutor(this.waitForContinue, this.registry, this.uriMapper, this.extraTags, this.exportTagsForRoute, this.observationRegistry, this.observationConvention);
        }
    }
}

