/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.netty4;

import com.contrastsecurity.thirdparty.imm.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.MeterBinder;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.netty4.NettyMeters;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.ByteBufAllocatorMetricProvider;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocatorMetric;

public class NettyAllocatorMetrics
implements MeterBinder {
    private final ByteBufAllocatorMetricProvider allocator;

    public NettyAllocatorMetrics(ByteBufAllocatorMetricProvider byteBufAllocatorMetricProvider) {
        this.allocator = byteBufAllocatorMetricProvider;
    }

    @Override
    public void bindTo(MeterRegistry meterRegistry) {
        int n2 = this.allocator.hashCode();
        ByteBufAllocatorMetric byteBufAllocatorMetric = this.allocator.metric();
        Tags tags = Tags.of(NettyMeters.AllocatorKeyNames.ID.asString(), String.valueOf(n2), NettyMeters.AllocatorKeyNames.ALLOCATOR_TYPE.asString(), this.allocator.getClass().getSimpleName());
        Gauge.builder(NettyMeters.ALLOCATOR_MEMORY_USED.getName(), byteBufAllocatorMetric, ByteBufAllocatorMetric::usedHeapMemory).tags(tags.and(NettyMeters.AllocatorMemoryKeyNames.MEMORY_TYPE.asString(), "heap")).register(meterRegistry);
        Gauge.builder(NettyMeters.ALLOCATOR_MEMORY_USED.getName(), byteBufAllocatorMetric, ByteBufAllocatorMetric::usedDirectMemory).tags(tags.and(NettyMeters.AllocatorMemoryKeyNames.MEMORY_TYPE.asString(), "direct")).register(meterRegistry);
        if (this.allocator instanceof PooledByteBufAllocator) {
            PooledByteBufAllocator pooledByteBufAllocator = (PooledByteBufAllocator)this.allocator;
            PooledByteBufAllocatorMetric pooledByteBufAllocatorMetric = pooledByteBufAllocator.metric();
            Gauge.builder(NettyMeters.ALLOCATOR_MEMORY_PINNED.getName(), pooledByteBufAllocator, PooledByteBufAllocator::pinnedHeapMemory).tags(tags.and(NettyMeters.AllocatorMemoryKeyNames.MEMORY_TYPE.asString(), "heap")).register(meterRegistry);
            Gauge.builder(NettyMeters.ALLOCATOR_MEMORY_PINNED.getName(), pooledByteBufAllocator, PooledByteBufAllocator::pinnedDirectMemory).tags(tags.and(NettyMeters.AllocatorMemoryKeyNames.MEMORY_TYPE.asString(), "direct")).register(meterRegistry);
            Gauge.builder(NettyMeters.ALLOCATOR_POOLED_ARENAS.getName(), pooledByteBufAllocatorMetric, PooledByteBufAllocatorMetric::numHeapArenas).tags(tags.and(NettyMeters.AllocatorMemoryKeyNames.MEMORY_TYPE.asString(), "heap")).register(meterRegistry);
            Gauge.builder(NettyMeters.ALLOCATOR_POOLED_ARENAS.getName(), pooledByteBufAllocatorMetric, PooledByteBufAllocatorMetric::numDirectArenas).tags(tags.and(NettyMeters.AllocatorMemoryKeyNames.MEMORY_TYPE.asString(), "direct")).register(meterRegistry);
            Gauge.builder(NettyMeters.ALLOCATOR_POOLED_CACHE_SIZE.getName(), pooledByteBufAllocatorMetric, PooledByteBufAllocatorMetric::normalCacheSize).tags(tags.and(NettyMeters.AllocatorPooledCacheKeyNames.CACHE_TYPE.asString(), "normal")).register(meterRegistry);
            Gauge.builder(NettyMeters.ALLOCATOR_POOLED_CACHE_SIZE.getName(), pooledByteBufAllocatorMetric, PooledByteBufAllocatorMetric::smallCacheSize).tags(tags.and(NettyMeters.AllocatorPooledCacheKeyNames.CACHE_TYPE.asString(), "small")).register(meterRegistry);
            Gauge.builder(NettyMeters.ALLOCATOR_POOLED_THREADLOCAL_CACHES.getName(), pooledByteBufAllocatorMetric, PooledByteBufAllocatorMetric::numThreadLocalCaches).tags(tags).register(meterRegistry);
            Gauge.builder(NettyMeters.ALLOCATOR_POOLED_CHUNK_SIZE.getName(), pooledByteBufAllocatorMetric, PooledByteBufAllocatorMetric::chunkSize).tags(tags).register(meterRegistry);
        }
    }
}

