/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.ipc.http;

import com.contrastsecurity.thirdparty.imm.core.ipc.http.HttpSender;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class OkHttpSender
implements HttpSender {
    private static final MediaType MEDIA_TYPE_APPLICATION_JSON = MediaType.get((String)"application/json; charset=utf-8");
    private static final MediaType MEDIA_TYPE_TEXT_PLAIN = MediaType.get((String)"text/plain; charset=utf-8");
    private final OkHttpClient client;

    public OkHttpSender(OkHttpClient okHttpClient) {
        this.client = okHttpClient;
    }

    public OkHttpSender() {
        this(new OkHttpClient());
    }

    @Override
    public HttpSender.Response send(HttpSender.Request request) throws Throwable {
        String string;
        Request.Builder builder = new Request.Builder().url(request.getUrl());
        for (Map.Entry<String, String> object2 : request.getRequestHeaders().entrySet()) {
            builder.addHeader(object2.getKey(), object2.getValue());
        }
        Object object3 = request.getEntity();
        HttpSender.Method method = request.getMethod();
        String string2 = method.toString();
        if (((Object)object3).length > 0) {
            string = request.getRequestHeaders().get("Content-Type");
            MediaType mediaType = string != null ? MediaType.get((String)(string + "; charset=utf-8")) : MEDIA_TYPE_APPLICATION_JSON;
            RequestBody requestBody = RequestBody.create((byte[])object3, (MediaType)mediaType);
            builder.method(string2, requestBody);
        } else if (OkHttpSender.requiresRequestBody(method)) {
            string = RequestBody.create((byte[])object3, (MediaType)MEDIA_TYPE_TEXT_PLAIN);
            builder.method(string2, (RequestBody)string);
        } else {
            builder.method(string2, null);
        }
        string = this.client.newCall(builder.build()).execute();
        return new HttpSender.Response(string.code(), string.body() == null ? null : string.body().string());
    }

    private static boolean requiresRequestBody(HttpSender.Method method) {
        switch (method) {
            case POST: 
            case PUT: {
                return true;
            }
        }
        return false;
    }
}

