/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.api.trace;

import com.contrastsecurity.thirdparty.iot.api.internal.ApiUsageLogger;
import com.contrastsecurity.thirdparty.iot.api.internal.OtelEncodingUtils;
import com.contrastsecurity.thirdparty.iot.api.internal.TemporaryBuffers;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SpanId {
    private static final int BYTES_LENGTH = 8;
    private static final int HEX_LENGTH = 16;
    private static final String INVALID = "0000000000000000";

    private SpanId() {
    }

    public static int getLength() {
        return 16;
    }

    public static String getInvalid() {
        return INVALID;
    }

    public static boolean isValid(CharSequence charSequence) {
        return charSequence != null && charSequence.length() == 16 && !INVALID.contentEquals(charSequence) && OtelEncodingUtils.isValidBase16String(charSequence);
    }

    public static String fromBytes(byte[] byArray) {
        if (byArray == null || byArray.length < 8) {
            ApiUsageLogger.log("spanIdBytes is null or too short");
            return INVALID;
        }
        char[] cArray = TemporaryBuffers.chars(16);
        OtelEncodingUtils.bytesToBase16(byArray, cArray, 8);
        return new String(cArray, 0, 16);
    }

    public static String fromLong(long l2) {
        if (l2 == 0L) {
            return SpanId.getInvalid();
        }
        char[] cArray = TemporaryBuffers.chars(16);
        OtelEncodingUtils.longToBase16String(l2, cArray, 0);
        return new String(cArray, 0, 16);
    }
}

