/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.metrics.export;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.iot.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.Aggregation;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.InstrumentType;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.AggregationTemporality;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.MetricData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.export.CollectionRegistration;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.export.MetricExporter;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.export.MetricReader;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.export.PeriodicMetricReaderBuilder;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.export.MetricProducer;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public final class PeriodicMetricReader
implements MetricReader {
    private static final e logger = e.a(PeriodicMetricReader.class.getName());
    private final MetricExporter exporter;
    private final long intervalNanos;
    private final ScheduledExecutorService scheduler;
    private final Scheduled scheduled;
    private final Object lock = new Object();
    private volatile MetricProducer metricProducer = MetricProducer.noop();
    @Nullable
    private volatile ScheduledFuture<?> scheduledFuture;

    public static PeriodicMetricReader create(MetricExporter metricExporter) {
        return PeriodicMetricReader.builder(metricExporter).build();
    }

    public static PeriodicMetricReaderBuilder builder(MetricExporter metricExporter) {
        return new PeriodicMetricReaderBuilder(metricExporter);
    }

    PeriodicMetricReader(MetricExporter metricExporter, long l2, ScheduledExecutorService scheduledExecutorService) {
        this.exporter = metricExporter;
        this.intervalNanos = l2;
        this.scheduler = scheduledExecutorService;
        this.scheduled = new Scheduled();
    }

    @Override
    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.exporter.getAggregationTemporality(instrumentType);
    }

    @Override
    public Aggregation getDefaultAggregation(InstrumentType instrumentType) {
        return this.exporter.getDefaultAggregation(instrumentType);
    }

    @Override
    public CompletableResultCode forceFlush() {
        return this.scheduled.doRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableResultCode shutdown() {
        CompletableResultCode completableResultCode = new CompletableResultCode();
        ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.scheduler.shutdown();
        try {
            this.scheduler.awaitTermination(5L, TimeUnit.SECONDS);
            CompletableResultCode completableResultCode2 = this.scheduled.doRun();
            completableResultCode2.join(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
        finally {
            CompletableResultCode completableResultCode3 = this.scheduled.shutdown();
            completableResultCode3.whenComplete(() -> {
                if (!completableResultCode3.isSuccess()) {
                    completableResultCode.fail();
                } else {
                    completableResultCode.succeed();
                }
            });
        }
        return completableResultCode;
    }

    @Override
    public void register(CollectionRegistration collectionRegistration) {
        this.metricProducer = MetricProducer.asMetricProducer(collectionRegistration);
        this.start();
    }

    public String toString() {
        return "PeriodicMetricReader{exporter=" + this.exporter + ", intervalNanos=" + this.intervalNanos + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.scheduledFuture != null) {
                return;
            }
            this.scheduledFuture = this.scheduler.scheduleAtFixedRate(this.scheduled, this.intervalNanos, this.intervalNanos, TimeUnit.NANOSECONDS);
        }
    }

    private final class Scheduled
    implements Runnable {
        private final AtomicBoolean exportAvailable = new AtomicBoolean(true);

        private Scheduled() {
        }

        @Override
        public void run() {
            this.doRun();
        }

        CompletableResultCode doRun() {
            CompletableResultCode completableResultCode;
            block5: {
                completableResultCode = new CompletableResultCode();
                if (this.exportAvailable.compareAndSet(true, false)) {
                    try {
                        Collection<MetricData> collection = PeriodicMetricReader.this.metricProducer.collectAllMetrics();
                        if (collection.isEmpty()) {
                            logger.a(e.a.f, "No metric data to export - skipping export.");
                            completableResultCode.succeed();
                            this.exportAvailable.set(true);
                            break block5;
                        }
                        CompletableResultCode completableResultCode2 = PeriodicMetricReader.this.exporter.export(collection);
                        completableResultCode2.whenComplete(() -> {
                            if (!completableResultCode2.isSuccess()) {
                                logger.a(e.a.f, "Exporter failed");
                            }
                            completableResultCode.succeed();
                            this.exportAvailable.set(true);
                        });
                    }
                    catch (Throwable throwable) {
                        Throwables.throwIfCritical(throwable);
                        Throwable throwable2 = throwable;
                        this.exportAvailable.set(true);
                        logger.a(e.a.c, "Exporter threw an Exception", throwable2);
                        completableResultCode.fail();
                    }
                } else {
                    logger.a(e.a.f, "Exporter busy. Dropping metrics.");
                    completableResultCode.fail();
                }
            }
            return completableResultCode;
        }

        CompletableResultCode shutdown() {
            return PeriodicMetricReader.this.exporter.shutdown();
        }
    }
}

