/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.aggregator;

import com.contrastsecurity.thirdparty.iot.api.common.Attributes;
import com.contrastsecurity.thirdparty.iot.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.AggregationTemporality;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.DoubleExemplarData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.DoublePointData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.MetricData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.aggregator.AbstractSumAggregator;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.aggregator.AggregatorHandle;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.concurrent.AdderUtil;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.concurrent.DoubleAdder;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.data.ImmutableDoublePointData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.data.ImmutableMetricData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.data.ImmutableSumData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.descriptor.MetricDescriptor;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.exemplar.ExemplarReservoir;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.state.Measurement;
import com.contrastsecurity.thirdparty.iot.sdk.resources.Resource;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;

public final class DoubleSumAggregator
extends AbstractSumAggregator<DoublePointData, DoubleExemplarData> {
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;

    public DoubleSumAggregator(InstrumentDescriptor instrumentDescriptor, Supplier<ExemplarReservoir<DoubleExemplarData>> supplier) {
        super(instrumentDescriptor);
        this.reservoirSupplier = supplier;
    }

    @Override
    public AggregatorHandle<DoublePointData, DoubleExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get());
    }

    @Override
    public DoublePointData diff(DoublePointData doublePointData, DoublePointData doublePointData2) {
        return ImmutableDoublePointData.create(doublePointData2.getStartEpochNanos(), doublePointData2.getEpochNanos(), doublePointData2.getAttributes(), doublePointData2.getValue() - doublePointData.getValue(), doublePointData2.getExemplars());
    }

    @Override
    public DoublePointData toPoint(Measurement measurement) {
        return ImmutableDoublePointData.create(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.doubleValue());
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor metricDescriptor, Collection<DoublePointData> collection, AggregationTemporality aggregationTemporality) {
        return ImmutableMetricData.createDoubleSum(resource, instrumentationScopeInfo, metricDescriptor.getName(), metricDescriptor.getDescription(), metricDescriptor.getSourceInstrument().getUnit(), ImmutableSumData.create(this.isMonotonic(), aggregationTemporality, collection));
    }

    static final class Handle
    extends AggregatorHandle<DoublePointData, DoubleExemplarData> {
        private final DoubleAdder current = AdderUtil.createDoubleAdder();

        Handle(ExemplarReservoir<DoubleExemplarData> exemplarReservoir) {
            super(exemplarReservoir);
        }

        @Override
        protected DoublePointData doAggregateThenMaybeReset(long l2, long l3, Attributes attributes, List<DoubleExemplarData> list, boolean bl2) {
            double d2 = bl2 ? this.current.sumThenReset() : this.current.sum();
            return ImmutableDoublePointData.create(l2, l3, attributes, d2, list);
        }

        @Override
        protected void doRecordDouble(double d2) {
            this.current.add(d2);
        }
    }
}

