/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.trace.internal.data;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.cggl.auto.value.AutoValue;
import com.contrastsecurity.thirdparty.cggl.auto.value.extension.memoized.Memoized;
import com.contrastsecurity.thirdparty.iot.api.common.Attributes;
import com.contrastsecurity.thirdparty.iot.api.common.AttributesBuilder;
import com.contrastsecurity.thirdparty.iot.sdk.internal.AttributeUtil;
import com.contrastsecurity.thirdparty.iot.sdk.trace.SpanLimits;
import com.contrastsecurity.thirdparty.iot.sdk.trace.internal.data.AutoValue_ImmutableExceptionEventData;
import com.contrastsecurity.thirdparty.iot.sdk.trace.internal.data.ExceptionEventData;
import com.contrastsecurity.thirdparty.iot.semconv.trace.attributes.SemanticAttributes;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
abstract class ImmutableExceptionEventData
implements ExceptionEventData {
    static ExceptionEventData create(SpanLimits spanLimits, long l2, Throwable throwable, Attributes attributes) {
        return new AutoValue_ImmutableExceptionEventData(l2, throwable, attributes, spanLimits);
    }

    ImmutableExceptionEventData() {
    }

    protected abstract SpanLimits getSpanLimits();

    @Override
    public final String getName() {
        return "exception";
    }

    @Override
    @Memoized
    public Attributes getAttributes() {
        Throwable throwable = this.getException();
        Attributes attributes = this.getAdditionalAttributes();
        AttributesBuilder attributesBuilder = Attributes.builder();
        attributesBuilder.put(SemanticAttributes.EXCEPTION_TYPE, throwable.getClass().getCanonicalName());
        String string = throwable.getMessage();
        if (string != null) {
            attributesBuilder.put(SemanticAttributes.EXCEPTION_MESSAGE, string);
        }
        StringWriter stringWriter = new StringWriter();
        Object object = new PrintWriter(stringWriter);
        try {
            throwable.printStackTrace((PrintWriter)object);
            ((PrintWriter)object).close();
        }
        catch (Throwable throwable2) {
            Throwables.throwIfCritical(throwable2);
            Throwable throwable3 = throwable2;
            try {
                ((PrintWriter)object).close();
            }
            catch (Throwable throwable4) {
                Throwables.throwIfCritical(throwable4);
                Throwable throwable5 = throwable4;
                throwable3.addSuppressed(throwable5);
            }
            throw throwable3;
        }
        attributesBuilder.put(SemanticAttributes.EXCEPTION_STACKTRACE, stringWriter.toString());
        attributesBuilder.putAll(attributes);
        object = this.getSpanLimits();
        return AttributeUtil.applyAttributesLimit(attributesBuilder.build(), ((SpanLimits)object).getMaxNumberOfAttributesPerEvent(), ((SpanLimits)object).getMaxAttributeValueLength());
    }

    @Override
    public final int getTotalAttributeCount() {
        return this.getAttributes().size();
    }
}

