/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.commons.codec.net;

import com.contrastsecurity.thirdparty.oa4j.commons.codec.BinaryDecoder;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.BinaryEncoder;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.DecoderException;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.EncoderException;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.StringDecoder;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.StringEncoder;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.binary.StringUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.net.Utils;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.BitSet;

public class QuotedPrintableCodec
implements BinaryDecoder,
BinaryEncoder,
StringDecoder,
StringEncoder {
    private final Charset charset;
    private final boolean strict;
    private static final BitSet PRINTABLE_CHARS;
    private static final byte ESCAPE_CHAR = 61;
    private static final byte TAB = 9;
    private static final byte SPACE = 32;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final int SAFE_LENGTH = 73;

    public QuotedPrintableCodec() {
        this(StandardCharsets.UTF_8, false);
    }

    public QuotedPrintableCodec(boolean bl2) {
        this(StandardCharsets.UTF_8, bl2);
    }

    public QuotedPrintableCodec(Charset charset) {
        this(charset, false);
    }

    public QuotedPrintableCodec(Charset charset, boolean bl2) {
        this.charset = charset;
        this.strict = bl2;
    }

    public QuotedPrintableCodec(String string) throws IllegalCharsetNameException, IllegalArgumentException, UnsupportedCharsetException {
        this(Charset.forName(string), false);
    }

    private static final int encodeQuotedPrintable(int n2, ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write(61);
        char c2 = Utils.hexDigit(n2 >> 4);
        char c3 = Utils.hexDigit(n2);
        byteArrayOutputStream.write(c2);
        byteArrayOutputStream.write(c3);
        return 3;
    }

    private static int getUnsignedOctet(int n2, byte[] byArray) {
        int n3 = byArray[n2];
        if (n3 < 0) {
            n3 = 256 + n3;
        }
        return n3;
    }

    private static int encodeByte(int n2, boolean bl2, ByteArrayOutputStream byteArrayOutputStream) {
        if (bl2) {
            return QuotedPrintableCodec.encodeQuotedPrintable(n2, byteArrayOutputStream);
        }
        byteArrayOutputStream.write(n2);
        return 1;
    }

    private static boolean isWhitespace(int n2) {
        return n2 == 32 || n2 == 9;
    }

    public static final byte[] encodeQuotedPrintable(BitSet bitSet, byte[] byArray) {
        return QuotedPrintableCodec.encodeQuotedPrintable(bitSet, byArray, false);
    }

    /*
     * WARNING - void declaration
     */
    public static final byte[] encodeQuotedPrintable(BitSet bitSet, byte[] byArray, boolean bl2) {
        if (byArray == null) {
            return null;
        }
        if (bitSet == null) {
            bitSet = PRINTABLE_CHARS;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (bl2) {
            void var7_14;
            boolean bl3;
            int n2;
            int n3 = 1;
            for (n2 = 0; n2 < byArray.length - 3; ++n2) {
                int bl32 = QuotedPrintableCodec.getUnsignedOctet(n2, byArray);
                if (n3 < 73) {
                    n3 += QuotedPrintableCodec.encodeByte(bl32, !bitSet.get(bl32), byteArrayOutputStream);
                    continue;
                }
                QuotedPrintableCodec.encodeByte(bl32, !bitSet.get(bl32) || QuotedPrintableCodec.isWhitespace(bl32), byteArrayOutputStream);
                byteArrayOutputStream.write(61);
                byteArrayOutputStream.write(13);
                byteArrayOutputStream.write(10);
                n3 = 1;
            }
            n2 = QuotedPrintableCodec.getUnsignedOctet(byArray.length - 3, byArray);
            boolean bl4 = bl3 = !bitSet.get(n2) || QuotedPrintableCodec.isWhitespace(n2) && n3 > 68;
            if ((n3 += QuotedPrintableCodec.encodeByte(n2, bl3, byteArrayOutputStream)) > 71) {
                byteArrayOutputStream.write(61);
                byteArrayOutputStream.write(13);
                byteArrayOutputStream.write(10);
            }
            int n4 = byArray.length - 2;
            while (var7_14 < byArray.length) {
                n2 = QuotedPrintableCodec.getUnsignedOctet((int)var7_14, byArray);
                boolean bl5 = !bitSet.get(n2) || var7_14 > byArray.length - 2 && QuotedPrintableCodec.isWhitespace(n2);
                QuotedPrintableCodec.encodeByte(n2, bl5, byteArrayOutputStream);
                ++var7_14;
            }
        } else {
            void var6_12;
            byte[] byArray2 = byArray;
            int n5 = byArray2.length;
            boolean bl6 = false;
            while (var6_12 < n5) {
                int n6 = byArray2[var6_12];
                int n7 = n6;
                if (n7 < 0) {
                    n7 = 256 + n7;
                }
                if (bitSet.get(n7)) {
                    byteArrayOutputStream.write(n7);
                } else {
                    QuotedPrintableCodec.encodeQuotedPrintable(n7, byteArrayOutputStream);
                }
                ++var6_12;
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static final byte[] decodeQuotedPrintable(byte[] byArray) throws DecoderException {
        if (byArray == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte by2 = byArray[i2];
            if (by2 == 61) {
                try {
                    if (byArray[++i2] == 13) continue;
                    int n2 = Utils.digit16(byArray[i2]);
                    int n3 = Utils.digit16(byArray[++i2]);
                    byteArrayOutputStream.write((char)((n2 << 4) + n3));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new DecoderException("Invalid quoted-printable encoding", arrayIndexOutOfBoundsException);
                }
            }
            if (by2 == 13 || by2 == 10) continue;
            byteArrayOutputStream.write(by2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public byte[] encode(byte[] byArray) {
        return QuotedPrintableCodec.encodeQuotedPrintable(PRINTABLE_CHARS, byArray, this.strict);
    }

    @Override
    public byte[] decode(byte[] byArray) throws DecoderException {
        return QuotedPrintableCodec.decodeQuotedPrintable(byArray);
    }

    @Override
    public String encode(String string) throws EncoderException {
        return this.encode(string, this.getCharset());
    }

    public String decode(String string, Charset charset) throws DecoderException {
        if (string == null) {
            return null;
        }
        return new String(this.decode(StringUtils.getBytesUsAscii(string)), charset);
    }

    public String decode(String string, String string2) throws DecoderException, UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        return new String(this.decode(StringUtils.getBytesUsAscii(string)), string2);
    }

    @Override
    public String decode(String string) throws DecoderException {
        return this.decode(string, this.getCharset());
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return this.encode((byte[])object);
        }
        if (object instanceof String) {
            return this.encode((String)object);
        }
        throw new EncoderException("Objects of type " + object.getClass().getName() + " cannot be quoted-printable encoded");
    }

    @Override
    public Object decode(Object object) throws DecoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return this.decode((byte[])object);
        }
        if (object instanceof String) {
            return this.decode((String)object);
        }
        throw new DecoderException("Objects of type " + object.getClass().getName() + " cannot be quoted-printable decoded");
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getDefaultCharset() {
        return this.charset.name();
    }

    public String encode(String string, Charset charset) {
        if (string == null) {
            return null;
        }
        return StringUtils.newStringUsAscii(this.encode(string.getBytes(charset)));
    }

    public String encode(String string, String string2) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        return StringUtils.newStringUsAscii(this.encode(string.getBytes(string2)));
    }

    static {
        int n2;
        PRINTABLE_CHARS = new BitSet(256);
        for (n2 = 33; n2 <= 60; ++n2) {
            PRINTABLE_CHARS.set(n2);
        }
        for (n2 = 62; n2 <= 126; ++n2) {
            PRINTABLE_CHARS.set(n2);
        }
        PRINTABLE_CHARS.set(9);
        PRINTABLE_CHARS.set(32);
    }
}

