/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.commons.lang3;

import com.contrastsecurity.thirdparty.oa4j.commons.lang3.time.DurationUtils;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ThreadUtils {
    @Deprecated
    public static final AlwaysTruePredicate ALWAYS_TRUE_PREDICATE = new AlwaysTruePredicate();
    private static final Predicate<?> ALWAYS_TRUE = object -> true;

    private static <T> Predicate<T> alwaysTruePredicate() {
        return ALWAYS_TRUE;
    }

    public static Thread findThreadById(long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("The thread id must be greater than zero");
        }
        Collection<Thread> collection = ThreadUtils.findThreads((Thread thread) -> thread != null && thread.getId() == l2);
        return collection.isEmpty() ? null : collection.iterator().next();
    }

    public static Thread findThreadById(long l2, String string) {
        Objects.requireNonNull(string, "threadGroupName");
        Thread thread = ThreadUtils.findThreadById(l2);
        if (thread != null && thread.getThreadGroup() != null && thread.getThreadGroup().getName().equals(string)) {
            return thread;
        }
        return null;
    }

    public static Thread findThreadById(long l2, ThreadGroup threadGroup) {
        Objects.requireNonNull(threadGroup, "threadGroup");
        Thread thread = ThreadUtils.findThreadById(l2);
        if (thread != null && threadGroup.equals(thread.getThreadGroup())) {
            return thread;
        }
        return null;
    }

    public static Collection<ThreadGroup> findThreadGroups(Predicate<ThreadGroup> predicate) {
        return ThreadUtils.findThreadGroups(ThreadUtils.getSystemThreadGroup(), true, predicate);
    }

    public static Collection<ThreadGroup> findThreadGroups(ThreadGroup threadGroup, boolean bl2, Predicate<ThreadGroup> predicate) {
        ThreadGroup[] threadGroupArray;
        Objects.requireNonNull(threadGroup, "threadGroup");
        Objects.requireNonNull(predicate, "predicate");
        int n2 = threadGroup.activeGroupCount();
        while ((n2 = threadGroup.enumerate(threadGroupArray = new ThreadGroup[n2 + n2 / 2 + 1], bl2)) >= threadGroupArray.length) {
        }
        return Collections.unmodifiableCollection(Stream.of(threadGroupArray).limit(n2).filter(predicate).collect(Collectors.toList()));
    }

    @Deprecated
    public static Collection<ThreadGroup> findThreadGroups(ThreadGroup threadGroup, boolean bl2, ThreadGroupPredicate threadGroupPredicate) {
        return ThreadUtils.findThreadGroups(threadGroup, bl2, threadGroupPredicate::test);
    }

    @Deprecated
    public static Collection<ThreadGroup> findThreadGroups(ThreadGroupPredicate threadGroupPredicate) {
        return ThreadUtils.findThreadGroups(ThreadUtils.getSystemThreadGroup(), true, threadGroupPredicate);
    }

    public static Collection<ThreadGroup> findThreadGroupsByName(String string) {
        return ThreadUtils.findThreadGroups(ThreadUtils.predicateThreadGroup(string));
    }

    public static Collection<Thread> findThreads(Predicate<Thread> predicate) {
        return ThreadUtils.findThreads(ThreadUtils.getSystemThreadGroup(), true, predicate);
    }

    public static Collection<Thread> findThreads(ThreadGroup threadGroup, boolean bl2, Predicate<Thread> predicate) {
        Thread[] threadArray;
        Objects.requireNonNull(threadGroup, "The group must not be null");
        Objects.requireNonNull(predicate, "The predicate must not be null");
        int n2 = threadGroup.activeCount();
        while ((n2 = threadGroup.enumerate(threadArray = new Thread[n2 + n2 / 2 + 1], bl2)) >= threadArray.length) {
        }
        return Collections.unmodifiableCollection(Stream.of(threadArray).limit(n2).filter(predicate).collect(Collectors.toList()));
    }

    @Deprecated
    public static Collection<Thread> findThreads(ThreadGroup threadGroup, boolean bl2, ThreadPredicate threadPredicate) {
        return ThreadUtils.findThreads(threadGroup, bl2, threadPredicate::test);
    }

    @Deprecated
    public static Collection<Thread> findThreads(ThreadPredicate threadPredicate) {
        return ThreadUtils.findThreads(ThreadUtils.getSystemThreadGroup(), true, threadPredicate);
    }

    public static Collection<Thread> findThreadsByName(String string) {
        return ThreadUtils.findThreads(ThreadUtils.predicateThread(string));
    }

    public static Collection<Thread> findThreadsByName(String string, String string2) {
        Objects.requireNonNull(string, "threadName");
        Objects.requireNonNull(string2, "threadGroupName");
        return Collections.unmodifiableCollection(ThreadUtils.findThreadGroups(ThreadUtils.predicateThreadGroup(string2)).stream().flatMap(threadGroup -> ThreadUtils.findThreads(threadGroup, false, ThreadUtils.predicateThread(string)).stream()).collect(Collectors.toList()));
    }

    public static Collection<Thread> findThreadsByName(String string, ThreadGroup threadGroup) {
        return ThreadUtils.findThreads(threadGroup, false, ThreadUtils.predicateThread(string));
    }

    public static Collection<ThreadGroup> getAllThreadGroups() {
        return ThreadUtils.findThreadGroups(ThreadUtils.alwaysTruePredicate());
    }

    public static Collection<Thread> getAllThreads() {
        return ThreadUtils.findThreads(ThreadUtils.alwaysTruePredicate());
    }

    public static ThreadGroup getSystemThreadGroup() {
        ThreadGroup threadGroup;
        for (threadGroup = Thread.currentThread().getThreadGroup(); threadGroup != null && threadGroup.getParent() != null; threadGroup = threadGroup.getParent()) {
        }
        return threadGroup;
    }

    public static void join(Thread thread, Duration duration) throws InterruptedException {
        DurationUtils.accept(thread::join, duration);
    }

    private static <T> Predicate<T> namePredicate(String string, Function<T, String> function) {
        return object -> object != null && Objects.equals(function.apply(object), Objects.requireNonNull(string));
    }

    private static Predicate<Thread> predicateThread(String string) {
        return ThreadUtils.namePredicate(string, Thread::getName);
    }

    private static Predicate<ThreadGroup> predicateThreadGroup(String string) {
        return ThreadUtils.namePredicate(string, ThreadGroup::getName);
    }

    public static void sleep(Duration duration) throws InterruptedException {
        DurationUtils.accept(Thread::sleep, duration);
    }

    public static void sleepQuietly(Duration duration) {
        try {
            ThreadUtils.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Deprecated
    public ThreadUtils() {
    }

    @Deprecated
    @FunctionalInterface
    public static interface ThreadGroupPredicate {
        public boolean test(ThreadGroup var1);
    }

    @Deprecated
    @FunctionalInterface
    public static interface ThreadPredicate {
        public boolean test(Thread var1);
    }

    @Deprecated
    private static final class AlwaysTruePredicate
    implements ThreadGroupPredicate,
    ThreadPredicate {
        private AlwaysTruePredicate() {
        }

        @Override
        public boolean test(Thread thread) {
            return true;
        }

        @Override
        public boolean test(ThreadGroup threadGroup) {
            return true;
        }
    }

    @Deprecated
    public static class ThreadIdPredicate
    implements ThreadPredicate {
        private final long threadId;

        public ThreadIdPredicate(long l2) {
            if (l2 <= 0L) {
                throw new IllegalArgumentException("The thread id must be greater than zero");
            }
            this.threadId = l2;
        }

        @Override
        public boolean test(Thread thread) {
            return thread != null && thread.getId() == this.threadId;
        }
    }

    @Deprecated
    public static class NamePredicate
    implements ThreadGroupPredicate,
    ThreadPredicate {
        private final String name;

        public NamePredicate(String string) {
            Objects.requireNonNull(string, "name");
            this.name = string;
        }

        @Override
        public boolean test(Thread thread) {
            return thread != null && thread.getName().equals(this.name);
        }

        @Override
        public boolean test(ThreadGroup threadGroup) {
            return threadGroup != null && threadGroup.getName().equals(this.name);
        }
    }
}

