/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.protocol;

import com.contrastsecurity.thirdparty.oa4j.http.Header;
import com.contrastsecurity.thirdparty.oa4j.http.HttpEntity;
import com.contrastsecurity.thirdparty.oa4j.http.HttpException;
import com.contrastsecurity.thirdparty.oa4j.http.HttpResponse;
import com.contrastsecurity.thirdparty.oa4j.http.HttpResponseInterceptor;
import com.contrastsecurity.thirdparty.oa4j.http.HttpVersion;
import com.contrastsecurity.thirdparty.oa4j.http.ProtocolVersion;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.protocol.HttpContext;
import com.contrastsecurity.thirdparty.oa4j.http.protocol.HttpCoreContext;
import com.contrastsecurity.thirdparty.oa4j.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseConnControl
implements HttpResponseInterceptor {
    @Override
    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        Object object;
        Args.notNull(httpResponse, "HTTP response");
        HttpCoreContext httpCoreContext = HttpCoreContext.adapt(httpContext);
        int n2 = httpResponse.getStatusLine().getStatusCode();
        if (n2 == 400 || n2 == 408 || n2 == 411 || n2 == 413 || n2 == 414 || n2 == 503 || n2 == 501) {
            httpResponse.setHeader("Connection", "Close");
            return;
        }
        Header header = httpResponse.getFirstHeader("Connection");
        if (header != null && "Close".equalsIgnoreCase(header.getValue())) {
            return;
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null) {
            object = httpResponse.getStatusLine().getProtocolVersion();
            if (httpEntity.getContentLength() < 0L && (!httpEntity.isChunked() || ((ProtocolVersion)object).lessEquals(HttpVersion.HTTP_1_0))) {
                httpResponse.setHeader("Connection", "Close");
                return;
            }
        }
        if ((object = httpCoreContext.getRequest()) != null) {
            Header header2 = object.getFirstHeader("Connection");
            if (header2 != null) {
                httpResponse.setHeader("Connection", header2.getValue());
            } else if (object.getProtocolVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                httpResponse.setHeader("Connection", "Close");
            }
        }
    }
}

