/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.protocol;

import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.util.Args;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

@Contract(threading=ThreadingBehavior.SAFE)
public class UriPatternMatcher<T> {
    private final Map<String, T> map = new LinkedHashMap<String, T>();

    public synchronized Set<Map.Entry<String, T>> entrySet() {
        return new HashSet<Map.Entry<String, T>>(this.map.entrySet());
    }

    public synchronized void register(String string, T t2) {
        Args.notNull(string, "URI request pattern");
        this.map.put(string, t2);
    }

    public synchronized void unregister(String string) {
        if (string == null) {
            return;
        }
        this.map.remove(string);
    }

    @Deprecated
    public synchronized void setHandlers(Map<String, T> map) {
        Args.notNull(map, "Map of handlers");
        this.map.clear();
        this.map.putAll(map);
    }

    @Deprecated
    public synchronized void setObjects(Map<String, T> map) {
        Args.notNull(map, "Map of handlers");
        this.map.clear();
        this.map.putAll(map);
    }

    @Deprecated
    public synchronized Map<String, T> getObjects() {
        return this.map;
    }

    public synchronized T lookup(String string) {
        Args.notNull(string, "Request path");
        T t2 = this.map.get(string);
        if (t2 == null) {
            String string2 = null;
            for (String string3 : this.map.keySet()) {
                if (!this.matchUriRequestPattern(string3, string) || string2 != null && string2.length() >= string3.length() && (string2.length() != string3.length() || !string3.endsWith("*"))) continue;
                t2 = this.map.get(string3);
                string2 = string3;
            }
        }
        return t2;
    }

    protected boolean matchUriRequestPattern(String string, String string2) {
        if (string.equals("*")) {
            return true;
        }
        return string.endsWith("*") && string2.startsWith(string.substring(0, string.length() - 1)) || string.startsWith("*") && string2.endsWith(string.substring(1, string.length()));
    }

    public String toString() {
        return this.map.toString();
    }
}

