/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.routing;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Appender;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Filter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LifeCycle2;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.AbstractAppender;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rewrite.RewritePolicy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.routing.PurgePolicy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.routing.Route;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.routing.Routes;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.AppenderControl;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Node;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginElement;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.script.AbstractScript;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.script.ScriptManager;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.script.ScriptRef;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Booleans;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.script.Bindings;

@Plugin(name="Routing", category="Core", elementType="appender", printObject=true)
public final class RoutingAppender
extends AbstractAppender {
    public static final String STATIC_VARIABLES_KEY = "staticVariables";
    private static final String DEFAULT_KEY = "ROUTING_APPENDER_DEFAULT";
    private final Routes routes;
    private Route defaultRoute;
    private final Configuration configuration;
    private final ConcurrentMap<String, CreatedRouteAppenderControl> createdAppenders = new ConcurrentHashMap<String, CreatedRouteAppenderControl>();
    private final Map<String, AppenderControl> createdAppendersUnmodifiableView = Collections.unmodifiableMap(this.createdAppenders);
    private final ConcurrentMap<String, RouteAppenderControl> referencedAppenders = new ConcurrentHashMap<String, RouteAppenderControl>();
    private final RewritePolicy rewritePolicy;
    private final PurgePolicy purgePolicy;
    private final AbstractScript defaultRouteScript;
    private final ConcurrentMap<Object, Object> scriptStaticVariables = new ConcurrentHashMap<Object, Object>();

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    private RoutingAppender(String string, Filter filter, boolean bl2, Routes routes, RewritePolicy rewritePolicy, Configuration configuration, PurgePolicy purgePolicy, AbstractScript abstractScript, Property[] propertyArray) {
        super(string, filter, null, bl2, propertyArray);
        this.routes = routes;
        this.configuration = configuration;
        this.rewritePolicy = rewritePolicy;
        this.purgePolicy = purgePolicy;
        if (this.purgePolicy != null) {
            this.purgePolicy.initialize(this);
        }
        this.defaultRouteScript = abstractScript;
        Route route = null;
        for (Route route2 : routes.getRoutes()) {
            if (route2.getKey() != null) continue;
            if (route == null) {
                route = route2;
                continue;
            }
            this.error("Multiple default routes. Route " + route2.toString() + " will be ignored");
        }
        this.defaultRoute = route;
    }

    @Override
    public void start() {
        if (this.defaultRouteScript != null) {
            if (this.configuration == null) {
                this.error("No Configuration defined for RoutingAppender; required for Script element.");
            } else {
                ScriptManager scriptManager = this.configuration.getScriptManager();
                Bindings bindings = scriptManager.createBindings(this.defaultRouteScript);
                bindings.put(STATIC_VARIABLES_KEY, (Object)this.scriptStaticVariables);
                Object object = scriptManager.execute(this.defaultRouteScript.getName(), bindings);
                Route object2 = this.routes.getRoute(Objects.toString(object, null));
                if (object2 != null) {
                    this.defaultRoute = object2;
                }
            }
        }
        for (Route route : this.routes.getRoutes()) {
            if (route.getAppenderRef() == null) continue;
            Object t2 = this.configuration.getAppender(route.getAppenderRef());
            if (t2 != null) {
                String string = route == this.defaultRoute ? DEFAULT_KEY : route.getKey();
                this.referencedAppenders.put(string, new ReferencedRouteAppenderControl((Appender)t2));
                continue;
            }
            this.error("Appender " + route.getAppenderRef() + " cannot be located. Route ignored");
        }
        super.start();
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(l2, timeUnit, false);
        for (Map.Entry entry : this.createdAppenders.entrySet()) {
            Appender appender = ((CreatedRouteAppenderControl)entry.getValue()).getAppender();
            if (appender instanceof LifeCycle2) {
                ((LifeCycle2)((Object)appender)).stop(l2, timeUnit);
                continue;
            }
            appender.stop();
        }
        this.setStopped();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(LogEvent logEvent) {
        String string;
        String string2;
        RouteAppenderControl routeAppenderControl;
        if (this.rewritePolicy != null) {
            logEvent = this.rewritePolicy.rewrite(logEvent);
        }
        if ((routeAppenderControl = this.getControl(string2 = (string = this.routes.getPattern(logEvent, this.scriptStaticVariables)) != null ? this.configuration.getStrSubstitutor().replace(logEvent, string) : (this.defaultRoute.getKey() != null ? this.defaultRoute.getKey() : DEFAULT_KEY), logEvent)) != null) {
            try {
                routeAppenderControl.callAppender(logEvent);
            }
            finally {
                routeAppenderControl.release();
            }
        }
        this.updatePurgePolicy(string2, logEvent);
    }

    private void updatePurgePolicy(String string, LogEvent logEvent) {
        if (this.purgePolicy != null && !this.referencedAppenders.containsKey(string)) {
            this.purgePolicy.update(string, logEvent);
        }
    }

    private synchronized RouteAppenderControl getControl(String string, LogEvent logEvent) {
        RouteAppenderControl routeAppenderControl = this.getAppender(string);
        if (routeAppenderControl != null) {
            routeAppenderControl.checkout();
            return routeAppenderControl;
        }
        Route route = null;
        for (Route route2 : this.routes.getRoutes()) {
            if (route2.getAppenderRef() != null || !string.equals(route2.getKey())) continue;
            route = route2;
            break;
        }
        if (route == null) {
            route = this.defaultRoute;
            routeAppenderControl = this.getAppender(DEFAULT_KEY);
            if (routeAppenderControl != null) {
                routeAppenderControl.checkout();
                return routeAppenderControl;
            }
        }
        if (route != null) {
            Appender appender = this.createAppender(route, logEvent);
            if (appender == null) {
                return null;
            }
            CreatedRouteAppenderControl createdRouteAppenderControl = new CreatedRouteAppenderControl(appender);
            routeAppenderControl = createdRouteAppenderControl;
            this.createdAppenders.put(string, createdRouteAppenderControl);
        }
        if (routeAppenderControl != null) {
            routeAppenderControl.checkout();
        }
        return routeAppenderControl;
    }

    private RouteAppenderControl getAppender(String string) {
        RouteAppenderControl routeAppenderControl = (RouteAppenderControl)this.referencedAppenders.get(string);
        if (routeAppenderControl == null) {
            return (RouteAppenderControl)this.createdAppenders.get(string);
        }
        return routeAppenderControl;
    }

    private Appender createAppender(Route route, LogEvent logEvent) {
        Node node = route.getNode();
        for (Node node2 : node.getChildren()) {
            if (!node2.getType().getElementName().equals("appender")) continue;
            Node node3 = new Node(node2);
            this.configuration.createConfiguration(node3, logEvent);
            if (node3.getObject() instanceof Appender) {
                Appender appender = (Appender)node3.getObject();
                appender.start();
                return appender;
            }
            this.error("Unable to create Appender of type " + node2.getName());
            return null;
        }
        this.error("No Appender was configured for route " + route.getKey());
        return null;
    }

    public Map<String, AppenderControl> getAppenders() {
        return this.createdAppendersUnmodifiableView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAppender(String string) {
        LOGGER.debug("Deleting route with {} key ", (Object)string);
        CreatedRouteAppenderControl createdRouteAppenderControl = (CreatedRouteAppenderControl)this.createdAppenders.remove(string);
        if (null != createdRouteAppenderControl) {
            LOGGER.debug("Stopping route with {} key", (Object)string);
            RoutingAppender routingAppender = this;
            synchronized (routingAppender) {
                createdRouteAppenderControl.pendingDeletion = true;
            }
            createdRouteAppenderControl.tryStopAppender();
        } else if (this.referencedAppenders.containsKey(string)) {
            LOGGER.debug("Route {} using an appender reference may not be removed because the appender may be used outside of the RoutingAppender", (Object)string);
        } else {
            LOGGER.debug("Route with {} key already deleted", (Object)string);
        }
    }

    @Deprecated
    public static RoutingAppender createAppender(String string, String string2, Routes routes, Configuration configuration, RewritePolicy rewritePolicy, PurgePolicy purgePolicy, Filter filter) {
        boolean bl2 = Booleans.parseBoolean(string2, true);
        if (string == null) {
            LOGGER.error("No name provided for RoutingAppender");
            return null;
        }
        if (routes == null) {
            LOGGER.error("No routes defined for RoutingAppender");
            return null;
        }
        return new RoutingAppender(string, filter, bl2, routes, rewritePolicy, configuration, purgePolicy, null, null);
    }

    public Route getDefaultRoute() {
        return this.defaultRoute;
    }

    public AbstractScript getDefaultRouteScript() {
        return this.defaultRouteScript;
    }

    public PurgePolicy getPurgePolicy() {
        return this.purgePolicy;
    }

    public RewritePolicy getRewritePolicy() {
        return this.rewritePolicy;
    }

    public Routes getRoutes() {
        return this.routes;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ConcurrentMap<Object, Object> getScriptStaticVariables() {
        return this.scriptStaticVariables;
    }

    private static final class ReferencedRouteAppenderControl
    extends RouteAppenderControl {
        ReferencedRouteAppenderControl(Appender appender) {
            super(appender);
        }

        @Override
        void checkout() {
        }

        @Override
        void release() {
        }
    }

    private static final class CreatedRouteAppenderControl
    extends RouteAppenderControl {
        private volatile boolean pendingDeletion;
        private final AtomicInteger depth = new AtomicInteger();

        CreatedRouteAppenderControl(Appender appender) {
            super(appender);
        }

        @Override
        void checkout() {
            if (this.pendingDeletion) {
                LOGGER.warn("CreatedRouteAppenderControl.checkout invoked on a RouteAppenderControl that is pending deletion");
            }
            this.depth.incrementAndGet();
        }

        @Override
        void release() {
            this.depth.decrementAndGet();
            this.tryStopAppender();
        }

        void tryStopAppender() {
            if (this.pendingDeletion && this.depth.compareAndSet(0, -100000)) {
                Appender appender = this.getAppender();
                LOGGER.debug("Stopping appender {}", (Object)appender);
                appender.stop();
            }
        }
    }

    private static abstract class RouteAppenderControl
    extends AppenderControl {
        RouteAppenderControl(Appender appender) {
            super(appender, null, null);
        }

        abstract void checkout();

        abstract void release();
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Builder<RoutingAppender> {
        @PluginElement(value="Script")
        private AbstractScript defaultRouteScript;
        @PluginElement(value="Routes")
        private Routes routes;
        @PluginElement(value="RewritePolicy")
        private RewritePolicy rewritePolicy;
        @PluginElement(value="PurgePolicy")
        private PurgePolicy purgePolicy;

        @Override
        public RoutingAppender build() {
            String string = this.getName();
            if (string == null) {
                LOGGER.error("No name defined for this RoutingAppender");
                return null;
            }
            if (this.routes == null) {
                LOGGER.error("No routes defined for RoutingAppender {}", (Object)string);
                return null;
            }
            if (this.defaultRouteScript != null) {
                if (this.getConfiguration().getScriptManager() == null) {
                    LOGGER.error("Script support is not enabled");
                    return null;
                }
                if (!(this.defaultRouteScript instanceof ScriptRef) && !this.getConfiguration().getScriptManager().addScript(this.defaultRouteScript)) {
                    return null;
                }
            }
            return new RoutingAppender(string, this.getFilter(), this.isIgnoreExceptions(), this.routes, this.rewritePolicy, this.getConfiguration(), this.purgePolicy, this.defaultRouteScript, this.getPropertyArray());
        }

        public Routes getRoutes() {
            return this.routes;
        }

        public AbstractScript getDefaultRouteScript() {
            return this.defaultRouteScript;
        }

        public RewritePolicy getRewritePolicy() {
            return this.rewritePolicy;
        }

        public PurgePolicy getPurgePolicy() {
            return this.purgePolicy;
        }

        public B withRoutes(Routes routes) {
            this.routes = routes;
            return (B)((Builder)this.asBuilder());
        }

        public B withDefaultRouteScript(AbstractScript abstractScript) {
            this.defaultRouteScript = abstractScript;
            return (B)((Builder)this.asBuilder());
        }

        public B withRewritePolicy(RewritePolicy rewritePolicy) {
            this.rewritePolicy = rewritePolicy;
            return (B)((Builder)this.asBuilder());
        }

        public void withPurgePolicy(PurgePolicy purgePolicy) {
            this.purgePolicy = purgePolicy;
        }
    }
}

