/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.net;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.validation.constraints.ValidHost;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.validation.constraints.ValidPort;
import java.net.InetAddress;
import java.net.InetSocketAddress;

@Plugin(name="SocketAddress", category="Core", printObject=true)
public class SocketAddress {
    private final InetSocketAddress socketAddress;

    public static SocketAddress getLoopback() {
        return new SocketAddress(InetAddress.getLoopbackAddress(), 0);
    }

    private SocketAddress(InetAddress inetAddress, int n2) {
        this.socketAddress = new InetSocketAddress(inetAddress, n2);
    }

    public InetSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public int getPort() {
        return this.socketAddress.getPort();
    }

    public InetAddress getAddress() {
        return this.socketAddress.getAddress();
    }

    public String getHostName() {
        return this.socketAddress.getHostName();
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return this.socketAddress.toString();
    }

    public static class Builder
    implements com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Builder<SocketAddress> {
        @PluginBuilderAttribute
        @ValidHost
        private InetAddress host;
        @PluginBuilderAttribute
        @ValidPort
        private int port;

        public Builder setHost(InetAddress inetAddress) {
            this.host = inetAddress;
            return this;
        }

        public Builder setPort(int n2) {
            this.port = n2;
            return this;
        }

        @Override
        public SocketAddress build() {
            return new SocketAddress(this.host, this.port);
        }
    }
}

