/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.net;

import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.AppenderLoggingException;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.ManagerFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.OutputStreamManager;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.net.AbstractSocketManager;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.net.SocketOptions;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Closer;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Log4jThread;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.NullOutputStream;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public class TcpSocketManager
extends AbstractSocketManager {
    public static final int DEFAULT_RECONNECTION_DELAY_MILLIS = 30000;
    private static final int DEFAULT_PORT = 4560;
    private static final TcpSocketManagerFactory<TcpSocketManager, FactoryData> FACTORY = new TcpSocketManagerFactory();
    private final int reconnectionDelayMillis;
    private Reconnector reconnector;
    private Socket socket;
    private final SocketOptions socketOptions;
    private final boolean retry;
    private final boolean immediateFail;
    private final int connectTimeoutMillis;

    @Deprecated
    public TcpSocketManager(String string, OutputStream outputStream, Socket socket, InetAddress inetAddress, String string2, int n2, int n3, int n4, boolean bl2, Layout<? extends Serializable> layout, int n5) {
        this(string, outputStream, socket, inetAddress, string2, n2, n3, n4, bl2, layout, n5, null);
    }

    public TcpSocketManager(String string, OutputStream outputStream, Socket socket, InetAddress inetAddress, String string2, int n2, int n3, int n4, boolean bl2, Layout<? extends Serializable> layout, int n5, SocketOptions socketOptions) {
        super(string, outputStream, inetAddress, string2, n2, layout, true, n5);
        this.connectTimeoutMillis = n3;
        this.reconnectionDelayMillis = n4;
        this.socket = socket;
        this.immediateFail = bl2;
        boolean bl3 = this.retry = n4 > 0;
        if (socket == null) {
            this.reconnector = this.createReconnector();
            this.reconnector.start();
        }
        this.socketOptions = socketOptions;
    }

    @Deprecated
    public static TcpSocketManager getSocketManager(String string, int n2, int n3, int n4, boolean bl2, Layout<? extends Serializable> layout, int n5) {
        return TcpSocketManager.getSocketManager(string, n2, n3, n4, bl2, layout, n5, null);
    }

    public static TcpSocketManager getSocketManager(String string, int n2, int n3, int n4, boolean bl2, Layout<? extends Serializable> layout, int n5, SocketOptions socketOptions) {
        if (Strings.isEmpty(string)) {
            throw new IllegalArgumentException("A host name is required");
        }
        if (n2 <= 0) {
            n2 = 4560;
        }
        if (n4 == 0) {
            n4 = 30000;
        }
        return (TcpSocketManager)TcpSocketManager.getManager("TCP:" + string + ':' + n2, new FactoryData(string, n2, n3, n4, bl2, layout, n5, socketOptions), FACTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(byte[] byArray, int n2, int n3, boolean bl2) {
        if (this.socket == null) {
            if (this.reconnector != null && !this.immediateFail) {
                this.reconnector.latch();
            }
            if (this.socket == null) {
                throw new AppenderLoggingException("Error writing to " + this.getName() + ": socket not available");
            }
        }
        TcpSocketManager tcpSocketManager = this;
        synchronized (tcpSocketManager) {
            try {
                this.writeAndFlush(byArray, n2, n3, bl2);
            }
            catch (IOException iOException) {
                String string = this.inetAddress + ":" + this.port;
                if (this.retry && this.reconnector == null) {
                    this.reconnector = this.createReconnector();
                    try {
                        this.reconnector.reconnect();
                    }
                    catch (IOException iOException2) {
                        LOGGER.debug("Cannot reestablish socket connection to {}: {}; starting reconnector thread {}", (Object)string, (Object)iOException2.getLocalizedMessage(), (Object)this.reconnector.getName(), (Object)iOException2);
                        this.reconnector.start();
                        throw new AppenderLoggingException(String.format("Error sending to %s for %s", this.getName(), string), iOException);
                    }
                    try {
                        this.writeAndFlush(byArray, n2, n3, bl2);
                    }
                    catch (IOException iOException3) {
                        throw new AppenderLoggingException(String.format("Error writing to %s after reestablishing connection for %s", this.getName(), string), iOException);
                    }
                    return;
                }
                String string2 = String.format("Error writing to %s for connection %s", this.getName(), string);
                throw new AppenderLoggingException(string2, iOException);
            }
        }
    }

    private void writeAndFlush(byte[] byArray, int n2, int n3, boolean bl2) throws IOException {
        OutputStream outputStream = this.getOutputStream();
        outputStream.write(byArray, n2, n3);
        if (bl2) {
            outputStream.flush();
        }
    }

    @Override
    protected synchronized boolean closeOutputStream() {
        boolean bl2 = super.closeOutputStream();
        if (this.reconnector != null) {
            this.reconnector.shutdown();
            this.reconnector.interrupt();
            this.reconnector = null;
        }
        Socket socket = this.socket;
        this.socket = null;
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                LOGGER.error("Could not close socket {}", (Object)this.socket);
                return false;
            }
        }
        return bl2;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> hashMap = new HashMap<String, String>(super.getContentFormat());
        hashMap.put("protocol", "tcp");
        hashMap.put("direction", "out");
        return hashMap;
    }

    private Reconnector createReconnector() {
        Reconnector reconnector = new Reconnector(this);
        reconnector.setDaemon(true);
        reconnector.setPriority(1);
        return reconnector;
    }

    protected Socket createSocket(InetSocketAddress inetSocketAddress) throws IOException {
        return TcpSocketManager.createSocket(inetSocketAddress, this.socketOptions, this.connectTimeoutMillis);
    }

    protected static Socket createSocket(InetSocketAddress inetSocketAddress, SocketOptions socketOptions, int n2) throws IOException {
        LOGGER.debug("Creating socket {}", (Object)inetSocketAddress.toString());
        Socket socket = new Socket();
        if (socketOptions != null) {
            socketOptions.apply(socket);
        }
        socket.connect(inetSocketAddress, n2);
        if (socketOptions != null) {
            socketOptions.apply(socket);
        }
        return socket;
    }

    public static void setHostResolver(HostResolver hostResolver) {
        TcpSocketManagerFactory.RESOLVER = hostResolver;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public int getReconnectionDelayMillis() {
        return this.reconnectionDelayMillis;
    }

    public String toString() {
        return "TcpSocketManager [reconnectionDelayMillis=" + this.reconnectionDelayMillis + ", reconnector=" + this.reconnector + ", socket=" + this.socket + ", socketOptions=" + this.socketOptions + ", retry=" + this.retry + ", immediateFail=" + this.immediateFail + ", connectTimeoutMillis=" + this.connectTimeoutMillis + ", inetAddress=" + this.inetAddress + ", host=" + this.host + ", port=" + this.port + ", layout=" + this.layout + ", byteBuffer=" + this.byteBuffer + ", count=" + this.count + "]";
    }

    public static class HostResolver {
        public static final HostResolver INSTANCE = new HostResolver();

        public List<InetSocketAddress> resolveHost(String string, int n2) throws UnknownHostException {
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
            ArrayList<InetSocketAddress> arrayList = new ArrayList<InetSocketAddress>(inetAddressArray.length);
            for (InetAddress inetAddress : inetAddressArray) {
                arrayList.add(new InetSocketAddress(inetAddress, n2));
            }
            return arrayList;
        }
    }

    protected static class TcpSocketManagerFactory<M extends TcpSocketManager, T extends FactoryData>
    implements ManagerFactory<M, T> {
        static volatile HostResolver RESOLVER = HostResolver.INSTANCE;

        protected TcpSocketManagerFactory() {
        }

        @Override
        public M createManager(String string, T t2) {
            InetAddress inetAddress;
            try {
                inetAddress = InetAddress.getByName(((FactoryData)t2).host);
            }
            catch (UnknownHostException unknownHostException) {
                LOGGER.error("Could not find address of {}: {}", (Object)((FactoryData)t2).host, (Object)unknownHostException, (Object)unknownHostException);
                return null;
            }
            Socket socket = null;
            try {
                socket = this.createSocket(t2);
                OutputStream outputStream = socket.getOutputStream();
                return this.createManager(string, outputStream, socket, inetAddress, t2);
            }
            catch (IOException iOException) {
                LOGGER.error("TcpSocketManager ({}) caught exception and will continue:", (Object)string, (Object)iOException);
                NullOutputStream nullOutputStream = NullOutputStream.getInstance();
                if (((FactoryData)t2).reconnectDelayMillis == 0) {
                    Closer.closeSilently(socket);
                    return null;
                }
                return this.createManager(string, nullOutputStream, null, inetAddress, t2);
            }
        }

        M createManager(String string, OutputStream outputStream, Socket socket, InetAddress inetAddress, T t2) {
            return (M)new TcpSocketManager(string, outputStream, socket, inetAddress, ((FactoryData)t2).host, ((FactoryData)t2).port, ((FactoryData)t2).connectTimeoutMillis, ((FactoryData)t2).reconnectDelayMillis, ((FactoryData)t2).immediateFail, ((FactoryData)t2).layout, ((FactoryData)t2).bufferSize, ((FactoryData)t2).socketOptions);
        }

        Socket createSocket(T t2) throws IOException {
            List<InetSocketAddress> list = RESOLVER.resolveHost(((FactoryData)t2).host, ((FactoryData)t2).port);
            IOException iOException = null;
            for (InetSocketAddress inetSocketAddress : list) {
                try {
                    return TcpSocketManager.createSocket(inetSocketAddress, ((FactoryData)t2).socketOptions, ((FactoryData)t2).connectTimeoutMillis);
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                }
            }
            throw new IOException(this.errorMessage(t2, list), iOException);
        }

        protected String errorMessage(T t2, List<InetSocketAddress> list) {
            StringBuilder stringBuilder = new StringBuilder("Unable to create socket for ");
            stringBuilder.append(((FactoryData)t2).host).append(" at port ").append(((FactoryData)t2).port);
            if (list.size() == 1) {
                if (!list.get(0).getAddress().getHostAddress().equals(((FactoryData)t2).host)) {
                    stringBuilder.append(" using ip address ").append(list.get(0).getAddress().getHostAddress());
                    stringBuilder.append(" and port ").append(list.get(0).getPort());
                }
            } else {
                stringBuilder.append(" using ip addresses and ports ");
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    if (i2 <= 0) continue;
                    stringBuilder.append(", ");
                    stringBuilder.append(list.get(i2).getAddress().getHostAddress());
                    stringBuilder.append(":").append(list.get(i2).getPort());
                }
            }
            return stringBuilder.toString();
        }
    }

    static class FactoryData {
        protected final String host;
        protected final int port;
        protected final int connectTimeoutMillis;
        protected final int reconnectDelayMillis;
        protected final boolean immediateFail;
        protected final Layout<? extends Serializable> layout;
        protected final int bufferSize;
        protected final SocketOptions socketOptions;

        public FactoryData(String string, int n2, int n3, int n4, boolean bl2, Layout<? extends Serializable> layout, int n5, SocketOptions socketOptions) {
            this.host = string;
            this.port = n2;
            this.connectTimeoutMillis = n3;
            this.reconnectDelayMillis = n4;
            this.immediateFail = bl2;
            this.layout = layout;
            this.bufferSize = n5;
            this.socketOptions = socketOptions;
        }

        public String toString() {
            return "FactoryData [host=" + this.host + ", port=" + this.port + ", connectTimeoutMillis=" + this.connectTimeoutMillis + ", reconnectDelayMillis=" + this.reconnectDelayMillis + ", immediateFail=" + this.immediateFail + ", layout=" + this.layout + ", bufferSize=" + this.bufferSize + ", socketOptions=" + this.socketOptions + "]";
        }
    }

    private class Reconnector
    extends Log4jThread {
        private final CountDownLatch latch;
        private boolean shutdown;
        private final Object owner;

        public Reconnector(OutputStreamManager outputStreamManager) {
            super("TcpSocketManager-Reconnector");
            this.latch = new CountDownLatch(1);
            this.shutdown = false;
            this.owner = outputStreamManager;
        }

        public void latch() {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void shutdown() {
            this.shutdown = true;
        }

        @Override
        public void run() {
            ScopeProvider scopeProvider = ContrastContext.current().scopeProvider().enterScope();
            try {
                while (!this.shutdown) {
                    try {
                        Reconnector.sleep(TcpSocketManager.this.reconnectionDelayMillis);
                        this.reconnect();
                    }
                    catch (InterruptedException interruptedException) {
                        LOGGER.debug("Reconnection interrupted.");
                    }
                    catch (ConnectException connectException) {
                        LOGGER.debug("{}:{} refused connection", (Object)TcpSocketManager.this.host, (Object)TcpSocketManager.this.port);
                    }
                    catch (IOException iOException) {
                        LOGGER.debug("Unable to reconnect to {}:{}", (Object)TcpSocketManager.this.host, (Object)TcpSocketManager.this.port);
                    }
                    finally {
                        this.latch.countDown();
                    }
                }
                scopeProvider.leaveScope();
                return;
            }
            catch (Throwable throwable) {
                scopeProvider.leaveScope();
                throw throwable;
            }
        }

        void reconnect() throws IOException {
            List<InetSocketAddress> list = TcpSocketManagerFactory.RESOLVER.resolveHost(TcpSocketManager.this.host, TcpSocketManager.this.port);
            if (list.size() != 1) {
                IOException iOException = null;
                for (InetSocketAddress inetSocketAddress : list) {
                    try {
                        LOGGER.debug("Reconnecting " + inetSocketAddress);
                        this.connect(inetSocketAddress);
                        return;
                    }
                    catch (IOException iOException2) {
                        iOException = iOException2;
                    }
                }
                throw iOException;
            }
            LOGGER.debug("Reconnecting " + list.get(0));
            this.connect(list.get(0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void connect(InetSocketAddress inetSocketAddress) throws IOException {
            Socket socket = TcpSocketManager.this.createSocket(inetSocketAddress);
            OutputStream outputStream = socket.getOutputStream();
            InetAddress inetAddress = TcpSocketManager.this.socket != null ? TcpSocketManager.this.socket.getInetAddress() : null;
            Object object = this.owner;
            synchronized (object) {
                Closer.closeSilently(TcpSocketManager.this.getOutputStream());
                TcpSocketManager.this.setOutputStream(outputStream);
                TcpSocketManager.this.socket = socket;
                TcpSocketManager.this.reconnector = null;
                this.shutdown = true;
            }
            object = inetAddress != null && inetAddress.getHostAddress().equals(inetSocketAddress.getAddress().getHostAddress()) ? "reestablished" : "established";
            LOGGER.debug("Connection to {}:{} {}: {}", (Object)TcpSocketManager.this.host, (Object)TcpSocketManager.this.port, object, (Object)TcpSocketManager.this.socket);
        }

        @Override
        public String toString() {
            return "Reconnector [latch=" + this.latch + ", shutdown=" + this.shutdown + "]";
        }
    }
}

