/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.spi;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.LogManager;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.spi.CopyOnWriteSortedArrayThreadContextMap;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.spi.DefaultThreadContextMap;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.spi.GarbageFreeSortedArrayThreadContextMap;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.spi.Provider;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.spi.ThreadContextMap;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.Constants;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.PropertiesUtil;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.ProviderUtil;

public final class ThreadContextMapFactory {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String THREAD_CONTEXT_KEY = "com.contrastsecurity.thirdparty.log4j2.threadContextMap";
    private static final String GC_FREE_THREAD_CONTEXT_KEY = "com.contrastsecurity.thirdparty.log4j2.garbagefree.threadContextMap";
    private static boolean GcFreeThreadContextKey;
    private static String ThreadContextMapName;

    public static void init() {
        CopyOnWriteSortedArrayThreadContextMap.init();
        GarbageFreeSortedArrayThreadContextMap.init();
        DefaultThreadContextMap.init();
        ThreadContextMapFactory.initPrivate();
    }

    private static void initPrivate() {
        PropertiesUtil propertiesUtil = PropertiesUtil.getProperties();
        ThreadContextMapName = propertiesUtil.getStringProperty(THREAD_CONTEXT_KEY);
        GcFreeThreadContextKey = propertiesUtil.getBooleanProperty(GC_FREE_THREAD_CONTEXT_KEY);
    }

    private ThreadContextMapFactory() {
    }

    public static ThreadContextMap createThreadContextMap() {
        Object object;
        ClassLoader classLoader = ProviderUtil.findClassLoader();
        ThreadContextMap threadContextMap = null;
        if (ThreadContextMapName != null) {
            try {
                object = classLoader.loadClass(ThreadContextMapName);
                if (ThreadContextMap.class.isAssignableFrom((Class<?>)object)) {
                    threadContextMap = (ThreadContextMap)((Class)object).newInstance();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.error("Unable to locate configured ThreadContextMap {}", (Object)ThreadContextMapName);
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                object = exception;
                LOGGER.error("Unable to create configured ThreadContextMap {}", (Object)ThreadContextMapName, object);
            }
        }
        if (threadContextMap == null && ProviderUtil.hasProviders() && LogManager.getFactory() != null) {
            object = LogManager.getFactory().getClass().getName();
            for (Provider provider : ProviderUtil.getProviders()) {
                Class<? extends ThreadContextMap> clazz;
                if (!((String)object).equals(provider.getClassName()) || (clazz = provider.loadThreadContextMap()) == null) continue;
                try {
                    threadContextMap = clazz.newInstance();
                    break;
                }
                catch (Exception exception) {
                    Throwables.throwIfCritical(exception);
                    Exception exception2 = exception;
                    LOGGER.error("Unable to locate or load configured ThreadContextMap {}", (Object)provider.getThreadContextMap(), (Object)exception2);
                    threadContextMap = ThreadContextMapFactory.createDefaultThreadContextMap();
                }
            }
        }
        if (threadContextMap == null) {
            threadContextMap = ThreadContextMapFactory.createDefaultThreadContextMap();
        }
        return threadContextMap;
    }

    private static ThreadContextMap createDefaultThreadContextMap() {
        if (Constants.ENABLE_THREADLOCALS) {
            if (GcFreeThreadContextKey) {
                return new GarbageFreeSortedArrayThreadContextMap();
            }
            return new CopyOnWriteSortedArrayThreadContextMap();
        }
        return new DefaultThreadContextMap(true);
    }

    static {
        ThreadContextMapFactory.initPrivate();
    }
}

