/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.util;

import com.contrastsecurity.thirdparty.omv2.ImmutableElementException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastList<E>
extends AbstractList<E>
implements Externalizable {
    private E[] elements;
    private int size = 0;
    private boolean updated = false;

    public FastList(int n2) {
        this.elements = new Object[n2 == 0 ? 1 : n2];
    }

    public FastList(E[] EArray) {
        this.elements = EArray;
        this.size = EArray.length;
    }

    public FastList() {
        this(10);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.size);
        for (int i2 = 0; i2 < this.size; ++i2) {
            objectOutput.writeObject(this.elements[i2]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.size = objectInput.readInt();
        this.elements = new Object[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.elements[i2] = objectInput.readObject();
        }
    }

    @Override
    public E get(int n2) {
        return this.elements[n2];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(E e2) {
        if (this.size == this.elements.length) {
            this.increaseSize(this.elements.length * 2);
        }
        this.elements[this.size++] = e2;
        return true;
    }

    @Override
    public E set(int n2, E e2) {
        if (!this.updated) {
            this.copyArray();
        }
        E e3 = this.elements[n2];
        this.elements[n2] = e2;
        return e3;
    }

    @Override
    public void add(int n2, E e2) {
        if (this.size == this.elements.length) {
            this.increaseSize(this.elements.length * 2);
        }
        for (int i2 = this.size; i2 != n2; --i2) {
            this.elements[i2] = this.elements[i2 - 1];
        }
        this.elements[n2] = e2;
        ++this.size;
    }

    @Override
    public E remove(int n2) {
        E e2 = this.elements[n2];
        for (int i2 = n2 + 1; i2 < this.size; ++i2) {
            this.elements[i2 - 1] = this.elements[i2];
            this.elements[i2] = null;
        }
        --this.size;
        return e2;
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.elements.length; ++i2) {
            if (!object.equals(this.elements[i2])) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (object == null) {
            return -1;
        }
        for (int i2 = this.elements.length - 1; i2 != -1; --i2) {
            if (!object.equals(this.elements[i2])) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public void clear() {
        this.elements = new Object[1];
        this.size = 0;
    }

    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        int n3;
        int n4 = collection.size();
        this.ensureCapacity(n4 + this.size);
        if (n2 != 0) {
            for (n3 = n2; n3 != n2 + n4; ++n3) {
                this.elements[n3 + n4 + 1] = this.elements[n3];
            }
        }
        n3 = this.size == 0 ? -1 : 0;
        for (E e2 : collection) {
            this.elements[n4 + n3++] = e2;
        }
        this.size += n4;
        return true;
    }

    @Override
    public Iterator iterator() {
        final int n2 = this.size;
        return new Iterator(){
            private int cursor = 0;

            public boolean hasNext() {
                return this.cursor < n2;
            }

            public Object next() {
                return FastList.this.elements[this.cursor++];
            }

            public void remove() {
                throw new ImmutableElementException("cannot change elements in immutable list");
            }
        };
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListIterator<E>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < FastList.this.size;
            }

            @Override
            public E next() {
                return FastList.this.elements[this.i++];
            }

            @Override
            public boolean hasPrevious() {
                return this.i > 0;
            }

            @Override
            public E previous() {
                return FastList.this.elements[this.i--];
            }

            @Override
            public int nextIndex() {
                return this.i++;
            }

            @Override
            public int previousIndex() {
                return this.i--;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(E e2) {
                ((FastList)FastList.this).elements[this.i] = e2;
            }

            @Override
            public void add(Object object) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public ListIterator listIterator(int n2) {
        return super.listIterator(n2);
    }

    @Override
    public List subList(int n2, int n3) {
        return super.subList(n2, n3);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        ListIterator<E> listIterator = this.listIterator();
        ListIterator listIterator2 = ((List)object).listIterator();
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            E e2 = listIterator.next();
            Object e3 = listIterator2.next();
            if (e2 != null ? e2.equals(e3) : e3 == null) continue;
            return false;
        }
        return !listIterator.hasNext() && !listIterator2.hasNext();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected void removeRange(int n2, int n3) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size]);
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = new Object[this.size];
        }
        for (int i2 = 0; i2 < this.size; ++i2) {
            objectArray[i2] = this.elements[i2];
        }
        return objectArray;
    }

    @Override
    public boolean remove(Object object) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean containsAll(Collection collection) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean addAll(Collection collection) {
        return this.addAll(this.size, collection);
    }

    @Override
    public boolean removeAll(Collection collection) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new RuntimeException("not implemented");
    }

    private void ensureCapacity(int n2) {
        if (this.size + n2 > this.elements.length) {
            this.increaseSize((this.size + n2) * 2);
        }
    }

    private void copyArray() {
        this.increaseSize(this.elements.length);
    }

    private void increaseSize(int n2) {
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < this.elements.length; ++i2) {
            objectArray[i2] = this.elements[i2];
        }
        this.elements = objectArray;
        this.updated = true;
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

