/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent;

import com.contrastsecurity.agent.ContrastStarter;
import java.lang.instrument.Instrumentation;

public final class ContrastLoaderAgent {
    public static void main(String[] args) {
        ContrastStarter.diagnostics(args);
    }

    public static void agentmain(String args, Instrumentation inst) {
        ContrastLoaderAgent.premain(args, inst);
    }

    public static void premain(String args, Instrumentation inst) {
        String javaVersion = System.getProperty("java.version");
        if (!ContrastLoaderAgent.isJava8OrHigher(javaVersion)) {
            if (System.getenv("CONTRAST_INSTALLATION_TOOL") == null) {
                System.err.println("The Contrast Agent does not support Java " + javaVersion + ". Please attach the agent to a Java 8+ JVM. Continuing application startup without Contrast Agent....");
            }
            return;
        }
        ContrastStarter.start(args, inst);
    }

    static boolean isJava8OrHigher(String version) {
        return version != null && "1.8".compareTo(version) <= 0;
    }

    private ContrastLoaderAgent() {
    }
}

