/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.apps.exclusions;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.exclusions.d;
import com.contrastsecurity.agent.apps.exclusions.j;
import com.contrastsecurity.agent.apps.exclusions.p;
import com.contrastsecurity.agent.apps.exclusions.s;
import com.contrastsecurity.agent.apps.exclusions.v;
import com.contrastsecurity.agent.apps.exclusions.z;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.l.a;
import com.contrastsecurity.agent.messages.app.settings.ExceptionInputTypeDTM;
import com.contrastsecurity.agent.messages.app.settings.IInputExclusion;
import com.contrastsecurity.agent.messages.app.settings.IQueueExclusion;
import com.contrastsecurity.agent.messages.app.settings.IUrlExclusion;
import com.contrastsecurity.agent.messages.app.settings.InputExceptionDTM;
import com.contrastsecurity.agent.messages.app.settings.QueueExclusionDTM;
import com.contrastsecurity.agent.messages.app.settings.RuleExceptionDTM;
import com.contrastsecurity.agent.messages.app.settings.UrlExceptionDTM;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.List;
import java.util.Map;
import java.util.Set;

@DontObfuscate
public class DefaultExclusionProcessor
implements j {
    private final p inputExclusionManager;
    private final z urlExclusionManager = new z();
    private final v queueExclusionManager = new v();
    private static final Logger logger = LoggerFactory.getLogger(DefaultExclusionProcessor.class);

    DefaultExclusionProcessor(List<? extends IInputExclusion> list, List<? extends IUrlExclusion> list2, List<? extends IQueueExclusion> list3, Config config) {
        this(config);
        this.parseInputExclusions(list);
        this.parseUrlExclusions(list2);
        this.parseQueueExclusions(list3);
    }

    public DefaultExclusionProcessor(Config config) {
        this.inputExclusionManager = config == null ? new p(false) : new p(!config.getBoolean(ConfigProperty.INPUT_EXCLUSION_NAME_STRICT_REGEX));
    }

    public DefaultExclusionProcessor() {
        this.inputExclusionManager = new p(false);
    }

    DefaultExclusionProcessor(boolean bl2) {
        this.inputExclusionManager = new p(bl2);
    }

    @Override
    @q
    public void addRuleExceptionDTM(RuleExceptionDTM ruleExceptionDTM) {
        if (ruleExceptionDTM instanceof InputExceptionDTM) {
            this.inputExclusionManager.a((InputExceptionDTM)ruleExceptionDTM);
        } else if (ruleExceptionDTM instanceof UrlExceptionDTM) {
            this.urlExclusionManager.a((UrlExceptionDTM)ruleExceptionDTM);
        } else if (ruleExceptionDTM instanceof QueueExclusionDTM) {
            this.queueExclusionManager.a((QueueExclusionDTM)ruleExceptionDTM);
        }
    }

    @Override
    public boolean hasQuerystringExclusions(d.a a2) {
        return this.inputExclusionManager.a(a2);
    }

    @Override
    public boolean hasParameterExclusions(d.a a2) {
        return this.inputExclusionManager.b(a2);
    }

    @Override
    public boolean hasHeaderExclusions(d.a a2) {
        return this.inputExclusionManager.c(a2);
    }

    @Override
    public boolean hasCookieExclusions(d.a a2) {
        return this.inputExclusionManager.d(a2);
    }

    @Override
    public boolean hasUrlExclusions(d.a a2) {
        return this.urlExclusionManager.a(a2);
    }

    @Override
    public boolean hasBodyExclusions(d.a a2) {
        return this.inputExclusionManager.e(a2);
    }

    @Override
    public boolean isInputExclusion(d.a a2, String string, String string2, ExceptionInputTypeDTM exceptionInputTypeDTM) {
        return this.isInputExclusion(a2, string, string2, exceptionInputTypeDTM, null);
    }

    @Override
    public boolean isInputExclusion(d.a a2, String string, String string2, ExceptionInputTypeDTM exceptionInputTypeDTM, String string3) {
        a a3 = new a();
        switch (exceptionInputTypeDTM) {
            case BODY: {
                return this.inputExclusionManager.b(a3, a2, string, string2);
            }
            case COOKIE: {
                return this.inputExclusionManager.c(a3, a2, string, string2, string3);
            }
            case HEADER: {
                return this.inputExclusionManager.b(a3, a2, string, string2, string3);
            }
            case PARAMETER: {
                return this.inputExclusionManager.a(a3, a2, string, string2, string3);
            }
            case QUERYSTRING: {
                return this.inputExclusionManager.a(a3, a2, string, string2);
            }
        }
        logger.error("Unknown input type asked for in input exception: {}", (Object)exceptionInputTypeDTM);
        return false;
    }

    @Override
    public boolean isDisabledByUrl(d.a a2, String string, String string2) {
        return this.urlExclusionManager.a(new a(), a2, string, string2);
    }

    @Override
    public boolean isQueueExclusion(d.a a2, String string, String string2) {
        return this.queueExclusionManager.a(new a(), a2, string, string2);
    }

    @Override
    public Set<String> rulesDisabledByUrl(d.a a2, String string) {
        return this.urlExclusionManager.a(new a(), a2, string);
    }

    @Override
    public Map<String, Set<String>> rulesDisabledByInputAndUrl(d.a a2, String string, ExceptionInputTypeDTM exceptionInputTypeDTM) {
        return this.inputExclusionManager.a(new a(), a2, string, exceptionInputTypeDTM);
    }

    @Override
    public s getParameterHandler() {
        return this.inputExclusionManager.a();
    }

    @Override
    public s getHeaderHandler() {
        return this.inputExclusionManager.b();
    }

    @Override
    public s getCookieHandler() {
        return this.inputExclusionManager.c();
    }

    private void parseUrlExclusions(List<? extends IUrlExclusion> list) {
        if (list == null) {
            return;
        }
        for (IUrlExclusion iUrlExclusion : list) {
            try {
                this.urlExclusionManager.a(UrlExceptionDTM.fromExclusion(iUrlExclusion));
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                logger.error("Problem processing url exclusion {}", (Object)iUrlExclusion.getName(), (Object)throwable2);
            }
        }
    }

    private void parseInputExclusions(List<? extends IInputExclusion> list) {
        if (list == null) {
            return;
        }
        for (IInputExclusion iInputExclusion : list) {
            try {
                this.inputExclusionManager.a(InputExceptionDTM.fromExclusion(iInputExclusion));
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                logger.error("Problem processing input exclusion {}", (Object)iInputExclusion.getName(), (Object)throwable2);
            }
        }
    }

    private void parseQueueExclusions(List<? extends IQueueExclusion> list) {
        if (list == null) {
            return;
        }
        for (IQueueExclusion iQueueExclusion : list) {
            try {
                this.queueExclusionManager.a(QueueExclusionDTM.fromExclusion(iQueueExclusion));
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                logger.error("Problem processing queue exclusion {}", (Object)iQueueExclusion.getName(), (Object)throwable2);
            }
        }
    }
}

