/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.http;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.context.ExecutionContext;
import com.contrastsecurity.agent.context.RequestContext;
import com.contrastsecurity.agent.context.RequestContextImpl;
import com.contrastsecurity.agent.contrastapi_v1_0.HttpRequestDTM;
import com.contrastsecurity.agent.contrastapi_v1_0.RequestMethod;
import com.contrastsecurity.agent.http.ContrastContentType;
import com.contrastsecurity.agent.http.FrameworkInfo;
import com.contrastsecurity.agent.http.MultipartItem;
import com.contrastsecurity.agent.http.StandardHttpHeader;
import com.contrastsecurity.agent.http.c;
import com.contrastsecurity.agent.http.g;
import com.contrastsecurity.agent.k.i;
import com.contrastsecurity.agent.messages.HttpVersion;
import com.contrastsecurity.agent.messages.Protocol;
import com.contrastsecurity.agent.messages.mq.MqHttpRequestDTM;
import com.contrastsecurity.agent.plugins.route.RouteObservationProcessor;
import com.contrastsecurity.agent.plugins.security.sampling.d;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.math.NumberUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

@DontObfuscate
@HeapUsage.SupportsHeapProfiling
public final class HttpRequest
extends c
implements d {
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.JVM_GLOBAL)
    private final Protocol protocol;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.JVM_GLOBAL)
    private final HttpVersion httpVersion;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.JVM_GLOBAL)
    private final RequestMethod requestMethod;
    @HeapUsage.Deep
    private final String uri;
    @HeapUsage.Deep
    private final String normalizedUri;
    @HeapUsage.Deep
    private final String queryString;
    @HeapUsage.Deep
    private final String remoteIp;
    private final int port;
    @HeapUsage.Deep
    private final Map<String, String[]> parameters;
    @HeapUsage.Deep
    private final Map<String, String[]> headers;
    @HeapUsage.Deep
    private final String contextPath;
    @HeapUsage.Deep
    private final String serverVersionInfo;
    @HeapUsage.Deep
    private final WeakReference<Object> referentRequestObj;
    private final int requestID;
    @HeapUsage.Deep
    private final com.contrastsecurity.agent.k.g jfrEvent;
    private final boolean secure;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.JVM_GLOBAL)
    private final HttpRequestType httpRequestType;
    @HeapUsage.Deep
    private final String samplingKey;
    @HeapUsage.Deep
    private final Map<g, Boolean> sampling = Collections.synchronizedMap(new EnumMap(g.class));
    @HeapUsage.Deep
    private final String path;
    @HeapUsage.Deep
    private final String[] xForwardedForHeaders;
    @HeapUsage.Deep
    private final String xForwardedForHeadersAsString;
    private final int contentLength;
    @HeapUsage.Deep
    private final ContrastContentType contentType;
    @HeapUsage.Deep
    private final Set<MultipartItem> multipartItems;
    private final long startTime;
    @HeapUsage.Deep
    private final RequestContextImpl context;
    @HeapUsage.Deep
    private final AtomicBoolean active = new AtomicBoolean(true);
    private boolean parsedParameters;
    private boolean parsedMultipartParameters;
    @HeapUsage.Deep
    private FrameworkInfo frameworkInfo;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    private String template;
    @HeapUsage.Deep
    private String normalizedTemplate;
    private boolean checkedForDeserializer;
    @q
    static final int REQUEST_BODY_STRING_LIMIT = 4096;
    public static final ExecutionContext.Key<String> PROCEDURE = ExecutionContext.Key.create(String.class);
    private static final String DEFAULT_REMOTE_IP = "0.0.0.0";
    private static final Logger logger = LoggerFactory.getLogger(HttpRequest.class);

    public HttpRequest(HttpRequestType httpRequestType, Object object, String string, Map<String, String[]> map, RequestMethod requestMethod, Protocol protocol, HttpVersion httpVersion, String string2, String string3, Map<String, String[]> map2, String string4, int n2, String string5, boolean bl2) {
        super(c.a.a);
        this.requestID = System.identityHashCode(this);
        this.multipartItems = new HashSet<MultipartItem>();
        this.startTime = System.nanoTime();
        this.context = new RequestContextImpl();
        this.jfrEvent = i.b();
        this.httpRequestType = Objects.requireNonNull(httpRequestType);
        this.referentRequestObj = new WeakReference<Object>(object);
        this.contextPath = StringUtils.defaultIfBlank(string, "");
        TreeMap<String, String[]> treeMap = new TreeMap<String, String[]>(String.CASE_INSENSITIVE_ORDER);
        if (map != null) {
            treeMap.putAll(map);
        }
        this.headers = Collections.unmodifiableMap(treeMap);
        this.requestMethod = Objects.requireNonNull(requestMethod);
        this.protocol = protocol != null ? protocol : Protocol.FALLBACK_VALUE;
        this.httpVersion = httpVersion != null ? httpVersion : HttpVersion.FALLBACK_VALUE;
        this.uri = Objects.requireNonNull(string2);
        this.normalizedUri = com.contrastsecurity.agent.util.q.a(string2);
        this.path = HttpRequest.calculatePath(string2, string);
        this.queryString = string3;
        this.parameters = map2 != null ? new HashMap<String, String[]>(map2) : new HashMap();
        this.remoteIp = string4 != null ? string4 : DEFAULT_REMOTE_IP;
        this.port = n2;
        this.serverVersionInfo = string5;
        this.secure = this.protocol == Protocol.HTTPS || bl2;
        this.samplingKey = this.requestMethod + this.normalizedUri;
        this.xForwardedForHeaders = this.getMultiValueHeader(StandardHttpHeader.X_FORWARDED_FOR.headerName());
        this.xForwardedForHeadersAsString = HttpRequest.calculateXForwardedForString(this.xForwardedForHeaders);
        this.contentLength = HttpRequest.calculateContentLength(this.getHeader(StandardHttpHeader.CONTENT_LENGTH.headerName()));
        this.contentType = ContrastContentType.parse(this.getHeader(StandardHttpHeader.CONTENT_TYPE.headerName()));
    }

    public static boolean isOfType(HttpRequest httpRequest, HttpRequestType httpRequestType) {
        return httpRequest != null && httpRequest.httpRequestType == httpRequestType;
    }

    @Override
    public String samplingKey() {
        return this.samplingKey;
    }

    @Override
    public boolean samplingSetScope() {
        return true;
    }

    boolean isSampling(g g2, Function<g, Boolean> function) {
        return this.sampling.computeIfAbsent(g2, function);
    }

    public int getRequestID() {
        return this.requestID;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getPath() {
        return this.path;
    }

    public WeakReference<Object> getOriginalRequest() {
        return this.referentRequestObj;
    }

    public boolean isActive() {
        return this.active.get();
    }

    public boolean endRequest() {
        return this.active.getAndSet(false);
    }

    public boolean isSameRequest(Object object) {
        if (object == null || this.referentRequestObj == null) {
            return false;
        }
        return this.referentRequestObj.get() == object;
    }

    public boolean isCurrentActiveRequest(Object object) {
        return this.isActive() && this.isSameRequest(object);
    }

    public RequestContext context() {
        return this.context;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String[] getXForwardedFor() {
        return this.xForwardedForHeaders;
    }

    public String getXForwardedForAsString() {
        return this.xForwardedForHeadersAsString;
    }

    public ContrastContentType getContentType() {
        return this.contentType;
    }

    @Override
    protected Charset getCharset() {
        return this.contentType.getCharset();
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public RequestMethod getMethod() {
        return this.requestMethod;
    }

    public String getUri() {
        return this.uri;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void addMultipartItem(MultipartItem multipartItem) {
        this.multipartItems.add(multipartItem);
    }

    public Set<MultipartItem> getMultipartItems() {
        return this.multipartItems;
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public Map<String, String[]> getHeaders() {
        return this.headers;
    }

    public String[] getMultiValueHeader(String string) {
        if (this.headers.isEmpty() || StringUtils.isBlank(string)) {
            return null;
        }
        return this.headers.get(string);
    }

    public String getHeader(String string) {
        String[] stringArray = this.getMultiValueHeader(string);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }

    public String getTemplate() {
        return this.template;
    }

    public String getNormalizedTemplate() {
        return this.normalizedTemplate;
    }

    @Deprecated
    public void setTemplate(String string) {
        if (string == null) {
            return;
        }
        this.template = string.length() > 1 && string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
        this.normalizedTemplate = com.contrastsecurity.agent.util.q.a(this.template);
    }

    public boolean isParametersResolved() {
        return this.parsedParameters;
    }

    public HttpRequest resolvedParameters() {
        this.parsedParameters = true;
        return this;
    }

    public boolean isMultipartParametersResolved() {
        return this.parsedMultipartParameters;
    }

    public HttpRequest resolvedMultipartParameters() {
        this.parsedMultipartParameters = true;
        return this;
    }

    public String getCookie() {
        return this.getHeader("Cookie");
    }

    public HttpVersion getHttpVersion() {
        return this.httpVersion;
    }

    public int getPort() {
        return this.port;
    }

    public String getNormalizedUri() {
        return this.normalizedUri;
    }

    public String getRemoteIp() {
        return this.remoteIp;
    }

    public String getServerVersionInfo() {
        return this.serverVersionInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String getBody() {
        int n2;
        StringBuilder stringBuilder;
        block12: {
            int n3 = Math.min(this.getBufferSize(), 4096);
            try {
                InputStream inputStream = this.getBufferAsStream();
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, this.getCharset()), n3);
                    try {
                        int n4;
                        stringBuilder = new StringBuilder(n3);
                        for (n2 = 0; n2 <= 4096 && (n4 = bufferedReader.read()) != -1; ++n2) {
                            stringBuilder.append((char)n4);
                        }
                    }
                    catch (Throwable throwable) {
                        Throwables.throwIfCritical(throwable);
                        Throwable throwable2 = throwable;
                        try {
                            bufferedReader.close();
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            Throwables.throwIfCritical(throwable3);
                            Throwable throwable4 = throwable3;
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                    bufferedReader.close();
                    if (inputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable5 = throwable;
                    if (inputStream == null) throw throwable5;
                    try {
                        inputStream.close();
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        Throwables.throwIfCritical(throwable6);
                        Throwable throwable7 = throwable6;
                        throwable5.addSuppressed(throwable7);
                    }
                    throw throwable5;
                }
                inputStream.close();
            }
            catch (IOException iOException) {
                logger.warn("There was an error converting the HttpRequest body to a String", iOException);
                return null;
            }
        }
        if (!this.hasOverflowed()) {
            if (n2 <= 4096) return stringBuilder.toString();
        }
        stringBuilder.append("...");
        return stringBuilder.toString();
    }

    @Override
    public void setBody(String string) {
        super.setBody(string);
    }

    public boolean isCheckedForDeserializer() {
        return this.checkedForDeserializer;
    }

    public void setCheckedForDeserializer(boolean bl2) {
        this.checkedForDeserializer = bl2;
    }

    @Override
    protected String getAdditionalBreadCrumbInfo() {
        return this.uri;
    }

    public long startTimeNs() {
        return this.startTime;
    }

    public com.contrastsecurity.agent.k.g getJfrEvent() {
        return this.jfrEvent;
    }

    public boolean hasBeenObserved() {
        return this.context().get(RouteObservationProcessor.CURRENT_OBSERVED_ROUTE) != null;
    }

    public String toString() {
        return "HttpRequest{protocol=" + (Object)((Object)this.protocol) + ", version=" + (Object)((Object)this.httpVersion) + ", method='" + this.requestMethod + '\'' + ", uri='" + this.uri + '\'' + ", queryString='" + this.queryString + '\'' + ", normalizedUri='" + this.normalizedUri + '\'' + ", port=" + this.port + ", parameters=" + this.parameters + ", headers=" + this.headers + ", contextPath='" + this.contextPath + '\'' + ", serverVersionInfo='" + this.serverVersionInfo + '\'' + ", contentLength=" + this.contentLength + ", cachedContentType=" + this.contentType + ", requestID=" + this.requestID + ", template='" + this.template + '\'' + ", normalizedTemplate='" + this.normalizedTemplate + '\'' + ", path='" + this.path + '\'' + ", secure=" + this.secure + ", type=" + (Object)((Object)this.httpRequestType) + ", active=" + this.active + ", capturingInMemory=" + this.isCapturingEnabled() + '}';
    }

    public void setFrameworkInfo(FrameworkInfo frameworkInfo) {
        this.frameworkInfo = frameworkInfo;
    }

    public Optional<FrameworkInfo> getFrameworkInfo() {
        return Optional.ofNullable(this.frameworkInfo);
    }

    public MqHttpRequestDTM toMqHttpRequestDTM() {
        return MqHttpRequestDTM.builder().body(this.getBufferAsString()).contextPath(this.contextPath).headers(this.headers).method(this.requestMethod.methodName()).parameters(this.parameters).port(this.port).protocol(this.protocol).queryString(this.queryString).serverVersionInfo(this.serverVersionInfo).isSecure(this.secure).uri(this.uri).version(this.getHttpVersion()).build();
    }

    public HttpRequestDTM toHttpRequestDTM() {
        HttpRequestDTM.Builder builder = HttpRequestDTM.builder().method(this.getMethod().methodName()).port(this.getPort()).protocol(this.getProtocol()).uri(this.getUri()).version(this.getHttpVersion()).contextPath(this.getContextPath()).normalizedUri(this.getNormalizedUri()).serverVersionInfo(this.getServerVersionInfo()).requestID(this.getRequestID()).parameters(this.parameters != null ? HttpRequest.convertRequestMap(this.parameters) : null).queryString(this.getQueryString()).headers(this.headers != null ? HttpRequest.convertRequestMap(this.headers) : null).body(this.getBufferAsString()).isFormEncodedContentType(this.getContentType().isFormEncodedContentType()).isMultipartContentType(this.getContentType().isMultipart()).isXMLContentType(this.getContentType().isXml()).boundary(this.getContentType().getMultipartBoundary()).template(this.getTemplate()).normalizedTemplate(this.getNormalizedTemplate()).path(this.getPath()).normalizedPath(com.contrastsecurity.agent.util.q.a(this.getPath()));
        return builder.build();
    }

    @q
    static Map<String, List<String>> convertRequestMap(Map<String, String[]> map) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (String string : map.keySet()) {
            hashMap.put(string, Arrays.asList(map.get(string)));
        }
        return hashMap;
    }

    private static int calculateContentLength(String string) {
        if (string == null || "0".equals(string)) {
            return 0;
        }
        return (int)Math.min(Math.max(NumberUtils.toLong(string.trim()), 0L), Integer.MAX_VALUE);
    }

    private static String calculateXForwardedForString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (c2 == ' ') continue;
                stringBuilder.append(c2);
            }
            stringBuilder.append(",");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private static String calculatePath(String string, String string2) {
        int n2 = string.indexOf(59);
        int n3 = string2 == null ? -1 : string.indexOf(string2);
        String string3 = string.substring(n3 == -1 ? 0 : n3 + string2.length(), n2 == -1 ? string.length() : n2);
        string3 = string3.startsWith("/") ? string3 : "/" + string3;
        try {
            string3 = URLDecoder.decode(string3, Charset.defaultCharset().toString());
        }
        catch (UnsupportedEncodingException | IllegalArgumentException exception) {
            // empty catch block
        }
        return string3;
    }

    @DontObfuscate
    public static enum HttpRequestType {
        AKKA,
        GRIZZLY,
        GRPC,
        J2EE,
        JAVA_RMI,
        JDK_HTTP,
        MULESOFT,
        NETTY,
        UNDERTOW,
        XENON;

    }
}

