/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.http;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.http.HttpHeader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@DontObfuscate
public enum StandardHttpHeader implements HttpHeader
{
    ACCEPT("Accept"),
    ACCEPT_CHARSET("Accept-Charset"),
    ACCEPT_ENCODING("Accept-Encoding"),
    ACCEPT_LANGUAGE("Accept-Language"),
    ACCEPT_RANGES("Accept-Ranges"),
    AGE("Age"),
    ALLOW("Allow"),
    AUTHORIZATION("Authorization"),
    CACHE_CONTROL("Cache-Control"),
    CONNECTION("Connection"),
    CONTENT_DISPOSITION("Content-Disposition"),
    CONTENT_ENCODING("Content-Encoding"),
    CONTENT_LANGUAGE("Content-Language"),
    CONTENT_LENGTH("Content-Length"),
    CONTENT_LOCATION("Content-Location"),
    CONTENT_MD5("Content-MD5"),
    CONTENT_RANGE("Content-Range"),
    CONTENT_SECURITY_POLICY("Content-Security-Policy"),
    CONTENT_SECURITY_POLICY_REPORT_ONLY("Content-Security-Policy-Report-Only"),
    CONTENT_TYPE("Content-Type"),
    DATE("Date"),
    DAV("Dav"),
    DEPTH("Depth"),
    DESTINATION("Destination"),
    ETAG("ETag"),
    EXPECT("Expect"),
    EXPIRES("Expires"),
    FROM("From"),
    HOST("Host"),
    IF("If"),
    IF_MATCH("If-Match"),
    IF_MODIFIED_SINCE("If-Modified-Since"),
    IF_NONE_MATCH("If-None-Match"),
    IF_RANGE("If-Range"),
    IF_UNMODIFIED_SINCE("If-Unmodified-Since"),
    LAST_MODIFIED("Last-Modified"),
    LOCATION("Location"),
    LOCK_TOKEN("Lock-Token"),
    MAX_FORWARDS("Max-Forwards"),
    OVERWRITE("Overwrite"),
    PRAGMA("Pragma"),
    PROXY_AUTHENTICATE("Proxy-Authenticate"),
    PROXY_AUTHORIZATION("Proxy-Authorization"),
    RANGE("Range"),
    REFERER("Referer"),
    REMOTE_ADDRESS("Remote-Address"),
    RETRY_AFTER("Retry-After"),
    SERVER("Server"),
    STATUS_URI("Status-URI"),
    STRICT_TRANSPORT_SECURITY("Strict-Transport-Security"),
    TE("TE"),
    TIMEOUT("Timeout"),
    TRAILER("Trailer"),
    TRANSFER_ENCODING("Transfer-Encoding"),
    UPGRADE("Upgrade"),
    USER_AGENT("User-Agent"),
    VARY("Vary"),
    VIA("Via"),
    WARNING("Warning"),
    WWW_AUTHENTICATE("WWW-Authenticate"),
    X_CONTENT_TYPE_OPTIONS("X-Content-Type-Options"),
    X_FORWARDED_BY("X-Forwarded-By"),
    X_FORWARDED_FOR("X-Forwarded-For"),
    X_FORWARDED_HOST("X-Forwarded-Host"),
    X_FORWARDED_PROTO("X-Forwarded-Proto"),
    X_FRAME_OPTIONS("X-Frame-Options"),
    X_CONTENT_SECURITY_POLICY("X-Content-Security-Policy"),
    X_WEBKIT_CSP("X-Webkit-CSP"),
    X_XSS_PROTECTION("X-XSS-Protection");

    private final String headerName;
    static final Map<String, HttpHeader> HEADER_NAME_MAP;

    private StandardHttpHeader(String string2) {
        this.headerName = string2;
    }

    @Override
    public String headerName() {
        return this.headerName;
    }

    static {
        HashMap<String, StandardHttpHeader> hashMap = new HashMap<String, StandardHttpHeader>(StandardHttpHeader.values().length);
        for (StandardHttpHeader standardHttpHeader : StandardHttpHeader.values()) {
            hashMap.put(standardHttpHeader.headerName.toUpperCase(), standardHttpHeader);
        }
        HEADER_NAME_MAP = new ConcurrentHashMap<String, HttpHeader>(hashMap);
    }
}

