/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.architecture.controller;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.context.ExecutionContext;
import com.contrastsecurity.agent.plugins.architecture.ApplicationArchitecture;
import com.contrastsecurity.agent.plugins.architecture.model.ArchitectureComponent;
import com.contrastsecurity.agent.services.a.d;
import com.contrastsecurity.agent.test.integration.IntegrationTestServices;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.Objects;
import java.util.function.Supplier;

@DontObfuscate
public final class ArchitectureComponentReporter {
    public static final ExecutionContext.Key<ApplicationArchitecture> KEY = ExecutionContext.Key.create(ApplicationArchitecture.class);
    private final d<ArchitectureComponent> reporter;
    private final Clock clock;
    private static final Supplier<ApplicationArchitecture> APPLICATION_ARCHITECTURE_FACTORY = ApplicationArchitecture::create;
    private static final Logger logger = LoggerFactory.getLogger(ArchitectureComponentReporter.class);

    public ArchitectureComponentReporter(d<ArchitectureComponent> d2, Clock clock) {
        this.reporter = d2;
        this.clock = Objects.requireNonNull(clock);
    }

    public void report(Application application, ArchitectureComponent architectureComponent) {
        ApplicationArchitecture applicationArchitecture = application.context().getOrComputeIfAbsent(KEY, APPLICATION_ARCHITECTURE_FACTORY);
        if (architectureComponent == null) {
            logger.debug("Discovered architecture component was null, not sending report");
            return;
        }
        if (applicationArchitecture.addComponent(architectureComponent, this.clock.now())) {
            logger.debug("Sending newly discovered architecture component: {}", (Object)architectureComponent);
            application.getActivity().addArchitecture(architectureComponent);
            application.markDirty(Application.b.a);
            if (IntegrationTestServices.isEnabled()) {
                IntegrationTestServices.getInstance().addArchitectureComponent(architectureComponent);
            }
            if (this.reporter != null) {
                this.reporter.a(application, architectureComponent);
            }
        }
    }
}

