/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.j2ee;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.http.ContrastContentType;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.http.HttpResponseFactory;
import com.contrastsecurity.agent.http.HttpResponseReflector;
import com.contrastsecurity.agent.reflection.Reflect;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;

@DontObfuscate
public class J2EEHttpResponseFactory
implements HttpResponseFactory {
    private final HttpResponseReflector reflector;
    private static final Logger logger = LoggerFactory.getLogger(J2EEHttpResponseFactory.class);

    public J2EEHttpResponseFactory(final Object object) {
        this.reflector = new HttpResponseReflector(){

            @Override
            public int status() {
                Reflect reflect = Reflect.reflect(object, logger);
                int n2 = reflect.invokeCached("getStatus").asInt(-1);
                if (n2 != -1) {
                    return n2;
                }
                return reflect.reset(object).fieldCached("response").invokeCached("getStatus").asInt(-1);
            }

            @Override
            public ContrastContentType frameworkContentType() {
                return ContrastContentType.parse(Reflect.reflect(object, logger).invokeCached("getContentType").asNullableString());
            }
        };
    }

    @Override
    public HttpResponse create() {
        return new HttpResponse(HttpResponse.HttpResponseType.J2EE, this.reflector);
    }
}

