/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.ldap;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.b;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.architecture.controller.ArchitectureComponentReporter;
import com.contrastsecurity.agent.plugins.architecture.model.ArchitectureComponent;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;

@DontObfuscate
@o
public final class ContrastLdapDispatcherImpl
implements ContrastLdapDispatcher {
    private final Config config;
    private final ArchitectureComponentReporter architectureComponentReporter;
    private static final Logger logger = LoggerFactory.getLogger(ContrastLdapDispatcherImpl.class);

    public ContrastLdapDispatcherImpl(Config config, ArchitectureComponentReporter architectureComponentReporter) {
        this.config = config;
        this.architectureComponentReporter = architectureComponentReporter;
    }

    public void onLdapQuerying(Object object, Hashtable<?, ?> hashtable) {
        ContrastContext contrastContext = (ContrastContext)object;
        if (contrastContext.scopeArchitecture().inScope()) {
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null || hashtable == null) {
            return;
        }
        String string = (String)hashtable.get("java.naming.provider.url");
        if (StringUtils.isEmpty(string)) {
            return;
        }
        this.parseProviderUrl(application, string);
    }

    @q
    void parseProviderUrl(Application application, String string) {
        if (!b.a(this.config, ConfigProperty.INVENTORY_MONITOR_LDAP)) {
            return;
        }
        if (string == null) {
            logger.debug("Invalid LDAP URL: NULL");
            return;
        }
        for (String string2 : StringUtils.split(string, " ,")) {
            try {
                URI uRI = new URI(string2);
                String string3 = uRI.getScheme();
                if (!StringUtils.equalsIgnoreCase("ldap", string3) && !StringUtils.equalsIgnoreCase("ldaps", string3)) continue;
                String string4 = uRI.getHost();
                String string5 = String.valueOf(uRI.getPort());
                this.architectureComponentReporter.report(application, ArchitectureComponent.ldapFrom(string3, string4, string5));
            }
            catch (URISyntaxException uRISyntaxException) {
                logger.debug("Invalid LDAP URL: {}", (Object)string2, (Object)uRISyntaxException);
            }
        }
    }
}

