/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.netty;

import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.commons.Preconditions;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ConcurrencyContext;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.frameworks.g;
import com.contrastsecurity.agent.plugins.frameworks.netty.f;
import com.contrastsecurity.agent.plugins.frameworks.netty.h;
import com.contrastsecurity.agent.plugins.frameworks.netty.k;
import com.contrastsecurity.agent.plugins.protect.AttackBlockedException;
import com.contrastsecurity.agent.plugins.protect.ProtectManager;
import com.contrastsecurity.agent.reflection.Reflect;
import com.contrastsecurity.agent.shim.ShimCache;
import com.contrastsecurity.agent.telemetry.errors.TelemetryErrorEmitter;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.agent.util.e;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

@o
public final class a
implements ContrastNettyDispatcher {
    private final ApplicationManager a;
    private final HttpManager b;
    private final ProtectManager c;
    private final Config d;
    private final ShimCache e;
    private final TelemetryErrorEmitter f;
    private static final List<String> g = Lists.of("com.contrastsecurity.agent.plugins.frameworks.netty.shim.NettyBlockerImpl$BlockingHandlerAdapter");
    private static final Logger h = LoggerFactory.getLogger(a.class);

    public a(ApplicationManager applicationManager, HttpManager httpManager, ProtectManager protectManager, Config config, ShimCache shimCache, TelemetryErrorEmitter telemetryErrorEmitter) {
        this.a = applicationManager;
        this.b = httpManager;
        this.c = protectManager;
        this.d = config;
        this.e = shimCache;
        this.f = telemetryErrorEmitter;
    }

    public void onApplicationCreated() {
        Application application = this.a.enableStandaloneModeFromEmbedded("Netty Application", "/", com.contrastsecurity.agent.plugins.frameworks.g.f);
        application.context().put(com.contrastsecurity.agent.plugins.frameworks.netty.h.a, true);
        application.addTechnology("netty");
    }

    public void onRequestDecoded(Object object, Object object2, Object object3, List<?> list) {
        Object object42;
        if (object2 == null || object3 == null || list == null || list.isEmpty()) {
            h.debug("Netty HttpObjectDecoder was null or ChannelHandlerContext was null or CodecOutputList was null or empty");
            return;
        }
        Object var6_5 = null;
        for (Object object42 : list) {
            if (!com.contrastsecurity.agent.plugins.frameworks.netty.a.a(object42, "io.netty.handler.codec.http.HttpRequest")) continue;
            var6_5 = object42;
            break;
        }
        if (var6_5 == null) {
            h.debug("Could not find decoded HttpRequest, nothing to do");
            return;
        }
        f f2 = new f(var6_5, object3);
        object42 = (ContrastContext)object;
        try {
            this.b.onRequestStart((ContrastContext)object42, f2);
        }
        catch (AttackBlockedException attackBlockedException) {
            this.a(attackBlockedException, object3, var6_5);
        }
        if (f2.a()) {
            try {
                this.b.onParametersResolved((ContrastContext)object42);
            }
            catch (AttackBlockedException attackBlockedException) {
                this.a(attackBlockedException, object3, var6_5);
            }
        }
        if (h.isDebugEnabled()) {
            Reflect reflect = Reflect.reflect(h);
            Object object5 = k.a(reflect, object3);
            String string = com.contrastsecurity.agent.plugins.frameworks.netty.a.a(reflect, object2);
            h.debug("ContrastNettyHttpDispatcherImpl.onRequestDecoded({}, {}, {}) with channel {} and decoderState {}", ((ContrastContext)object42).toSummaryString(), JVMUtils.getSafeToString(object2, true), JVMUtils.getSafeToString(var6_5, true), JVMUtils.getSafeToString(object5, true), string);
        }
    }

    public boolean onFireChannelRead(Object object, Object object2, Class<?> clazz) {
        Reflect reflect = Reflect.reflect(h);
        ConcurrencyContext concurrencyContext = k.a(reflect, object2, clazz);
        if (concurrencyContext != null) {
            concurrencyContext.change(object);
        }
        return false;
    }

    public void onResponseWritten(Object object, Object object2, Object object3) {
        Object object4;
        ContrastContext contrastContext = (ContrastContext)object;
        if (h.isDebugEnabled()) {
            object4 = Reflect.reflect(h);
            Object object5 = k.a((Reflect)object4, object2);
            h.debug("ContrastNettyHttpDispatcherImpl.onResponseWritten({}, {}, {}) with channel {}", contrastContext.toSummaryString(), JVMUtils.getSafeToString(object2), JVMUtils.getSafeToString(object3), JVMUtils.getSafeToString(object5, true));
        }
        if ((object4 = contrastContext.http().getRequest()) == null) {
            return;
        }
        if (!com.contrastsecurity.agent.plugins.frameworks.netty.a.a(object3, "io.netty.handler.codec.http.HttpResponse")) {
            return;
        }
        if (contrastContext.http().getResponse() == null) {
            this.b.onResponseStart(contrastContext, new com.contrastsecurity.agent.plugins.frameworks.netty.g(this.b, object3));
        }
        this.b.onRequestEnd(contrastContext);
    }

    public void onPostBodyReadAsParameters(Object object, Object object2) {
        HttpRequest httpRequest;
        ContrastContext contrastContext = (ContrastContext)object;
        h.trace("Reading HTTP parameters");
        if (this.d.getBoolean(ConfigProperty.PROTECT_ENABLED)) {
            this.c.checkParameterAccess(contrastContext);
        }
        if (h.isDebugEnabled()) {
            h.debug("ContrastNettyHttpDispatcherImpl.onPostBodyReadAsParameters({}, {})", (Object)((ContrastContext)object).toSummaryString(), (Object)JVMUtils.getSafeToString(object2));
        }
        if ((httpRequest = contrastContext.http().getRequest()) != null) {
            this.a(contrastContext, object2, httpRequest);
        }
    }

    private void a(ContrastContext contrastContext, Object object, HttpRequest httpRequest) {
        String[] stringArray;
        Reflect reflect = Reflect.reflect(object, h);
        boolean bl2 = reflect.field("isLastChunk").asBoolean(false);
        if (!bl2) {
            return;
        }
        List list = reflect.reset(object).invoke("getBodyHttpDatas").as(List.class, Collections.emptyList());
        if (list.isEmpty()) {
            return;
        }
        HashMap<String, List> hashMap = new HashMap<String, List>();
        for (Object object2 : list) {
            if (object2 == null) continue;
            String string2 = reflect.reset(object2).invoke("getName").asString();
            stringArray = object2.toString();
            stringArray = stringArray != null ? stringArray.substring(0, Math.min(stringArray.length(), string2.length())) : null;
            hashMap.computeIfAbsent(string2, string -> new ArrayList()).add(stringArray);
        }
        HashMap hashMap2 = new HashMap();
        for (String string2 : hashMap.keySet()) {
            stringArray = ((List)hashMap.get(string2)).toArray(Empty.STRING_ARRAY);
            hashMap2.put(string2, stringArray);
            httpRequest.getParameters().put(string2, stringArray);
        }
        this.b.onMoreParametersResolved(contrastContext, hashMap2);
    }

    private static boolean a(Object object, String string) {
        if (object == null) {
            return false;
        }
        Preconditions.checkNotEmpty(string);
        h.trace("Attempting to load Netty HTTP class: {}", (Object)string);
        Class<?> clazz = object.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        Class<?> clazz2 = com.contrastsecurity.agent.util.e.a(classLoader, string, h);
        if (clazz2 == null) {
            return false;
        }
        h.trace("Loaded Netty HTTP class: {}", (Object)string);
        if (!clazz2.isAssignableFrom(clazz)) {
            h.debug("Netty message {} is not a HTTP message: {}. Skipping message.", (Object)clazz.getTypeName(), (Object)string);
            return false;
        }
        return true;
    }

    private static String a(Reflect reflect, Object object) {
        if (object == null) {
            return null;
        }
        if (!"io.netty.handler.codec.http.HttpServerCodec$HttpServerRequestDecoder".equals(object.getClass().getTypeName())) {
            return null;
        }
        return reflect.reset(object).field("currentState").asString("null");
    }

    private void a(AttackBlockedException attackBlockedException, Object object, Object object2) {
        this.e.get(com.contrastsecurity.agent.plugins.frameworks.netty.shim.a.class, com.contrastsecurity.agent.plugins.frameworks.netty.shim.a.a, "com.contrastsecurity.agent.plugins.frameworks.netty.shim.NettyBlockerImpl", g, object).blockRequest(object, object2, attackBlockedException.getMessage(), this.f);
        throw attackBlockedException;
    }
}

