/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.netty.shim;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.plugins.frameworks.netty.shim.a;
import com.contrastsecurity.agent.telemetry.errors.TelemetryErrorEmitter;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;

@DontObfuscate
public final class NettyBlockerImpl
implements a {
    ChannelFutureListener dummyChannelFutureListener;
    ChannelHandlerContext dummyContext;
    ChannelInboundHandlerAdapter dummyInboundHandlerAdapter;
    ChannelPipeline dummyChannelPipeline;
    DefaultFullHttpResponse dummyFullHttpResponse;
    FullHttpResponse dummyFullHttpResponse2;
    HttpResponseStatus dummyHttpResponseStatus;
    HttpRequest dummyHttpRequest;
    AttributeKey<Boolean> dummyAttributeKey;
    ReferenceCountUtil dummyReferenceCountUtil;
    private static final Logger logger = LoggerFactory.getLogger(NettyBlockerImpl.class);

    @Override
    public void blockRequest(Object object, Object object2, String string, TelemetryErrorEmitter telemetryErrorEmitter) {
        try {
            if (!(object instanceof ChannelHandlerContext)) {
                logger.warn("ChannelHandlerContext is not the expected type, cannot block request");
                return;
            }
            ChannelHandlerContext channelHandlerContext = (ChannelHandlerContext)object;
            ChannelPipeline channelPipeline = channelHandlerContext.pipeline();
            String string2 = channelPipeline.context(channelHandlerContext.handler()).name();
            if (string2 == null) {
                logger.debug("ChannelHandlerContext name is null, cannot add blocking handler");
                return;
            }
            logger.trace("Adding contrast-block-handler after {}", (Object)string2);
            channelPipeline.addAfter(string2, "contrast-block-handler", (ChannelHandler)new BlockingHandlerAdapter(string, telemetryErrorEmitter));
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.debug("Error while blocking request", throwable2);
            telemetryErrorEmitter.emit(throwable2);
        }
    }

    @DontObfuscate
    private static final class BlockingHandlerAdapter
    extends ChannelInboundHandlerAdapter {
        private final TelemetryErrorEmitter emitter;
        private final String message;

        private BlockingHandlerAdapter(String string, TelemetryErrorEmitter telemetryErrorEmitter) {
            this.message = string;
            this.emitter = telemetryErrorEmitter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
            try {
                if (object instanceof HttpRequest) {
                    HttpRequest httpRequest = (HttpRequest)object;
                    DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(httpRequest.protocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR);
                    byte[] byArray = this.message.getBytes(StandardCharsets.UTF_8);
                    HttpHeaders httpHeaders = defaultFullHttpResponse.headers();
                    httpHeaders.set("Content-Length", (Object)byArray.length);
                    httpHeaders.set("Content-Type", (Object)"text/plain; charset=UTF-8");
                    httpHeaders.set("Connection", (Object)"close");
                    defaultFullHttpResponse.content().writeBytes(byArray);
                    channelHandlerContext.writeAndFlush((Object)defaultFullHttpResponse).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    channelHandlerContext.pipeline().remove((ChannelHandler)this);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Blocked request: {}", (Object)JVMUtils.getSafeToString(httpRequest, true));
                    }
                }
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                logger.debug("Error in BlockingHandlerAdapter.channelRead", throwable2);
                this.emitter.emit(throwable2);
            }
            finally {
                ReferenceCountUtil.release((Object)object);
                super.channelRead(channelHandlerContext, object);
            }
        }
    }
}

