/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.tomcat;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.security.controller.EventContext;
import com.contrastsecurity.agent.plugins.security.controller.maps.TraceMap;
import com.contrastsecurity.agent.reflection.Reflect;
import com.contrastsecurity.agent.scope.ScopeType;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;

@DontObfuscate
@o
final class ContrastTomcatAssessDispatcherImpl
implements ContrastTomcatAssessDispatcher {
    private final Config config;
    private final EventContext eventContext;
    static final String COYOTE_OUTPUT_STREAM = "org.apache.catalina.connector.CoyoteOutputStream";
    private static final Logger logger = LoggerFactory.getLogger(ContrastTomcatAssessDispatcherImpl.class);

    public ContrastTomcatAssessDispatcherImpl(Config config, EventContext eventContext) {
        this.config = config;
        this.eventContext = eventContext;
    }

    public void onRecycleBytes(Object object, Object object2) {
        this.removeBuffArray((ContrastContext)object, object2);
    }

    public void onRecycleChars(Object object, Object object2) {
        this.removeBuffArray((ContrastContext)object, object2);
    }

    private void removeBuffArray(ContrastContext contrastContext, Object object) {
        if (!this.config.getBoolean(ConfigProperty.ASSESS_ENABLED) || contrastContext.scope().isUnscoped(ScopeType.TOMCAT_REQUEST_CYCLE)) {
            return;
        }
        TraceMap traceMap = this.eventContext.getTraceMap(contrastContext.assessment());
        traceMap.remove(Reflect.reflect(object, logger).field("buff").asNullable(Object.class));
    }

    public void onRecycleRequestStart(Object object) {
        ((ContrastContext)object).scope().set(ScopeType.TOMCAT_REQUEST_CYCLE, 1);
    }

    public void onRecycleRequestEnd(Object object) {
        ((ContrastContext)object).scope().set(ScopeType.TOMCAT_REQUEST_CYCLE, 0);
    }

    public void onLoadConnectorPackage(ClassLoader classLoader) {
        try {
            classLoader.loadClass(COYOTE_OUTPUT_STREAM);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.debug("Attempted to preload the CoyoteOutputStream class to avoid accessibility issues but failed. This indicates that the current version of Tomcat is different than anticipated", classNotFoundException);
        }
    }
}

