/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.websphere;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.reflection.Reflect;
import com.contrastsecurity.agent.scope.ScopeType;
import com.contrastsecurity.thirdparty.omp.core.annotations.VisibleForTesting;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

@DontObfuscate
@o
public final class ContrastWebSphereDispatcherImpl
implements ContrastWebSphereDispatcher {
    private final HttpManager httpManager;
    @VisibleForTesting
    public static final AtomicInteger VERIFICATIONS_PREVENTED = new AtomicInteger(0);
    private static final Logger logger = LoggerFactory.getLogger(ContrastWebSphereDispatcherImpl.class);

    public ContrastWebSphereDispatcherImpl(HttpManager httpManager) {
        this.httpManager = httpManager;
    }

    public boolean shouldPreventVerification(Object object) {
        ContrastContext contrastContext = (ContrastContext)object;
        boolean bl2 = contrastContext.scope().inScope(ScopeType.WEBSPHERE_JAR_PREVENTION);
        if (bl2) {
            VERIFICATIONS_PREVENTED.incrementAndGet();
        }
        return bl2;
    }

    public void onMessageSent(Object object, Object object2) {
        Object object3;
        if (object2 == null) {
            logger.debug("HttpServiceContext was null");
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            logger.debug("HttpRequest was null");
            return;
        }
        Reflect reflect = Reflect.reflect(object2, logger);
        List list = reflect.reset(object3 = reflect.invoke("getResponse").asNullable(Object.class)).invoke("getAllHeaders").asNullable(List.class);
        if (list == null) {
            logger.debug("getAllHeaders returned null");
            return;
        }
        for (Object e2 : list) {
            String string;
            String string2;
            if (e2 instanceof String) {
                string2 = (String)e2;
                string = reflect.reset(object3).invoke("getHeaderAsString", string2).asNullableString();
            } else {
                string2 = reflect.reset(e2).invoke("getName").asNullableString();
                string = reflect.reset(e2).invoke("asString").asNullableString();
            }
            this.httpManager.onResponseHeaderSet(contrastContext, string2, string);
        }
    }

    public void onRequestEnd(Object object) {
        this.httpManager.onRequestEnd((ContrastContext)object);
    }
}

