/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe.java.j2ee;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.thirdparty.ccsso.semconv.ContrastSemanticAttributes;
import com.contrastsecurity.thirdparty.iot.api.common.Attributes;
import com.contrastsecurity.thirdparty.iot.api.trace.Span;
import com.contrastsecurity.thirdparty.iot.context.Context;

@DontObfuscate
@o
public class ContrastObserveJ2eeAuthDispatcherImpl
implements ContrastObserveJ2eeAuthDispatcher {
    private final Config config;

    ContrastObserveJ2eeAuthDispatcherImpl(Config config) {
        this.config = config;
    }

    public void onAuthentication(Object object, String string) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        RootSpan rootSpan = contrastContext.observe();
        if (rootSpan == null || !rootSpan.isRecording()) {
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        Span span = rootSpan.startChildSpan(contrastContext, "authn-request", string);
        if (span == null) {
            return;
        }
        span.end();
        rootSpan.popContext();
        application.otel().c().add(1L, Attributes.of(ContrastSemanticAttributes.ACTION, "authn-request", ContrastSemanticAttributes.HTTP_REQUEST_METHOD, rootSpan.getHttpMethod(), ContrastSemanticAttributes.HTTP_ROUTE, rootSpan.getHttpRoute()), span.storeInContext(Context.current()));
    }

    public void onRoleBasedAuthorization(Object object, String string, String string2) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        RootSpan rootSpan = contrastContext.observe();
        if (rootSpan == null || !rootSpan.isRecording()) {
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        Span span = rootSpan.startChildSpan(contrastContext, "authz-request", string2);
        if (span == null) {
            return;
        }
        span.setAttribute(ContrastSemanticAttributes.CONTRAST_AUTHORIZATION_MECHANISM, "rbac");
        span.setAttribute(ContrastSemanticAttributes.CONTRAST_AUTHORIZATION_RBAC_ROLE, string);
        span.end();
        rootSpan.popContext();
        application.otel().c().add(1L, Attributes.of(ContrastSemanticAttributes.ACTION, "authz-request", ContrastSemanticAttributes.HTTP_REQUEST_METHOD, rootSpan.getHttpMethod(), ContrastSemanticAttributes.HTTP_ROUTE, rootSpan.getHttpRoute()), span.storeInContext(Context.current()));
    }
}

