/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.protect;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.MultipartItem;
import com.contrastsecurity.agent.http.h;
import com.contrastsecurity.agent.messages.app.activity.protect.details.UserInputDTM;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.protect.AttackBlockedException;
import com.contrastsecurity.agent.plugins.protect.I;
import com.contrastsecurity.agent.plugins.protect.O;
import com.contrastsecurity.agent.plugins.protect.ProtectContext;
import com.contrastsecurity.agent.plugins.protect.ProtectInputScanner;
import com.contrastsecurity.agent.plugins.protect.ProtectManager;
import com.contrastsecurity.agent.plugins.protect.c;
import com.contrastsecurity.agent.plugins.protect.e;
import com.contrastsecurity.agent.plugins.protect.g.b;
import com.contrastsecurity.agent.plugins.protect.k.a;
import com.contrastsecurity.agent.plugins.protect.r;
import com.contrastsecurity.agent.plugins.protect.rules.k;
import com.contrastsecurity.agent.plugins.protect.v;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.Iterator;

@DontObfuscate
@o
final class MultipartScanner
extends ProtectInputScanner
implements h {
    private static final Logger logger = LoggerFactory.getLogger(MultipartScanner.class);

    MultipartScanner(b b2, Config config, ProtectManager protectManager, ProtectInputScanner.a a2, c c2, e e2) {
        super(b2, config, protectManager, a2, c2, e2);
    }

    @Override
    public void onHeaderRead(ContrastContext contrastContext, MultipartItem multipartItem) {
        ProtectContext protectContext = contrastContext.protect();
        if (protectContext.isAllowlisted()) {
            return;
        }
        try {
            this._onMultipartHeaderRead(contrastContext, multipartItem);
        }
        catch (AttackBlockedException attackBlockedException) {
            throw attackBlockedException;
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.error("Unexpected error processing multipart header", throwable2);
        }
    }

    private void _onMultipartHeaderRead(ContrastContext contrastContext, MultipartItem multipartItem) {
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        Iterator<k> iterator = this.manager.getEnabledInputAwareRules(contrastContext).iterator();
        if (!iterator.hasNext()) {
            return;
        }
        String string = multipartItem.getFileName();
        String string2 = multipartItem.getFieldName();
        String string3 = multipartItem.getContentType();
        boolean bl2 = !I.a("Content-Type", string3);
        String string4 = null;
        while (iterator.hasNext()) {
            k k2 = iterator.next();
            if (bl2 && k2.appliesToInputType(UserInputDTM.InputType.MULTIPART_CONTENT_TYPE)) {
                this.scanMultipartContentType(contrastContext, k2, string3, string2);
            }
            if (k2.appliesToInputType(UserInputDTM.InputType.MULTIPART_FILE_NAME)) {
                if (string4 == null) {
                    string4 = a.a(multipartItem.getValue(), UserInputDTM.InputType.MULTIPART_VALUE);
                }
                this.scanMultipartFileName(contrastContext, k2, string, string4);
            }
            if (!k2.appliesToInputType(UserInputDTM.InputType.MULTIPART_FIELD_NAME)) continue;
            if (string4 == null) {
                string4 = a.a(multipartItem.getValue(), UserInputDTM.InputType.MULTIPART_VALUE);
            }
            this.scanMultipartName(contrastContext, k2, string2, string4);
        }
    }

    private void scanMultipartContentType(ContrastContext contrastContext, k k2, String string, String string2) {
        if (string == null || string.isEmpty()) {
            logger.trace("Ignoring empty multipart content type");
            return;
        }
        v v2 = this.evaluate(contrastContext, UserInputDTM.InputType.MULTIPART_CONTENT_TYPE, null, string, k2);
        r r2 = v2.a();
        this.logResult(contrastContext, r2, k2, "Content-Type of Multipart field", string2, string);
        if (r2 == r.a) {
            return;
        }
        O o2 = new O(this.buildMultipartParameterContentType(string2, string).filters(v2.b()).build(), r2 == r.c);
        this.saveInput(contrastContext, k2, o2);
    }

    private void scanMultipartFileName(ContrastContext contrastContext, k k2, String string, String string2) {
        if (string == null || string.isEmpty()) {
            logger.trace("Ignoring empty multipart file name");
            return;
        }
        String string3 = "filename";
        v v2 = this.evaluate(contrastContext, UserInputDTM.InputType.MULTIPART_FILE_NAME, "filename", string, k2);
        r r2 = v2.a();
        this.logResult(contrastContext, r2, k2, "Multipart name", string, string2);
        if (r2 == r.a) {
            return;
        }
        O o2 = new O(this.buildMultipartParameterName("filename", string).filters(v2.b()).build(), r2 == r.c);
        this.saveInput(contrastContext, k2, o2);
    }

    private void scanMultipartName(ContrastContext contrastContext, k k2, String string, String string2) {
        if (string == null || string.isEmpty()) {
            logger.trace("Ignoring empty multipart name");
            return;
        }
        v v2 = this.evaluate(contrastContext, UserInputDTM.InputType.MULTIPART_FIELD_NAME, string, string, k2);
        r r2 = v2.a();
        this.logResult(contrastContext, r2, k2, "Multipart field", string, string2);
        if (r2 == r.a) {
            return;
        }
        O o2 = new O(this.buildMultipartParameterFieldName(string, string2).filters(v2.b()).build(), r2 == r.c);
        this.saveInput(contrastContext, k2, o2);
    }

    private void scanMultipartValue(ContrastContext contrastContext, k k2, String string, String string2) {
        if (string2 == null || string2.isEmpty()) {
            logger.trace("Ignoring empty multipart value");
            return;
        }
        v v2 = this.evaluate(contrastContext, UserInputDTM.InputType.MULTIPART_VALUE, string2, string2, k2);
        r r2 = v2.a();
        this.logResult(contrastContext, r2, k2, "Multipart value", string2, string2);
        if (r2 == r.a) {
            return;
        }
        O o2 = new O(this.buildMultipartParameterValue(string, string2).filters(v2.b()).build(), true);
        this.saveInput(contrastContext, k2, o2);
    }

    private UserInputDTM.Builder buildMultipartParameterContentType(String string, String string2) {
        return UserInputDTM.builder().name(string).value(string2).type(UserInputDTM.InputType.MULTIPART_CONTENT_TYPE);
    }

    private UserInputDTM.Builder buildMultipartParameterFieldName(String string, String string2) {
        return UserInputDTM.builder().name(string).value(string2).type(UserInputDTM.InputType.MULTIPART_FIELD_NAME);
    }

    private UserInputDTM.Builder buildMultipartParameterName(String string, String string2) {
        return UserInputDTM.builder().name(string).value(string2).type(UserInputDTM.InputType.MULTIPART_FILE_NAME);
    }

    private UserInputDTM.Builder buildMultipartParameterValue(String string, String string2) {
        return UserInputDTM.builder().name(string).value(string2).type(UserInputDTM.InputType.MULTIPART_VALUE);
    }
}

