/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.route;

import com.contrastsecurity.agent.Contrast;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpRequest;
import java.lang.reflect.Method;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;

@DontObfuscate
public final class RouteCoverageUtil {
    private static final Pattern GENERATED_SIGNATURE_PATTERN = Pattern.compile("\\$\\$EnhancerBySpringCGLIB\\$\\$[a-f0-9]+$");
    private static final Pattern LAMBDA_SIGNATURE_PATTERN = Pattern.compile("\\$\\$Lambda[$/xa-f0-9]+$");

    public static HttpRequest getRequestForObservableRoute(ContrastContext contrastContext, Supplier<Contrast.a> supplier) {
        if (Contrast.a.c != supplier.get() || contrastContext.application().current() == null) {
            return null;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        return httpRequest != null && !httpRequest.hasBeenObserved() ? httpRequest : null;
    }

    public static String buildRouteSignature(Method method, Function<String, String> function) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = function.apply(method.getDeclaringClass().getName());
        stringBuilder.append(string);
        stringBuilder.append('.');
        stringBuilder.append(method.getName());
        stringBuilder.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            stringBuilder.append(classArray[i2].getName());
            if (i2 >= classArray.length - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public static String stripGeneratedProxySignatures(String string) {
        if (string == null) {
            return null;
        }
        string = GENERATED_SIGNATURE_PATTERN.matcher(string).replaceFirst("");
        string = LAMBDA_SIGNATURE_PATTERN.matcher(string).replaceFirst("\\$\\$LAMBDA\\$\\$");
        return string;
    }

    private RouteCoverageUtil() {
    }
}

