/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Purgeable;
import com.contrastsecurity.agent.commons.e;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.enums.LogContextSwitch;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.agent.telemetry.metrics.Counter;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.telemetry.metrics.i;
import com.contrastsecurity.agent.weakmap.ConcurrentReferenceHashMap;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.time.Duration;
import java.util.Objects;
import java.util.Set;

@DontObfuscate
@o
public class AssessmentManager
implements Purgeable {
    private final Clock clock;
    private final Config config;
    private final i requestTimeMetric;
    private final Counter snapshotCacheHit;
    private final Counter snapshotCacheMiss;
    private final ConcurrentReferenceHashMap<AssessmentContext, Boolean> assessmentContexts;
    private int contextsCreated;
    private long totalMapSize;
    private volatile boolean enableCaptureRecentFindings;
    private static final int DEFAULT_TRACEMAP_SIZE = 75;
    private static final int MINIMUM_CONTEXTS_BEFORE_PREDICTING_TRACEMAP_SIZE = 5;
    private static final Logger logger = LoggerFactory.getLogger(AssessmentManager.class);

    @q
    public static i buildRequestTimeMetric(TelemetryMetrics telemetryMetrics) {
        return telemetryMetrics.newTimer("requestTime", TelemetryMetrics.TelemetryCategory.ASSESS).a("Records total time taken to handle requests").a(Duration.ofNanos(10000L), Duration.ofNanos(100000L), Duration.ofNanos(500000L), Duration.ofMillis(1L), Duration.ofMillis(5L), Duration.ofMillis(10L), Duration.ofMillis(50L), Duration.ofMillis(100L), Duration.ofMillis(250L), Duration.ofMillis(500L), Duration.ofSeconds(1L), Duration.ofSeconds(10L), Duration.ofMinutes(1L)).a("aspect", "REQUEST_HANDLING").g();
    }

    public AssessmentManager(Clock clock, Config config, TelemetryMetrics telemetryMetrics) {
        this.clock = clock;
        this.config = config;
        Objects.requireNonNull(telemetryMetrics);
        this.requestTimeMetric = AssessmentManager.buildRequestTimeMetric(telemetryMetrics);
        this.assessmentContexts = new ConcurrentReferenceHashMap(200, 0.75f, config.getInt(ConfigProperty.ASSESS_CONTEXT_MAP_CONCURRENCY_LEVEL), ConcurrentReferenceHashMap.ReferenceType.WEAK, ConcurrentReferenceHashMap.ReferenceType.STRONG, null, false);
        this.snapshotCacheHit = telemetryMetrics.newCounter("snapshotCacheHitCount", TelemetryMetrics.TelemetryCategory.ASSESS).withDescription("The number snapshot cache hits in Assess").register();
        this.snapshotCacheMiss = telemetryMetrics.newCounter("snapshotCacheMissCount", TelemetryMetrics.TelemetryCategory.ASSESS).withDescription("The number snapshot cache misses in Assess").register();
    }

    public AssessmentContext newContext(ContrastContext contrastContext) {
        AssessmentContext assessmentContext = contrastContext.assessment();
        if (assessmentContext != null && !assessmentContext.isJumpedContexts()) {
            if (LogContextSwitch.enabled()) {
                logger.debug("{} - AssessmentManager.newContext() clearing AssessmentContext {}", (Object)contrastContext.http().identities(), (Object)assessmentContext.toSummaryString());
            }
            assessmentContext.clear();
        }
        int n2 = this.contextsCreated > 5 ? Math.max((int)Math.min(this.totalMapSize / (long)this.contextsCreated, 250L), 20) : 75;
        AssessmentContext assessmentContext2 = new AssessmentContext(this.config, this.clock, n2, this.snapshotCacheHit, this.snapshotCacheMiss, this.requestTimeMetric);
        contrastContext.assessment(assessmentContext2);
        if (this.enableCaptureRecentFindings) {
            assessmentContext2.enableCaptureRecentFindings();
        }
        this.assessmentContexts.put(assessmentContext2, Boolean.TRUE);
        return assessmentContext2;
    }

    public void onContextClearing(int n2) {
        ++this.contextsCreated;
        this.totalMapSize += (long)n2;
    }

    @q
    public void enableCaptureRecentFindings() {
        this.enableCaptureRecentFindings = true;
    }

    @Override
    public e purgeStale() {
        int n2 = this.assessmentContexts.size();
        int n3 = 0;
        for (AssessmentContext assessmentContext : this.assessmentContexts.keySet()) {
            n3 += assessmentContext.updateLastAccess() ? 1 : 0;
        }
        this.assessmentContexts.purgeStaleEntries();
        return new e(n2, n2 - n3);
    }

    public Set<AssessmentContext> cachedContexts() {
        return this.assessmentContexts.keySet();
    }
}

